/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.RenderType.ColorLogicProvider;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderFormat;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class AbstractRenderType
extends RenderType {
    private static final Map<SkinRenderFormat, Supplier<IRenderTypeBuilder>> MAPPER = AbstractRenderType._make(it -> {
        it.put(SkinRenderFormat.LINE, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.DEBUG_LINES, f_173104_));
        it.put(SkinRenderFormat.LINE_STRIP, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.DEBUG_LINE_STRIP, f_173104_));
        it.put(SkinRenderFormat.IMAGE, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85820_, VertexFormat.Mode.QUADS, f_173103_).overlay().lightmap());
        it.put(SkinRenderFormat.BLIT_MASK, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.TRIANGLES, f_173104_));
        it.put(SkinRenderFormat.GUI_COLOR, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, f_173104_));
        it.put(SkinRenderFormat.GUI_IMAGE, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85817_, VertexFormat.Mode.QUADS, f_173102_));
        it.put(SkinRenderFormat.GUI_HIGHLIGHTED_TEXT, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85814_, VertexFormat.Mode.QUADS, f_173100_));
        it.put(SkinRenderFormat.BLOCK, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_));
        it.put(SkinRenderFormat.BLOCK_CUTOUT, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173113_));
        it.put(SkinRenderFormat.ENTITY_CUTOUT, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173113_));
        it.put(SkinRenderFormat.ENTITY_CUTOUT_NO_CULL, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173114_));
        it.put(SkinRenderFormat.ENTITY_TRANSLUCENT, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173065_));
        it.put(SkinRenderFormat.ENTITY_ALPHA, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173072_));
        it.put(SkinRenderFormat.SKIN_FACE_SOLID, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_).overlay().lightmap());
        it.put(SkinRenderFormat.SKIN_FACE_TRANSLUCENT, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173112_).overlay().lightmap());
        it.put(SkinRenderFormat.SKIN_FACE_LIGHTING, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173071_).overlay().lightmap());
        it.put(SkinRenderFormat.SKIN_FACE_LIGHTING_TRANSLUCENT, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173071_).overlay().lightmap());
        it.put(SkinRenderFormat.SKIN_FACE_TEXTURE, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173113_).overlay().lightmap());
        it.put(SkinRenderFormat.SKIN_FACE_LIGHTING_TEXTURE, () -> AbstractRenderType._builder(DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, f_173074_).overlay().lightmap());
    });

    public AbstractRenderType(String name, RenderType delegate, boolean affectsCrumbling, boolean sortUpload, Runnable setupRenderState, Runnable clearRenderState) {
        super(name, delegate.m_110508_(), delegate.m_173186_(), delegate.m_110507_(), affectsCrumbling, sortUpload, () -> {
            delegate.m_110185_();
            setupRenderState.run();
        }, () -> {
            clearRenderState.run();
            delegate.m_110188_();
        });
    }

    public static IRenderTypeBuilder builder(SkinRenderFormat format) {
        Supplier<IRenderTypeBuilder> provider = MAPPER.get((Object)format);
        if (provider != null) {
            return provider.get();
        }
        throw new RuntimeException("can't supported render mode");
    }

    private static Builder _builder(VertexFormat format, VertexFormat.Mode mode, RenderStateShard.ShaderStateShard shader) {
        Builder builder = new Builder(format, mode);
        builder.stateBuilder.m_173292_(shader);
        return builder;
    }

    private static <T, U> HashMap<T, U> _make(Consumer<HashMap<T, U>> consumer) {
        HashMap map = new HashMap();
        consumer.accept(map);
        return map;
    }

    public static class Builder
    implements IRenderTypeBuilder {
        private static final Map<IRenderTypeBuilder.Texturing, RenderStateShard.TexturingStateShard> TABLE_TEXTURING = AbstractRenderType._make(it -> {});
        private static final Map<IRenderTypeBuilder.Target, RenderStateShard.OutputStateShard> TABLE_OUTPUT = AbstractRenderType._make(it -> {
            it.put(IRenderTypeBuilder.Target.MAIN, f_110123_);
            it.put(IRenderTypeBuilder.Target.OUTLINE, f_110124_);
            it.put(IRenderTypeBuilder.Target.TRANSLUCENT, f_110125_);
            it.put(IRenderTypeBuilder.Target.CLOUDS, f_110128_);
            it.put(IRenderTypeBuilder.Target.WEATHER, f_110127_);
            it.put(IRenderTypeBuilder.Target.PARTICLES, f_110126_);
            it.put(IRenderTypeBuilder.Target.ITEM_ENTITY, f_110129_);
        });
        private static final Map<IRenderTypeBuilder.Transparency, RenderStateShard.TransparencyStateShard> TABLE_TRANSPARENCY = AbstractRenderType._make(it -> {
            it.put(IRenderTypeBuilder.Transparency.DEFAULT, f_110139_);
            it.put(IRenderTypeBuilder.Transparency.TRANSLUCENT, f_110139_);
            it.put(IRenderTypeBuilder.Transparency.NONE, f_110134_);
        });
        private static final Map<IRenderTypeBuilder.WriteMask, RenderStateShard.WriteMaskStateShard> TABLE_WRITE_MASK = AbstractRenderType._make(it -> {
            it.put(IRenderTypeBuilder.WriteMask.NONE, new RenderStateShard.WriteMaskStateShard(false, false));
            it.put(IRenderTypeBuilder.WriteMask.COLOR_DEPTH_WRITE, f_110114_);
            it.put(IRenderTypeBuilder.WriteMask.COLOR_WRITE, f_110115_);
            it.put(IRenderTypeBuilder.WriteMask.DEPTH_WRITE, f_110116_);
        });
        private static final Map<IRenderTypeBuilder.DepthTest, RenderStateShard.DepthTestStateShard> TABLE_DEPTH_TEST = AbstractRenderType._make(it -> {
            it.put(IRenderTypeBuilder.DepthTest.NONE, f_110111_);
            it.put(IRenderTypeBuilder.DepthTest.EQUAL, f_110112_);
            it.put(IRenderTypeBuilder.DepthTest.LESS_EQUAL, f_110113_);
        });
        boolean isOutline = false;
        boolean affectsCrumbling = false;
        boolean sortOnUpload = false;
        RenderType.CompositeState.CompositeStateBuilder stateBuilder = RenderType.CompositeState.m_110628_();
        final VertexFormat format;
        final VertexFormat.Mode mode;

        private Builder(VertexFormat format, VertexFormat.Mode mode) {
            this.format = format;
            this.mode = mode;
            this.setupDefault();
        }

        private void setupDefault() {
            this.stateBuilder = this.stateBuilder.m_110661_(f_110110_);
        }

        @Override
        public IRenderTypeBuilder texture(ResourceLocation texture, boolean blur, boolean mipmap) {
            this.stateBuilder = this.stateBuilder.m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, blur, mipmap));
            return this;
        }

        @Override
        public IRenderTypeBuilder texturing(IRenderTypeBuilder.Texturing texturing) {
            this.stateBuilder = this.stateBuilder.m_110683_(TABLE_TEXTURING.getOrDefault((Object)texturing, f_110148_));
            return this;
        }

        @Override
        public IRenderTypeBuilder target(IRenderTypeBuilder.Target target) {
            this.stateBuilder = this.stateBuilder.m_110675_(TABLE_OUTPUT.getOrDefault((Object)target, f_110123_));
            return this;
        }

        @Override
        public IRenderTypeBuilder transparency(IRenderTypeBuilder.Transparency transparency) {
            this.stateBuilder = this.stateBuilder.m_110685_(TABLE_TRANSPARENCY.getOrDefault((Object)transparency, f_110134_));
            return this;
        }

        @Override
        public IRenderTypeBuilder writeMask(IRenderTypeBuilder.WriteMask mask) {
            this.stateBuilder = this.stateBuilder.m_110687_(TABLE_WRITE_MASK.getOrDefault((Object)mask, f_110114_));
            return this;
        }

        @Override
        public IRenderTypeBuilder depthTest(IRenderTypeBuilder.DepthTest test) {
            this.stateBuilder = this.stateBuilder.m_110663_(TABLE_DEPTH_TEST.getOrDefault((Object)test, f_110111_));
            return this;
        }

        @Override
        public IRenderTypeBuilder colorLogic(IRenderTypeBuilder.ColorLogic state) {
            this.stateBuilder = ColorLogicProvider.CompositeState.CompositeStateBuilder.setColorLogicState(this.stateBuilder, state);
            return this;
        }

        @Override
        public IRenderTypeBuilder polygonOffset(float factor, float units) {
            this.stateBuilder = this.stateBuilder.m_110669_(new RenderStateShard.LayeringStateShard("aw_polygon_offset_" + units, () -> {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)factor, (float)units);
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }));
            return this;
        }

        @Override
        public IRenderTypeBuilder lineWidth(float width) {
            this.stateBuilder = this.stateBuilder.m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(width)));
            return this;
        }

        @Override
        public IRenderTypeBuilder stroke(float width) {
            this.stateBuilder = this.stateBuilder.m_110669_(new RenderStateShard.LayeringStateShard("aw_custom_line", () -> {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)width);
            }, () -> GL11.glPolygonMode((int)1032, (int)6914)));
            return this;
        }

        @Override
        public IRenderTypeBuilder cull() {
            this.stateBuilder = this.stateBuilder.m_110661_(f_110158_);
            return this;
        }

        @Override
        public IRenderTypeBuilder lightmap() {
            this.stateBuilder = this.stateBuilder.m_110671_(f_110152_);
            return this;
        }

        @Override
        public IRenderTypeBuilder overlay() {
            this.stateBuilder = this.stateBuilder.m_110677_(f_110154_);
            return this;
        }

        @Override
        public IRenderTypeBuilder outline() {
            this.isOutline = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder crumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        @Override
        public IRenderTypeBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        @Override
        public RenderType build(String name) {
            return RenderType.m_173215_((String)name, (VertexFormat)this.format, (VertexFormat.Mode)this.mode, (int)256, (boolean)this.affectsCrumbling, (boolean)this.sortOnUpload, (RenderType.CompositeState)this.stateBuilder.m_110691_(this.isOutline));
        }

        public Builder or(Function<RenderType.CompositeState.CompositeStateBuilder, RenderType.CompositeState.CompositeStateBuilder> builder) {
            this.stateBuilder = builder.apply(this.stateBuilder);
            return this;
        }
    }
}

