/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateOutfitMakerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateOutfitMakerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.field = buffer.readEnum(Field.class);
        this.fieldValue = this.field.accessor.read(buffer);
    }

    public UpdateOutfitMakerPacket(OutfitMakerBlockEntity entity, Field field, Object value) {
        this.pos = entity.m_58899_();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum(this.field);
        this.field.accessor.write(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockUtils.performBatch(() -> this.accept2(packetHandler, player));
    }

    private void accept2(IServerPacketHandler packetHandler, ServerPlayer player) {
        switch (this.field.ordinal()) {
            case 2: {
                if (!ModPermissions.OUTFIT_MAKER_MAKE.accept((Player)player)) {
                    return;
                }
                if (!(player.f_36096_ instanceof OutfitMakerMenu)) break;
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                GameProfile profile = DataSerializers.readGameProfile(nbt);
                ((OutfitMakerMenu)player.f_36096_).saveArmourItem((Player)player, profile);
                break;
            }
            case 0: 
            case 1: {
                BlockEntity entity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
                if (!(entity instanceof OutfitMakerBlockEntity)) break;
                this.field.accessor.set((OutfitMakerBlockEntity)entity, this.fieldValue);
                break;
            }
        }
    }

    public static enum Field implements DataAccessor.Provider<OutfitMakerBlockEntity>
    {
        ITEM_NAME(OutfitMakerBlockEntity::getItemName, OutfitMakerBlockEntity::setItemName, DataSerializers.STRING),
        ITEM_FLAVOUR(OutfitMakerBlockEntity::getItemFlavour, OutfitMakerBlockEntity::setItemFlavour, DataSerializers.STRING),
        ITEM_CRAFTING(null, null, DataSerializers.COMPOUND_TAG);

        private final DataAccessor<OutfitMakerBlockEntity, Object> accessor;

        private <T> Field(Function<OutfitMakerBlockEntity, T> supplier, BiConsumer<OutfitMakerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer) {
            this.accessor = DataAccessor.erased(dataSerializer, supplier, applier);
        }

        @Override
        public DataAccessor<OutfitMakerBlockEntity, Object> getAccessor() {
            return this.accessor;
        }
    }
}

