/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Constructor;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.permission.BlockPermission;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateArmourerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateArmourerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.field = buffer.readEnum(Field.class);
        this.fieldValue = this.field.accessor.read(buffer);
    }

    public UpdateArmourerPacket(ArmourerBlockEntity entity, Field field, Object value) {
        this.pos = entity.m_58899_();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeEnum(this.field);
        this.field.accessor.write(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
        if (!(blockEntity instanceof ArmourerBlockEntity) || !(player.f_36096_ instanceof ArmourerMenu)) {
            return;
        }
        BlockUtils.performBatch(() -> this.acceptFieldUpdate((Player)player, (ArmourerBlockEntity)blockEntity, (ArmourerMenu)player.f_36096_));
    }

    private void acceptFieldUpdate(Player player, ArmourerBlockEntity blockEntity, ArmourerMenu container) {
        Level level = PropertyProvider.getLevel((Entity)player);
        String playerName = player.m_5446_().getString();
        if (level == null || !this.field.permission.accept(blockEntity, player)) {
            return;
        }
        switch (this.field.ordinal()) {
            case 7: {
                container.loadArmourItem(player);
                break;
            }
            case 8: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept save action of the {}, nbt: {}", playerName, nbt);
                GameProfile profile = DataSerializers.readGameProfile(nbt);
                container.saveArmourItem(player, profile, null, null);
                break;
            }
            case 4: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept clear action of the {}, nbt: {}", playerName, nbt);
                CubeChangesCollector collector = new CubeChangesCollector(blockEntity.m_58904_());
                ISkinPartType partType = SkinPartTypes.byName(nbt.m_128461_("PartType"));
                if (nbt.m_128471_("Cubes")) {
                    blockEntity.clearCubes(collector, partType);
                }
                if (nbt.m_128471_("Paints")) {
                    blockEntity.clearPaintData(collector, partType);
                }
                if (nbt.m_128471_("Markers") && !nbt.m_128471_("Cubes")) {
                    blockEntity.clearMarkers(collector, partType);
                }
                collector.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.clear"), player);
                break;
            }
            case 5: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept copy action of the {}, nbt: {}", playerName, nbt);
                try {
                    boolean isMirror = nbt.m_128471_("Mirror");
                    boolean isCopyPaintData = nbt.m_128471_("Paints");
                    ISkinPartType sourcePartType = SkinPartTypes.byName(nbt.m_128461_("Source"));
                    ISkinPartType destinationPartType = SkinPartTypes.byName(nbt.m_128461_("Destination"));
                    CubeChangesCollector collector = new CubeChangesCollector(blockEntity.m_58904_());
                    blockEntity.copyCubes(collector, sourcePartType, destinationPartType, isMirror);
                    if (isCopyPaintData) {
                        blockEntity.copyPaintData(collector, sourcePartType, destinationPartType, isMirror);
                    }
                    collector.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.copy"), player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                ModLog.info("accept replace action of the {}, nbt: {}", playerName, nbt);
                try {
                    ItemStack source = Constructor.parseOptional(ItemStack.class, level.m_9598_(), nbt.m_128469_("Source"));
                    ItemStack destination = Constructor.parseOptional(ItemStack.class, level.m_9598_(), nbt.m_128469_("Destination"));
                    CubeReplacingEvent event = new CubeReplacingEvent(source, destination);
                    event.keepColor = nbt.m_128471_("KeepColor");
                    event.keepPaintType = nbt.m_128471_("KeepPaintType");
                    if (event.isEmptySource && event.isEmptyDestination) {
                        return;
                    }
                    CubeChangesCollector collector = new CubeChangesCollector(blockEntity.m_58904_());
                    blockEntity.replaceCubes(collector, SkinPartTypes.UNKNOWN, event);
                    collector.submit((Component)Component.m_237115_((String)"action.armourers_workshop.block.replace"), player);
                    player.m_213846_((Component)Component.m_237110_((String)"inventory.armourers_workshop.armourer.dialog.replace.success", (Object[])new Object[]{collector.getTotal()}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                this.field.accessor.set(blockEntity, this.fieldValue);
            }
        }
    }

    public static enum Field implements DataAccessor.Provider<ArmourerBlockEntity>
    {
        FLAGS(ArmourerBlockEntity::getFlags, ArmourerBlockEntity::setFlags, DataSerializers.INT, ModPermissions.ARMOURER_SETTING),
        SKIN_TYPE(ArmourerBlockEntity::getSkinType, ArmourerBlockEntity::setSkinType, DataSerializers.SKIN_TYPE, ModPermissions.ARMOURER_SETTING),
        SKIN_PROPERTIES(ArmourerBlockEntity::getSkinProperties, ArmourerBlockEntity::setSkinProperties, DataSerializers.SKIN_PROPERTIES, ModPermissions.ARMOURER_SETTING),
        TEXTURE_DESCRIPTOR(ArmourerBlockEntity::getTextureDescriptor, ArmourerBlockEntity::setTextureDescriptor, DataSerializers.PLAYER_TEXTURE, ModPermissions.ARMOURER_SETTING),
        ITEM_CLEAR(null, null, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_CLEAR),
        ITEM_COPY(null, null, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_COPY),
        ITEM_REPLACE(null, null, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_REPLACE),
        ITEM_LOAD(null, null, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_LOAD),
        ITEM_SAVE(null, null, DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_SAVE);

        private final BlockPermission permission;
        private final DataAccessor<ArmourerBlockEntity, Object> accessor;

        private <T> Field(Function<ArmourerBlockEntity, T> supplier, BiConsumer<ArmourerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer, BlockPermission permission) {
            this.accessor = DataAccessor.erased(dataSerializer, supplier, applier);
            this.permission = permission;
        }

        @Override
        public DataAccessor<ArmourerBlockEntity, Object> getAccessor() {
            return this.accessor;
        }

        public BlockPermission getPermission() {
            return this.permission;
        }
    }
}

