/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AdvancedExportPacket
extends CustomPacket {
    private final BlockPos pos;

    public AdvancedExportPacket(AdvancedBuilderBlockEntity blockEntity) {
        this.pos = blockEntity.m_58899_();
    }

    public AdvancedExportPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity blockEntity = PropertyProvider.getLevel((Entity)player).m_7702_(this.pos);
        if (!(blockEntity instanceof AdvancedBuilderBlockEntity) || !(player.f_36096_ instanceof AdvancedBuilderMenu)) {
            this.abort((Player)player, "unauthorized", "user status is incorrect");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_EXPORT.accept((Player)player)) {
            this.abort((Player)player, "export", "prohibited by the config file");
            return;
        }
        this.accept((Player)player, "export");
        AdvancedBuilderBlockEntity blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
        blockEntity1.exportFromDocument(player);
    }

    private void accept(Player player, String op) {
        String playerName = player.m_6302_();
        ModLog.info("accept {} request of the '{}'", op, playerName);
    }

    private void abort(Player player, String op, String reason) {
        String playerName = player.m_6302_();
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, playerName, reason);
    }
}

