/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item.impl;

import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.network.UpdateBlockColorPacket;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface IPaintToolApplier {
    default public InteractionResult usePaintTool(UseOnContext context) {
        if (!this.shouldUseTool(context)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        IPaintToolSelector selector = this.createPaintToolSelector(blockEntity, context);
        IPaintToolAction action = null;
        if (selector != null) {
            action = this.createPaintToolAction(context);
        }
        if (selector == null || action == null) {
            return InteractionResult.PASS;
        }
        CubePaintingEvent event = new CubePaintingEvent(selector, action);
        CubeChangesCollector collector = new CubeChangesCollector(context.m_43725_());
        if (event.prepare(collector, context)) {
            event.apply(collector, context);
            UpdateBlockColorPacket packet = new UpdateBlockColorPacket(context, event);
            NetworkManager.sendToServer(packet);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public IPaintToolAction createPaintToolAction(UseOnContext var1);

    @Nullable
    public IPaintToolSelector createPaintToolSelector(UseOnContext var1);

    @Nullable
    default public IPaintToolSelector createPaintToolSelector(BlockEntity blockEntity, UseOnContext context) {
        if (blockEntity instanceof IPaintToolSelector.Provider) {
            return ((IPaintToolSelector.Provider)blockEntity).createPaintToolSelector(context);
        }
        if (blockEntity instanceof IPaintable) {
            return this.createPaintToolSelector(context);
        }
        return null;
    }

    public boolean shouldUseTool(UseOnContext var1);
}

