/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IDataComponentType;
import moe.plushie.armourers_workshop.api.common.IItemColorProvider;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockItem;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.item.impl.IPaintProvider;
import moe.plushie.armourers_workshop.core.item.impl.IPaintToolPicker;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SkinCubeItem
extends AbstractBlockItem
implements IItemColorProvider,
IPaintToolPicker {
    public SkinCubeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public InteractionResult usePickTool(Level level, BlockPos pos, Direction dir, BlockEntity blockEntity, UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        if (blockEntity instanceof IPaintProvider) {
            this.setItemColor(itemStack, ((IPaintProvider)blockEntity).getColor());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (entityTag != null && blockEntity != null) {
            CompoundTag newNBT = StorageAPI.saveFullData(blockEntity, level.m_9598_());
            newNBT.m_128365_("Color", (Tag)entityTag.m_128469_("Color"));
            StorageAPI.loadFullData(blockEntity, newNBT, level.m_9598_());
        }
        return super.m_7274_(pos, level, player, itemStack, blockState);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        BlockPaintColor paintColor = this.getItemColors(itemStack);
        if (paintColor != null && paintColor.isPureColor()) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor.get(Direction.NORTH), true));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, IPaintColor paintColor) {
        CompoundTag entityTag = new CompoundTag();
        BlockPaintColor color = new BlockPaintColor(paintColor);
        CompoundTag oldEntityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (oldEntityTag != null) {
            entityTag.m_128391_(oldEntityTag);
        }
        OptionalAPI.putOptionalBlockPaintColor(entityTag, "Color", color, null);
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_FLAGS.get(), 1);
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get(), entityTag);
    }

    @Override
    public IPaintColor getItemColor(ItemStack itemStack) {
        return ColorUtils.getColorOrDefault(itemStack, PaintColor.WHITE);
    }

    @Nullable
    public BlockPaintColor getItemColors(ItemStack itemStack) {
        return ColorUtils.getBlockColor(itemStack);
    }
}

