/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolAction;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;

public class HueToolItem
extends PaintbrushItem {
    public HueToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.CHANGE_HUE);
        builder.accept(PaintingToolOptions.CHANGE_SATURATION);
        builder.accept(PaintingToolOptions.CHANGE_BRIGHTNESS);
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
        super.createToolProperties(builder);
    }

    @Override
    public IPaintToolAction createPaintToolAction(UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        boolean hue = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_HUE);
        boolean saturation = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_SATURATION);
        boolean brightness = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_BRIGHTNESS);
        boolean paintType = ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_TYPE);
        return new CubePaintingEvent.HueAction(paintColor, hue, saturation, brightness, paintType);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<Component> tooltips) {
        IPaintColor paintColor = this.getItemColor(itemStack, PaintColor.WHITE);
        tooltips.addAll(ColorUtils.getColorTooltips(paintColor, true));
    }

    @Override
    public IRegistryKey<SoundEvent> getItemSoundEvent(UseOnContext context) {
        return ModSounds.PAINT;
    }
}

