/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.painting.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.ExtendedFaceRenderer;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinCubeBlockRenderer<T extends BlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private static float markerAlpha = 0.0f;
    private static long lastWorldTimeUpdate;

    public SkinCubeBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public static void updateAlpha(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        if (level == null || lastWorldTimeUpdate == level.m_46467_()) {
            return;
        }
        lastWorldTimeUpdate = level.m_46467_();
        if (SkinCubeBlockRenderer.isPlayerHoldingPaintingTool()) {
            if ((markerAlpha += 0.25f) > 1.0f) {
                markerAlpha = 1.0f;
            }
        } else if ((markerAlpha -= 0.25f) < 0.0f) {
            markerAlpha = 0.0f;
        }
    }

    private static boolean isPlayerHoldingPaintingTool() {
        Player player = EnvironmentManager.getPlayer();
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41720_() instanceof IBlockPaintViewer) {
            return true;
        }
        if (itemStack.m_150930_((Item)ModItems.COLOR_PICKER.get())) {
            return true;
        }
        return itemStack.m_150930_((Item)ModItems.SOAP.get());
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        SkinCubeBlockRenderer.updateAlpha(entity);
        if (!(markerAlpha > 0.0f)) {
            return;
        }
        int alpha = (int)(markerAlpha * 255.0f);
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.IMAGE_MARKER);
        for (Direction direction : Direction.values()) {
            if (!((IPaintable)entity).shouldChangeColor(direction) || !((IPaintable)entity).hasColor(direction)) continue;
            IPaintColor paintColor = ((IPaintable)entity).getColor(direction);
            ExtendedFaceRenderer.renderMarker(0, 0, 0, direction, paintColor, alpha, light, overlay, poseStack, builder);
        }
    }
}

