/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AbstractAdvancedGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBlockGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedBoatGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedHorseGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedHumanGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedItemGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AdvancedMinecartGuideRenderer;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.model.BakedModel.ABI;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinModelManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedBuilderBlockRenderer<T extends AdvancedBuilderBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private static final ImmutableMap<SkinDocumentType, AbstractAdvancedGuideRenderer> GUIDES = ImmutableMap.builder().put((Object)SkinDocumentTypes.GENERAL_ARMOR_HEAD, (Object)new AdvancedHumanGuideRenderer()).put((Object)SkinDocumentTypes.GENERAL_ARMOR_CHEST, (Object)new AdvancedHumanGuideRenderer()).put((Object)SkinDocumentTypes.GENERAL_ARMOR_FEET, (Object)new AdvancedHumanGuideRenderer()).put((Object)SkinDocumentTypes.GENERAL_ARMOR_LEGS, (Object)new AdvancedHumanGuideRenderer()).put((Object)SkinDocumentTypes.GENERAL_ARMOR_WINGS, (Object)new AdvancedHumanGuideRenderer()).put((Object)SkinDocumentTypes.GENERAL_ARMOR_OUTFIT, (Object)new AdvancedHumanGuideRenderer()).put((Object)SkinDocumentTypes.ITEM, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_AXE, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_HOE, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_SHOVEL, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_PICKAXE, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_SWORD, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_SHIELD, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_BOW, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_TRIDENT, (Object)new AdvancedItemGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_BOAT, (Object)new AdvancedBoatGuideRenderer()).put((Object)SkinDocumentTypes.ITEM_MINECART, (Object)new AdvancedMinecartGuideRenderer()).put((Object)SkinDocumentTypes.ENTITY_HORSE, (Object)new AdvancedHorseGuideRenderer()).put((Object)SkinDocumentTypes.BLOCK, (Object)new AdvancedBlockGuideRenderer()).build();
    ImmutableSet<ISkinPartType> USE_ITEM_TRANSFORMERS = ImmutableSet.builder().add((Object)SkinPartTypes.ITEM).add((Object)SkinPartTypes.ITEM_AXE).add((Object)SkinPartTypes.ITEM_HOE).add((Object)SkinPartTypes.ITEM_SHOVEL).add((Object)SkinPartTypes.ITEM_PICKAXE).add((Object)SkinPartTypes.ITEM_SWORD).add((Object)SkinPartTypes.ITEM_SHIELD).add((Object)SkinPartTypes.ITEM_BOW0).add((Object)SkinPartTypes.ITEM_BOW1).add((Object)SkinPartTypes.ITEM_BOW2).add((Object)SkinPartTypes.ITEM_BOW3).add((Object)SkinPartTypes.ITEM_TRIDENT).build();
    public static ArrayList<Vector3f> OUTPUTS = new ArrayList();
    public static HashSet<BakedSkinPart> RESULTS = new HashSet();

    public static void setOutput(int i, Vector3f pt) {
        while (i >= OUTPUTS.size()) {
            OUTPUTS.add(Vector3f.ZERO);
        }
        OUTPUTS.set(i, pt);
    }

    public static void setResult(Collection<BakedSkinPart> results) {
        RESULTS.clear();
        RESULTS.addAll(results);
    }

    public AdvancedBuilderBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        AbstractAdvancedGuideRenderer guideRenderer;
        poseStack.pushPose();
        poseStack.translate(((AdvancedBuilderBlockEntity)entity).offset.getX(), ((AdvancedBuilderBlockEntity)entity).offset.getY(), ((AdvancedBuilderBlockEntity)entity).offset.getZ());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(((AdvancedBuilderBlockEntity)entity).carmeScale.getX(), ((AdvancedBuilderBlockEntity)entity).carmeScale.getY(), ((AdvancedBuilderBlockEntity)entity).carmeScale.getZ());
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        SkinDocument document = ((AdvancedBuilderBlockEntity)entity).getDocument();
        SkinDocumentSettings settings = document.getSettings();
        if (settings.showsOrigin()) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(Vector3f.ZERO, 16.0f, poseStack, bufferSource);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
        if (settings.showsHelperModel() && (guideRenderer = (AbstractAdvancedGuideRenderer)GUIDES.get((Object)document.getType())) != null) {
            guideRenderer.render(document, poseStack, light, overlay, bufferSource);
        }
        BakedArmature armature = BakedArmature.defaultBy(document.getType().getSkinType());
        this.renderNode(document, document.getRoot(), armature, 0.0f, poseStack, bufferSource, light, overlay);
        poseStack.popPose();
        if (ModDebugger.advancedBuilder) {
            BlockState blockState = entity.m_58900_();
            BlockPos pos = entity.m_58899_();
            poseStack.pushPose();
            poseStack.translate(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_());
            ShapeTesselator.stroke(((AdvancedBuilderBlockEntity)entity).getRenderBoundingBox(blockState), UIColor.RED, poseStack, bufferSource);
            Vector3f origin = ((AdvancedBuilderBlockEntity)entity).getRenderOrigin();
            poseStack.translate(origin.getX(), origin.getY(), origin.getZ());
            ShapeTesselator.vector(Vector3f.ZERO, 1.0f, poseStack, bufferSource);
            poseStack.translate(((AdvancedBuilderBlockEntity)entity).carmeOffset.getX(), ((AdvancedBuilderBlockEntity)entity).carmeOffset.getY(), ((AdvancedBuilderBlockEntity)entity).carmeOffset.getZ());
            ShapeTesselator.vector(Vector3f.ZERO, 1.0f, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    protected void renderNode(SkinDocument document, SkinDocumentNode node, BakedArmature armature, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        SkinDescriptor descriptor;
        SkinRenderTesselator tesselator;
        IJointTransform transform;
        if (!node.isEnabled()) {
            return;
        }
        poseStack.pushPose();
        if (armature != null && node.isLocked() && (transform = armature.getTransform(node.getType())) != null) {
            transform.apply(poseStack);
        }
        if (node.isLocked() && this.USE_ITEM_TRANSFORMERS.contains((Object)node.getType())) {
            this.applyTransform(poseStack, document.getRoot(), document.getItemTransforms());
        }
        node.getTransform().apply(poseStack);
        if (node.isLocator()) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            ShapeTesselator.vector(Vector3f.ZERO, 16.0f, poseStack, bufferSource);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
        }
        if (node.isMirror()) {
            poseStack.scale(-1.0f, 1.0f, 1.0f);
        }
        if ((tesselator = SkinRenderTesselator.create(descriptor = node.getSkin(), Tickets.RENDERER)) != null) {
            tesselator.setLightmap(0xF000F0);
            tesselator.setPartialTicks(partialTicks);
            tesselator.setAnimationTicks(0.0f);
            tesselator.draw(poseStack, bufferSource);
        }
        for (SkinDocumentNode child : node.children()) {
            this.renderNode(document, child, armature, partialTicks, poseStack, bufferSource, light, overlay);
        }
        poseStack.popPose();
    }

    public void renderOutput(T entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int light, int overlay) {
        BlockPos pos = entity.m_58899_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(-pos.m_123341_()), (float)(-pos.m_123342_()), (float)(-pos.m_123343_()));
        if (OUTPUTS.size() >= 2) {
            // empty if block
        }
        poseStack.m_85849_();
    }

    protected void applyTransform(IPoseStack poseStack, SkinDocumentNode node, SkinItemTransforms itemTransforms) {
        if (itemTransforms != null) {
            ITransformf itemTransform = itemTransforms.get(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND);
            if (itemTransform != null) {
                poseStack.translate(0.0f, -2.0f, -2.0f);
                itemTransform.apply(poseStack);
            }
        } else {
            poseStack.translate(0.0f, -2.0f, -2.0f);
            MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
            BakedModel model = SkinModelManager.getInstance().getModel(node.getType(), null, ItemStack.f_41583_, (Entity)entity);
            float f1 = 16.0f;
            float f2 = 0.0625f;
            poseStack.scale(f1, f1, f1);
            ABI.applyTransform(model, poseStack, false, AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND);
            poseStack.scale(f2, f2, f2);
        }
    }

    public int m_142163_() {
        return 272;
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }

    public static class OutlineObjectBuilder
    implements SkinRenderBufferSource.ObjectBuilder {
        private final SkinRenderBufferSource.ObjectBuilder builder;

        public OutlineObjectBuilder(SkinRenderBufferSource.ObjectBuilder builder) {
            this.builder = builder;
        }

        @Override
        public int addPart(BakedSkinPart bakedPart, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRender, SkinRenderContext context) {
            int total = 0;
            if (RESULTS.contains(bakedPart)) {
                context.setOverlay(0x38FFFFFF);
                total = this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
                context.setOverlay(0);
            }
            if (total != 0) {
                shouldRender = false;
            }
            return this.builder.addPart(bakedPart, bakedSkin, scheme, shouldRender, context);
        }

        @Override
        public void addShape(Vector3f origin, SkinRenderContext context) {
            this.builder.addShape(origin, context);
        }

        @Override
        public void addShape(OpenVoxelShape shape, UIColor color, SkinRenderContext context) {
            this.builder.addShape(shape, color, context);
        }

        @Override
        public void addShape(BakedArmature armature, SkinRenderContext context) {
            this.builder.addShape(armature, context);
        }
    }
}

