/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.client.gui.widget.InventoryBox;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public abstract class PropertySettingView
extends UIView {
    private float cursorY = 0.0f;
    protected UICheckBox blockBed;
    protected UICheckBox blockEnderInventory;
    protected UICheckBox blockInventory;
    protected UILabel inventoryTitle;
    protected UILabel inventorySlot;
    protected InventoryBox inventoryBox;

    public PropertySettingView(CGRect rect, Collection<ISkinProperty<?>> properties) {
        super(rect);
        for (ISkinProperty<?> property : properties) {
            if (property.getDefaultValue() instanceof Boolean) {
                this.addCheckBox((ISkinProperty)ObjectUtils.unsafeCast(property));
            }
            if (property != SkinProperty.BLOCK_INVENTORY_WIDTH) continue;
            this.addInventoryBox();
        }
        this.setFrame(new CGRect(rect.x, rect.y, rect.width, this.cursorY));
        this.resolveConflicts();
        this.resolveSlots();
    }

    public void beginEditing() {
    }

    public abstract <T> void putValue(ISkinProperty<T> var1, T var2);

    public abstract <T> T getValue(ISkinProperty<T> var1);

    public void endEditing() {
    }

    protected void addCheckBox(ISkinProperty<Boolean> property) {
        UICheckBox checkBox = new UICheckBox(new CGRect(0.0f, this.cursorY, this.bounds().width, 10.0f));
        checkBox.setTitle(this.getDisplayText(property.getKey(), new Object[0]));
        checkBox.setTitleColor(UIColor.WHITE);
        checkBox.setTitleColor(UIColor.GRAY, 4);
        checkBox.setSelected(this.getValue(property));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)ObjectUtils.unsafeCast(c);
            self.beginEditing();
            self.putValue(property, checkBox1.isSelected());
            self.resolveConflicts();
            self.endEditing();
        });
        this.addSubview(checkBox);
        if (property == SkinProperty.BLOCK_BED) {
            checkBox.setFrame(checkBox.frame().insetBy(0.0f, 4.0f, 0.0f, 0.0f));
            this.blockBed = checkBox;
        }
        if (property == SkinProperty.BLOCK_ENDER_INVENTORY) {
            this.blockEnderInventory = checkBox;
        }
        if (property == SkinProperty.BLOCK_INVENTORY) {
            this.blockInventory = checkBox;
        }
        this.cursorY = checkBox.frame().getMaxY() + 2.0f;
    }

    protected void addInventoryBox() {
        this.inventoryTitle = new UILabel(new CGRect(0.0f, this.cursorY - 2.0f, this.bounds().width, 9.0f));
        this.inventorySlot = new UILabel(new CGRect(0.0f, this.cursorY + 6.0f, this.bounds().width, 9.0f));
        this.inventoryBox = new InventoryBox(new CGRect(0.0f, this.cursorY, 90.0f, 60.0f));
        this.inventoryTitle.setText(this.getDisplayText("label.inventorySize", new Object[0]));
        this.inventoryBox.addTarget(this, UIControl.Event.VALUE_CHANGED, PropertySettingView::setInventorySize);
        this.addSubview(this.inventoryTitle);
        this.addSubview(this.inventorySlot);
        this.addSubview(this.inventoryBox);
        this.cursorY = this.inventoryBox.frame().getMaxY() + 2.0f;
    }

    private void setInventorySize(UIControl sender) {
        CGPoint offset = this.inventoryBox.getOffset();
        int width = (int)(offset.x / 10.0f) + 1;
        int height = (int)(offset.y / 10.0f) + 1;
        this.beginEditing();
        this.putValue(SkinProperty.BLOCK_INVENTORY_WIDTH, width);
        this.putValue(SkinProperty.BLOCK_INVENTORY_HEIGHT, height);
        this.endEditing();
        this.resolveSlots();
    }

    private void resolveSlots() {
        if (this.inventorySlot == null) {
            return;
        }
        boolean isEnabled = this.getValue(SkinProperty.BLOCK_INVENTORY) != false && this.getValue(SkinProperty.BLOCK_ENDER_INVENTORY) == false;
        int width = this.getValue(SkinProperty.BLOCK_INVENTORY_WIDTH);
        int height = this.getValue(SkinProperty.BLOCK_INVENTORY_HEIGHT);
        this.inventorySlot.setText(this.getDisplayText("label.inventorySlots", width * height, width, height));
        this.inventoryBox.setOffset(new CGPoint(Math.max(width - 1, 0) * 10, Math.max(height - 1, 0) * 10));
        this.inventoryTitle.setHidden(!isEnabled);
        this.inventorySlot.setHidden(!isEnabled);
        this.inventoryBox.setHidden(!isEnabled);
    }

    private void resolveConflicts() {
        if (this.blockBed != null) {
            this.blockBed.setEnabled(this.getValue(SkinProperty.BLOCK_MULTIBLOCK));
            if (!this.blockBed.isEnabled() && this.blockBed.isSelected()) {
                this.blockBed.setSelected(false);
                this.putValue(SkinProperty.BLOCK_BED, false);
            }
        }
        if (this.blockEnderInventory != null) {
            this.blockEnderInventory.setEnabled(this.getValue(SkinProperty.BLOCK_INVENTORY) == false);
            if (!this.blockEnderInventory.isEnabled() && this.blockEnderInventory.isSelected()) {
                this.blockEnderInventory.setSelected(false);
                this.putValue(SkinProperty.BLOCK_ENDER_INVENTORY, false);
            }
        }
        if (this.blockInventory != null) {
            this.blockInventory.setEnabled(this.getValue(SkinProperty.BLOCK_ENDER_INVENTORY) == false);
            if (!this.blockInventory.isEnabled() && this.blockInventory.isSelected()) {
                this.blockInventory.setSelected(false);
                this.putValue(SkinProperty.BLOCK_INVENTORY, false);
            }
        }
        this.resolveSlots();
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return NSString.localizedString("armourer.skinSettings." + key, objects);
    }
}

