/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.Strings;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerDisplaySetting
extends ArmourerBaseSetting
implements UITextFieldDelegate {
    protected final ArmourerBlockEntity blockEntity;
    private final HashMap<PlayerTextureDescriptor.Source, String> defaultValues = new HashMap();
    private final UIComboBox comboList = new UIComboBox(new CGRect(10.0f, 30.0f, 80.0f, 14.0f));
    private final UITextField textBox = new UITextField(new CGRect(10.0f, 65.0f, 120.0f, 16.0f));
    private final UILabel inputType = new UILabel(new CGRect(10.0f, 55.0f, 160.0f, 10.0f));
    private final UICheckBox checkShowGuides = new UICheckBox(new CGRect(10.0f, 115.0f, 160.0f, 9.0f));
    private final UICheckBox checkShowModelGuides = new UICheckBox(new CGRect(10.0f, 130.0f, 160.0f, 9.0f));
    private final UICheckBox checkShowHelper = new UICheckBox(new CGRect(10.0f, 145.0f, 160.0f, 9.0f));
    private PlayerTextureDescriptor lastDescriptor = PlayerTextureDescriptor.EMPTY;
    private PlayerTextureDescriptor.Source lastSource = PlayerTextureDescriptor.Source.NONE;

    public ArmourerDisplaySetting(ArmourerMenu container) {
        super("armourer.displaySettings");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
        this.reloadData();
    }

    @Override
    public void init() {
        super.init();
        this.checkShowGuides.setTitle(this.getDisplayText("showGuide", new Object[0]));
        this.checkShowGuides.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerDisplaySetting::updateFlagValue);
        this.checkShowModelGuides.setTitle(this.getDisplayText("showModelGuide", new Object[0]));
        this.checkShowModelGuides.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerDisplaySetting::updateFlagValue);
        this.checkShowHelper.setTitle(this.getDisplayText("showHelper", new Object[0]));
        this.checkShowHelper.addTarget(this, UIControl.Event.VALUE_CHANGED, ArmourerDisplaySetting::updateFlagValue);
        this.addSubview(this.checkShowGuides);
        this.addSubview(this.checkShowModelGuides);
        this.addSubview(this.checkShowHelper);
        UILabel label = new UILabel(new CGRect(10.0f, 20.0f, 160.0f, 10.0f));
        label.setText(this.getDisplayText("label.skinType", new Object[0]));
        this.addSubview(label);
        this.inputType.setText(this.getDisplayText("label.username", new Object[0]));
        this.addSubview(this.inputType);
        String defaultValue = this.defaultValues.get((Object)this.lastSource);
        this.textBox.setMaxLength(1024);
        this.textBox.setDelegate(this);
        if (Strings.isNotBlank((String)defaultValue)) {
            this.textBox.setText(defaultValue);
        }
        this.addSubview(this.textBox);
        UIButton loadBtn = new UIButton(new CGRect(10.0f, 90.0f, 100.0f, 20.0f));
        loadBtn.setTitle(this.getDisplayText("set", new Object[0]), 7);
        loadBtn.setTitleColor(UIColor.WHITE, 7);
        loadBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        loadBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerDisplaySetting::submit);
        this.addSubview(loadBtn);
        this.setupComboList(this.lastSource);
        this.reloadStatus();
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.submit(textField);
        return true;
    }

    @Override
    public void reloadData() {
        this.prepareDefaultValue();
        this.reloadStatus();
    }

    private void reloadStatus() {
        if (this.checkShowGuides == null) {
            return;
        }
        this.checkShowGuides.setSelected(this.blockEntity.isShowGuides());
        this.checkShowModelGuides.setSelected(this.blockEntity.isShowModelGuides());
        this.checkShowHelper.setSelected(this.blockEntity.isShowHelper());
        this.checkShowHelper.setHidden(!this.blockEntity.isUseHelper());
        if (this.lastSource == PlayerTextureDescriptor.Source.URL) {
            this.inputType.setText(this.getDisplayText("label.url", new Object[0]));
        } else {
            this.inputType.setText(this.getDisplayText("label.username", new Object[0]));
        }
    }

    private void prepareDefaultValue() {
        this.defaultValues.clear();
        if (this.blockEntity != null) {
            this.lastDescriptor = this.blockEntity.getTextureDescriptor();
        }
        this.lastSource = this.lastDescriptor.getSource();
        if (this.lastSource == PlayerTextureDescriptor.Source.USER) {
            this.defaultValues.put(this.lastSource, this.lastDescriptor.getName());
        }
        if (this.lastSource == PlayerTextureDescriptor.Source.URL) {
            this.defaultValues.put(this.lastSource, this.lastDescriptor.getURL());
        }
    }

    private void submit(Object button) {
        this.textBox.resignFirstResponder();
        int index = this.comboList.selectedIndex();
        PlayerTextureDescriptor.Source source = PlayerTextureDescriptor.Source.values()[index + 1];
        this.applyText(source, this.textBox.text());
    }

    private void changeSource(PlayerTextureDescriptor.Source newSource) {
        if (this.lastSource == newSource) {
            return;
        }
        this.defaultValues.put(this.lastSource, this.textBox.text());
        this.textBox.setText(this.defaultValues.getOrDefault((Object)newSource, ""));
        this.textBox.resignFirstResponder();
        this.comboList.setSelectedIndex(newSource.ordinal() - 1);
        this.lastSource = newSource;
        this.reloadStatus();
    }

    private void applyText(PlayerTextureDescriptor.Source source, String value) {
        PlayerTextureDescriptor descriptor = PlayerTextureDescriptor.EMPTY;
        if (Strings.isNotEmpty((CharSequence)value)) {
            if (source == PlayerTextureDescriptor.Source.URL) {
                descriptor = PlayerTextureDescriptor.fromURL(value);
            }
            if (source == PlayerTextureDescriptor.Source.USER) {
                descriptor = PlayerTextureDescriptor.fromName(value);
            }
        }
        PlayerTextureLoader.getInstance().loadTextureDescriptor(descriptor, resolvedDescriptor -> {
            PlayerTextureDescriptor newValue = resolvedDescriptor.orElse(PlayerTextureDescriptor.EMPTY);
            if (this.lastDescriptor.equals(newValue)) {
                return;
            }
            this.lastSource = PlayerTextureDescriptor.Source.NONE;
            this.lastDescriptor = newValue;
            this.blockEntity.setTextureDescriptor(newValue);
            UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.TEXTURE_DESCRIPTOR;
            UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, newValue);
            NetworkManager.sendToServer(packet);
            this.defaultValues.put(newValue.getSource(), newValue.getValue());
            this.changeSource(newValue.getSource());
        });
    }

    private void updateFlagValue(UIControl sender) {
        int oldFlags = this.blockEntity.getFlags();
        this.blockEntity.setShowGuides(this.checkShowGuides.isSelected());
        this.blockEntity.setShowModelGuides(this.checkShowModelGuides.isSelected());
        this.blockEntity.setShowHelper(this.checkShowHelper.isSelected());
        int flags = this.blockEntity.getFlags();
        if (flags == oldFlags) {
            return;
        }
        this.blockEntity.setFlags(flags);
        UpdateArmourerPacket.Field field = UpdateArmourerPacket.Field.FLAGS;
        UpdateArmourerPacket packet = new UpdateArmourerPacket(this.blockEntity, field, flags);
        NetworkManager.sendToServer(packet);
    }

    private void setupComboList(PlayerTextureDescriptor.Source source) {
        int selectedIndex = 0;
        if (source != PlayerTextureDescriptor.Source.NONE) {
            selectedIndex = source.ordinal() - 1;
        }
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        items.add(new UIComboItem(this.getDisplayText("dropdown.user", new Object[0])));
        items.add(new UIComboItem(this.getDisplayText("dropdown.url", new Object[0])));
        this.comboList.setSelectedIndex(selectedIndex);
        this.comboList.reloadData(items);
        this.comboList.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, ctr) -> {
            int index = ((UIComboBox)ctr).selectedIndex();
            this.changeSource(PlayerTextureDescriptor.Source.values()[index + 1]);
        });
        this.addSubview(this.comboList);
    }
}

