/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.api.action.ICanOverride;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.AdvancedBuilderWindow;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentConnector;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedHeaderView;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.PartPickerView;
import moe.plushie.armourers_workshop.builder.network.AdvancedImportPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class AdvancedGeneralPanel
extends AdvancedPanel {
    private final DocumentConnector connector;

    public AdvancedGeneralPanel(DocumentEditor editor) {
        super(editor);
        this.connector = editor.getConnector();
        this.barItem.setImage(UIImage.of(ModTextures.TAB_ICONS).uv(192.0f, 0.0f).fixed(16.0f, 16.0f).build());
        this.setup();
    }

    private void setup() {
        this.addHeader();
        this.addGroup(this.translatable("transform"), builder -> {
            builder.vector(this.translatable("location"), this.connector.location, AdvancedPanel.Group.Unit.POINT);
            builder.vector(this.translatable("rotation"), this.connector.rotation, AdvancedPanel.Group.Unit.DEGREES);
            builder.slider(this.translatable("scale"), this.connector.scale, AdvancedPanel.Group.Unit.SCALE);
        });
        this.addGroup(this.translatable("properties"), builder -> {
            builder.bool(this.translatable("enabled"), this.connector.enabled);
            builder.bool(this.translatable("mirror"), this.connector.mirror);
        });
    }

    private void addHeader() {
        AdvancedHeaderView headerView = new AdvancedHeaderView(this.connector.name, this.connector.part, new CGRect(0.0f, 0.0f, 200.0f, 24.0f));
        this.connector.lock.addObserver(it -> headerView.setEditable(it == false));
        headerView.setPicker(sender -> {
            CGRect rect = new CGRect(0.0f, 0.0f, 242.0f, 208.0f);
            CGAffineTransform transform = CGAffineTransform.createScale(0.5f, 0.5f);
            PartPickerView pickerView = new PartPickerView(rect);
            pickerView.setAutoresizingMask(36);
            pickerView.setContents(UIImage.of(ModTextures.MENUS).uv(0.0f, 0.0f).fixed(44.0f, 44.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build());
            pickerView.setTransform(transform);
            pickerView.setSelectedPart(this.connector.part.get());
            pickerView.setChangeListener(this.connector.part::set);
            pickerView.setHistorySkins(this.connector.getEditor().getHistory());
            pickerView.setFilter(it -> it.getType() == SkinTypes.ADVANCED);
            pickerView.setImporter(this::pickAction);
            pickerView.showInView((UIView)sender);
        });
        this.addContent(headerView);
    }

    private void pickAction() {
        SkinDocumentNode node = this.connector.getNode();
        AdvancedBuilderWindow window = ObjectUtils.safeCast(this.window(), AdvancedBuilderWindow.class);
        if (node == null || window == null) {
            return;
        }
        boolean keepItemTransforms = false;
        if (node.getType() != SkinPartTypes.ADVANCED && node.isLocked() && this.document.getType().usesItemTransforms()) {
            keepItemTransforms = true;
        }
        if (node.getType() instanceof ICanOverride) {
            keepItemTransforms = true;
        }
        window.importNewSkin(SkinTypes.ADVANCED, keepItemTransforms, skin -> {
            AdvancedBuilderBlockEntity blockEntity = this.editor.getBlockEntity();
            AdvancedImportPacket packet = new AdvancedImportPacket(blockEntity, (Skin)skin, node.getId());
            NetworkManager.sendToServer(packet);
        });
    }
}

