/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.block.ArmourerBlock;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.builder.data.BoundingBox;
import moe.plushie.armourers_workshop.builder.item.impl.IPaintToolSelector;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.builder.other.CubeSelector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldBlockUpdateTask;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.state.BlockState.PropertyProvider;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataSerializerKey;
import moe.plushie.armourers_workshop.utils.DataTypeCodecs;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import moe.plushie.armourers_workshop.utils.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ArmourerBlockEntity
extends UpdatableBlockEntity
implements IBlockEntityHandler,
IPaintToolSelector.Provider {
    private static final DataSerializerKey<ISkinType> SKIN_TYPE_KEY = DataSerializerKey.create("SkinType", DataTypeCodecs.SKIN_TYPE, SkinTypes.UNKNOWN);
    private static final DataSerializerKey<SkinProperties> SKIN_PROPERTIES_KEY = DataSerializerKey.create("SkinProperties", DataTypeCodecs.SKIN_PROPERTIES, SkinProperties.EMPTY, SkinProperties::new);
    private static final DataSerializerKey<PlayerTextureDescriptor> PLAYER_TEXTURE_KEY = DataSerializerKey.create("Texture", DataTypeCodecs.TEXTURE_DESCRIPTOR, PlayerTextureDescriptor.EMPTY);
    private static final DataSerializerKey<SkinPaintData> PAINT_DATA_KEY = DataSerializerKey.create("PaintData", DataTypeCodecs.SKIN_PAINT_DATA, null);
    private static final DataSerializerKey<Integer> FLAGS_KEY = DataSerializerKey.create("Flags", DataTypeCodecs.INT, 0);
    private static final DataSerializerKey<Integer> VERSION_KEY = DataSerializerKey.create("DataVersion", DataTypeCodecs.INT, 0);
    private static final ImmutableMap<ISkinPartType, ISkinProperty<Boolean>> PART_TO_MODEL = new ImmutableMap.Builder().put((Object)SkinPartTypes.BIPPED_HEAD, SkinProperty.OVERRIDE_MODEL_HEAD).put((Object)SkinPartTypes.BIPPED_CHEST, SkinProperty.OVERRIDE_MODEL_CHEST).put((Object)SkinPartTypes.BIPPED_LEFT_ARM, SkinProperty.OVERRIDE_MODEL_LEFT_ARM).put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, SkinProperty.OVERRIDE_MODEL_RIGHT_ARM).put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, SkinProperty.OVERRIDE_MODEL_LEFT_LEG).put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG).put((Object)SkinPartTypes.BIPPED_LEFT_FOOT, SkinProperty.OVERRIDE_MODEL_LEFT_LEG).put((Object)SkinPartTypes.BIPPED_RIGHT_FOOT, SkinProperty.OVERRIDE_MODEL_RIGHT_LEG).build();
    protected int flags = 0;
    protected int version = 0;
    protected ISkinType skinType = SkinTypes.ARMOR_HEAD;
    protected SkinProperties skinProperties = new SkinProperties();
    protected PlayerTextureDescriptor textureDescriptor = PlayerTextureDescriptor.EMPTY;
    protected SkinPaintData paintData;
    protected Object renderData;
    protected AABB renderBoundingBox;

    public ArmourerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.skinType = serializer.read(SKIN_TYPE_KEY);
        this.skinProperties = serializer.read(SKIN_PROPERTIES_KEY);
        this.textureDescriptor = serializer.read(PLAYER_TEXTURE_KEY);
        this.flags = serializer.read(FLAGS_KEY);
        this.version = serializer.read(VERSION_KEY);
        this.paintData = serializer.read(PAINT_DATA_KEY);
        if (this.skinType == SkinTypes.UNKNOWN) {
            this.skinType = SkinTypes.ARMOR_HEAD;
        }
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(SKIN_TYPE_KEY, this.skinType);
        serializer.write(SKIN_PROPERTIES_KEY, this.skinProperties);
        serializer.write(PLAYER_TEXTURE_KEY, this.textureDescriptor);
        serializer.write(FLAGS_KEY, this.flags);
        serializer.write(VERSION_KEY, this.version);
        serializer.write(PAINT_DATA_KEY, this.paintData);
    }

    public void onPlace(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity) {
        this.remakeBoundingBoxes(null, this.getBoundingBoxes(), true);
        if (entity instanceof Player) {
            this.setTextureDescriptor(PlayerTextureDescriptor.fromProfile(((Player)entity).m_36316_()));
        }
    }

    public void onRemove(Level level, BlockPos pos, BlockState state) {
        if (!this.m_58900_().m_60713_((Block)ModBlocks.ARMOURER.get())) {
            return;
        }
        this.remakeBoundingBoxes(this.getBoundingBoxes(), null, true);
    }

    public ISkinType getSkinType() {
        return this.skinType;
    }

    public void setSkinType(ISkinType skinType) {
        if (this.skinType == skinType) {
            return;
        }
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.skinType = skinType;
        this.setPaintData(null);
        this.remakeSkinProperties();
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), true);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    public void setSkinProperties(SkinProperties skinProperties) {
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.skinProperties = skinProperties;
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        Collection<BoundingBox> boxes = this.getBoundingBoxes();
        this.flags = flags;
        this.remakeBoundingBoxes(boxes, this.getBoundingBoxes(), false);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public PlayerTextureDescriptor getTextureDescriptor() {
        return this.textureDescriptor;
    }

    public void setTextureDescriptor(PlayerTextureDescriptor textureDescriptor) {
        this.textureDescriptor = textureDescriptor;
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData == paintData) {
            return;
        }
        if (paintData != null) {
            this.paintData = SkinPaintData.v2();
            this.paintData.copyFrom(paintData);
        } else {
            this.paintData = null;
        }
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public IPaintColor getPaintColor(TexturePos pos) {
        if (this.paintData != null) {
            return PaintColor.of(this.paintData.getColor(pos));
        }
        return null;
    }

    public void setPaintColor(TexturePos pos, IPaintColor paintColor) {
        if (this.paintData == null) {
            this.paintData = SkinPaintData.v2();
        }
        this.paintData.setColor(pos, paintColor.getRawValue());
        this.m_6596_();
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        ++this.version;
    }

    public boolean isShowGuides() {
        return (this.flags & 1) == 0;
    }

    public void setShowGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
        this.m_6596_();
    }

    public boolean isShowHelper() {
        return (this.flags & 2) == 0;
    }

    public void setShowHelper(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFD) : (this.flags |= 2);
        this.m_6596_();
    }

    public boolean isShowModelGuides() {
        return (this.flags & 4) == 0;
    }

    public void setShowModelGuides(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFB) : (this.flags |= 4);
        this.m_6596_();
    }

    public boolean isUseHelper() {
        if (this.skinType == SkinTypes.ARMOR_WINGS) {
            return true;
        }
        return this.skinType instanceof ISkinToolType;
    }

    @Override
    public IPaintToolSelector createPaintToolSelector(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_36341_()) {
            return null;
        }
        ArrayList<Rectangle3i> rects = new ArrayList<Rectangle3i>();
        CubeTransform transform = this.getTransform();
        for (ISkinPartType iSkinPartType : this.getSkinType().getParts()) {
            Rectangle3i box = WorldUtils.getResolvedBuildingSpace(iSkinPartType);
            BlockPos p1 = transform.mul(box.getMinX(), box.getMinY(), box.getMinZ());
            BlockPos p2 = transform.mul(box.getMaxX(), box.getMaxY(), box.getMaxZ());
            int minX = Math.min(p1.m_123341_(), p2.m_123341_());
            int minY = Math.min(p1.m_123342_(), p2.m_123342_());
            int minZ = Math.min(p1.m_123343_(), p2.m_123343_());
            int maxX = Math.max(p1.m_123341_(), p2.m_123341_());
            int maxY = Math.max(p1.m_123342_(), p2.m_123342_());
            int maxZ = Math.max(p1.m_123343_(), p2.m_123343_());
            rects.add(new Rectangle3i(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ));
        }
        return CubeSelector.all(rects);
    }

    public void copyPaintData(CubeChangesCollector collector, ISkinPartType srcPart, ISkinPartType destPart, boolean mirror) {
        if (this.paintData == null) {
            return;
        }
        PlayerTextureModel textureModel = BoundingBox.MODEL;
        SkyBox srcBox = textureModel.get(srcPart);
        SkyBox destBox = textureModel.get(destPart);
        if (srcBox != null && destBox != null) {
            WorldUtils.copyPaintData(this.paintData, srcBox, destBox, mirror);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearPaintData(CubeChangesCollector collector, ISkinPartType partType) {
        if (this.paintData == null) {
            return;
        }
        if (partType == SkinPartTypes.UNKNOWN) {
            this.setPaintData(null);
            return;
        }
        PlayerTextureModel textureModel = BoundingBox.MODEL;
        SkyBox srcBox = textureModel.get(partType);
        if (srcBox != null) {
            WorldUtils.clearPaintData(this.paintData, srcBox);
            BlockUtils.combine(this, this::sendBlockUpdates);
        }
    }

    public void clearCubes(CubeChangesCollector collector, ISkinPartType partType) {
        WorldUtils.clearCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), partType);
        if (partType != SkinPartTypes.UNKNOWN) {
            return;
        }
        boolean isMultiBlock = this.skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.BLOCK_MULTIBLOCK, isMultiBlock);
        BlockUtils.combine(this, this::sendBlockUpdates);
    }

    public void replaceCubes(CubeChangesCollector collector, ISkinPartType partType, CubeReplacingEvent event) throws Exception {
        WorldUtils.replaceCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), event);
    }

    public void copyCubes(CubeChangesCollector collector, ISkinPartType srcPart, ISkinPartType destPart, boolean mirror) throws Exception {
        WorldUtils.copyCubes(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), srcPart, destPart, mirror);
    }

    public void clearMarkers(CubeChangesCollector collector, ISkinPartType partType) {
        WorldUtils.clearMarkers(collector, this.getTransform(), this.getSkinType(), this.getSkinProperties(), partType);
        this.m_6596_();
    }

    public boolean isModelOverridden(ISkinPartType partType) {
        ISkinProperty property = (ISkinProperty)PART_TO_MODEL.get((Object)partType);
        if (property != null) {
            return (Boolean)this.getSkinProperties().get(property);
        }
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    public Object getRenderData() {
        return this.renderData;
    }

    public void setRenderData(Object renderData) {
        this.renderData = renderData;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox(BlockState blockState) {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = new AABB(-32.0, -32.0, -44.0, 64.0, 64.0, 64.0);
            this.renderBoundingBox = this.renderBoundingBox.m_82338_(this.m_58899_());
        }
        return this.renderBoundingBox;
    }

    private void remakeSkinProperties() {
        String name = this.skinProperties.get(SkinProperty.ALL_CUSTOM_NAME);
        String flavour = this.skinProperties.get(SkinProperty.ALL_FLAVOUR_TEXT);
        this.skinProperties = new SkinProperties();
        this.skinProperties.put(SkinProperty.ALL_CUSTOM_NAME, name);
        this.skinProperties.put(SkinProperty.ALL_FLAVOUR_TEXT, flavour);
    }

    private boolean shouldAddBoundingBoxes(ISkinPartType partType) {
        if (this.isUseHelper()) {
            return this.isShowHelper();
        }
        return !this.isModelOverridden(partType);
    }

    private void remakeBoundingBoxes(Collection<BoundingBox> oldBoxes, Collection<BoundingBox> newBoxes, boolean forced) {
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        if (!forced && Objects.equals(oldBoxes, newBoxes)) {
            return;
        }
        this.applyBoundingBoxes(oldBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, Blocks.f_50016_.m_49966_());
            task.setValidator(state -> state.m_60713_((Block)ModBlocks.BOUNDING_BOX.get()));
            return task;
        });
        this.applyBoundingBoxes(newBoxes, (partType, pos, offset) -> {
            WorldBlockUpdateTask task = new WorldBlockUpdateTask(level, pos, ((Block)ModBlocks.BOUNDING_BOX.get()).m_49966_());
            task.setValidator(state -> PropertyProvider.isReplaceable(state) || state.m_60713_((Block)ModBlocks.BOUNDING_BOX.get()));
            task.setModifier(state -> this.setupBoundingBox(level, pos, offset, partType));
            return task;
        });
    }

    private void setupBoundingBox(Level level, BlockPos pos, Vector3i offset, ISkinPartType partType) {
        BoundingBoxBlockEntity blockEntity = ObjectUtils.safeCast(level.m_7702_(pos), BoundingBoxBlockEntity.class);
        if (blockEntity != null) {
            blockEntity.setPartType(partType);
            blockEntity.setGuide(offset);
            blockEntity.setParent(pos.m_121996_((Vec3i)this.m_58899_()));
            BlockUtils.combine(blockEntity, blockEntity::sendBlockUpdates);
        }
    }

    private void applyBoundingBoxes(@Nullable Collection<BoundingBox> boxes, IUpdateTaskBuilder builder) {
        if (boxes == null || boxes.isEmpty()) {
            return;
        }
        CubeTransform transform = this.getTransform();
        boxes.forEach(box -> box.forEach((ix, iy, iz) -> {
            BlockPos target = transform.mul(ix + box.getX(), iy + box.getY(), iz + box.getZ());
            ix = box.getWidth() - ix - 1;
            iy = box.getHeight() - iy - 1;
            ISkinPartType partType = box.getPartType();
            IWorldUpdateTask task = builder.build(partType, target, new Vector3i(ix, iy, iz));
            if (task != null) {
                WorldUpdater.getInstance().submit(task);
            }
        }));
    }

    private Collection<BoundingBox> getBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (ISkinPartType iSkinPartType : this.skinType.getParts()) {
            if (!this.shouldAddBoundingBoxes(iSkinPartType)) continue;
            IVector3i offset = iSkinPartType.getOffset();
            IRectangle3i bounds = iSkinPartType.getBuildingSpace();
            Rectangle3i rect = new Rectangle3i(iSkinPartType.getGuideSpace());
            rect = rect.offset(-offset.getX(), -offset.getY() - bounds.getMinY(), offset.getZ());
            boxes.add(new BoundingBox(iSkinPartType, rect));
        }
        return boxes;
    }

    private Collection<BoundingBox> getFullBoundingBoxes() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (ISkinPartType iSkinPartType : this.skinType.getParts()) {
            if (!this.shouldAddBoundingBoxes(iSkinPartType)) continue;
            IVector3i origin = iSkinPartType.getOffset();
            IRectangle3i buildSpace = iSkinPartType.getBuildingSpace();
            int dx = -origin.getX() + buildSpace.getX();
            int dy = -origin.getY();
            int dz = origin.getZ() + buildSpace.getZ();
            Rectangle3i rect = new Rectangle3i(dx, dy, dz, buildSpace.getWidth(), buildSpace.getHeight(), buildSpace.getDepth());
            boxes.add(new BoundingBox(iSkinPartType, rect));
        }
        return boxes;
    }

    public Direction getFacing() {
        return this.m_58900_().m_61145_((Property)ArmourerBlock.f_54117_).orElse(Direction.NORTH);
    }

    public CubeTransform getTransform() {
        BlockPos pos = this.m_58899_().m_7918_(0, 1, 0);
        return new CubeTransform(this.m_58904_(), pos, this.getFacing());
    }

    public static interface IUpdateTaskBuilder {
        public IWorldUpdateTask build(ISkinPartType var1, BlockPos var2, Vector3i var3);
    }
}

