/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Collection;
import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.api.data.IDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.network.UpdateSkinDocumentPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentExporter;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentImporter;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancedBuilderBlockEntity
extends UpdatableBlockEntity
implements IBlockEntityHandler,
SkinDocumentProvider {
    private AABB renderBoundingBox;
    public final Vector3f carmeOffset = new Vector3f();
    public final Vector3f carmeRot = new Vector3f();
    public final Vector3f carmeScale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f offset = new Vector3f(0.0f, 12.0f, 0.0f);
    private final SkinDocument document = new SkinDocument();

    public Vector3f getRenderOrigin() {
        BlockPos pos = this.m_58899_();
        return new Vector3f((float)pos.m_123341_() + this.offset.getX() + 0.5f, (float)pos.m_123342_() + this.offset.getY() + 0.5f, (float)pos.m_123343_() + this.offset.getZ() + 0.5f);
    }

    public AdvancedBuilderBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.document.addListener(new SkinDocumentListeners.Updater(this));
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.document.deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.document.serialize(serializer);
    }

    public void importToNode(String identifier, Skin skin, SkinDocumentNode node) {
        SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
        node.setSkin(descriptor);
        CompoundTag tag = new CompoundTag();
        OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", descriptor, null);
        UpdateSkinDocumentPacket.UpdateNodeAction action = new UpdateSkinDocumentPacket.UpdateNodeAction(node.getId(), tag);
        NetworkManager.sendToAll(new UpdateSkinDocumentPacket(this, action));
        if (skin.getItemTransforms() != null) {
            this.importToSettings(skin.getItemTransforms(), node);
        }
    }

    private void importToSettings(SkinItemTransforms itemTransforms, SkinDocumentNode node) {
        Collection<String> overrideNames;
        SkinItemTransforms newItemTransforms = new SkinItemTransforms();
        if (this.document.getItemTransforms() != null) {
            newItemTransforms.putAll(this.document.getItemTransforms());
        }
        if (!(overrideNames = SkinUtils.getItemOverrides(node.getType())).isEmpty()) {
            overrideNames.forEach(name -> itemTransforms.forEach((type, transform) -> newItemTransforms.put(name + ";" + type, transform)));
        } else {
            newItemTransforms.putAll(itemTransforms);
        }
        this.document.setItemTransforms(newItemTransforms);
        CompoundTag tag = new CompoundTag();
        OptionalAPI.putOptionalItemTransforms(tag, "ItemTransforms", itemTransforms, null);
        UpdateSkinDocumentPacket.UpdateSettingsAction action = new UpdateSkinDocumentPacket.UpdateSettingsAction(tag);
        NetworkManager.sendToAll(new UpdateSkinDocumentPacket(this, action));
    }

    public void importToDocument(String identifier, Skin skin) {
        BlockUtils.performBatch(() -> {
            SkinDocumentImporter importer = new SkinDocumentImporter(this.document);
            this.document.reset();
            this.document.setItemTransforms(skin.getItemTransforms());
            importer.execute(identifier, skin);
        });
    }

    public void exportFromDocument(ServerPlayer player) {
        SkinDocumentExporter exporter = new SkinDocumentExporter(this.document);
        exporter.setItemTransforms(this.document.getItemTransforms());
        EnvironmentExecutor.runOnBackground(() -> () -> {
            try {
                Skin skin = exporter.execute((Player)player);
                player.f_8924_.execute(() -> {
                    String identifier = SkinLoader.getInstance().saveSkin("", skin);
                    SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
                    ItemStack itemStack = descriptor.asItemStack();
                    ABI.giveItem((Player)player, itemStack);
                });
            }
            catch (TranslatableException exception) {
                UserNotifications.sendErrorMessage(exception.getComponent(), (Player)player);
            }
        });
    }

    @Override
    public SkinDocument getDocument() {
        return this.document;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox(BlockState blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        float s = 16.0f;
        Vector3f origin = this.getRenderOrigin();
        Rectangle3f rect = new Rectangle3f(origin.getX() - s / 2.0f, origin.getY() - s / 2.0f, origin.getZ() - s / 2.0f, s, s, s);
        this.renderBoundingBox = rect.asAABB();
        return this.renderBoundingBox;
    }
}

