/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public interface ViewImpl {
    public UIView self();

    public CGPoint center();

    public CGRect bounds();

    public CGAffineTransform transform();

    default public CGPoint convertPointFromView(CGPoint point, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, false);
        if (transform != null) {
            return point.applying(transform);
        }
        return point;
    }

    default public CGPoint convertPointToView(CGPoint point, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, true);
        if (transform != null) {
            return point.applying(transform);
        }
        return point;
    }

    default public CGRect convertRectFromView(CGRect rect, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, false);
        if (transform != null) {
            return rect.applying(transform);
        }
        return rect;
    }

    default public CGRect convertRectToView(CGRect rect, @Nullable UIView view) {
        CGAffineTransform transform = this._computeTransformInViewHierarchy(view, true);
        if (transform != null) {
            return rect.applying(transform);
        }
        return rect;
    }

    @Nullable
    default public CGAffineTransform _computeTransformInViewHierarchy(@Nullable UIView searchedView, boolean reversed) {
        if (searchedView == null && (searchedView = this.self().window()) == null) {
            return null;
        }
        if (searchedView == this.self()) {
            return null;
        }
        UIView parentView = null;
        LinkedList<UIView> toViews = new LinkedList<UIView>();
        LinkedList<ViewImpl> fromViews = new LinkedList<ViewImpl>();
        ViewImpl searchingView1 = this;
        ViewImpl searchingView2 = searchedView;
        HashSet<UIView> parentViews = new HashSet<UIView>();
        Iterator cleaner = null;
        while (searchingView1 != null || searchingView2 != null) {
            if (searchingView1 != null) {
                if (!parentViews.add(searchingView1.self())) {
                    parentView = searchingView1.self();
                    cleaner = toViews.iterator();
                    break;
                }
                fromViews.addFirst(searchingView1);
                searchingView1 = this._superviewInViewHierarchy(searchingView1);
            }
            if (searchingView2 == null) continue;
            if (!parentViews.add(searchingView2.self())) {
                parentView = searchingView2.self();
                cleaner = fromViews.iterator();
                break;
            }
            toViews.addFirst((UIView)searchingView2);
            searchingView2 = this._superviewInViewHierarchy(searchingView2);
        }
        while (cleaner != null && cleaner.hasNext()) {
            ViewImpl view = (ViewImpl)cleaner.next();
            cleaner.remove();
            if (view.self() != parentView) continue;
            cleaner = null;
        }
        if (parentView == null) {
            return null;
        }
        CGAffineTransform offset = null;
        ArrayList<Pair> enumerator = new ArrayList<Pair>();
        if (fromViews.size() != 0) {
            enumerator.add(Pair.of(fromViews, (Object)reversed));
        }
        if (toViews.size() != 0) {
            enumerator.add(Pair.of(toViews, (Object)(!reversed ? 1 : 0)));
        }
        if (!reversed && enumerator.size() > 1) {
            Collections.reverse(enumerator);
        }
        for (Pair it : enumerator) {
            float tx = 0.0f;
            float ty = 0.0f;
            CGAffineTransform translate = CGAffineTransform.createScale(1.0f, 1.0f);
            for (ViewImpl view : (Collection)it.getLeft()) {
                CGAffineTransform transform = view.transform();
                CGPoint center = view.center();
                CGRect bounds = view.bounds();
                tx += center.x;
                ty += center.y;
                tx -= bounds.x;
                ty -= bounds.y;
                if (transform.isIdentity()) {
                    tx -= bounds.width * 0.5f;
                    ty -= bounds.height * 0.5f;
                    continue;
                }
                CGSize size = bounds.size();
                size.apply(transform);
                CGAffineTransform tmp = CGAffineTransform.createTranslation(-(tx -= size.width * 0.5f), -(ty -= size.height * 0.5f));
                tmp.concat(view._invertedTransform());
                translate.concat(tmp);
                tx = 0.0f;
                ty = 0.0f;
            }
            if (tx != 0.0f || ty != 0.0f) {
                translate.concat(CGAffineTransform.createTranslation(-tx, -ty));
            }
            if (((Boolean)it.getRight()).booleanValue()) {
                translate.invert();
            }
            if (offset == null) {
                offset = translate;
                continue;
            }
            offset.concat(translate);
        }
        return offset;
    }

    default public ViewImpl _superviewInViewHierarchy(ViewImpl searchingView) {
        return searchingView.self().superview();
    }

    default public CGAffineTransform _invertedTransform() {
        return this.transform().inverted();
    }

    default public boolean _ignoresTouchEvents(UIView view) {
        return !view.isUserInteractionEnabled() || view.isHidden();
    }

    default public float[] _applyAutoresizingMask(float offset, float size, float newValue, float oldValue, int mask) {
        float newOffset = offset;
        float newSize = size;
        switch (mask & 7) {
            case 1: {
                newOffset = newValue - (oldValue - offset);
                break;
            }
            case 2: {
                newSize = newValue - (oldValue - size);
                break;
            }
            case 3: {
                float usage = 0.5f;
                if (offset != 0.0f || size != 0.0f) {
                    usage = offset / (offset + size);
                }
                float dx = oldValue - offset - size;
                newOffset = (newValue - dx) * usage;
                newSize = newValue - dx - newOffset;
                break;
            }
            case 5: {
                float usage = 0.5f;
                if (oldValue != size) {
                    usage = offset / (oldValue - size);
                }
                newOffset = (newValue - size) * usage;
                break;
            }
            case 6: {
                float usage = 1.0f;
                if (oldValue != size) {
                    usage = size / (oldValue - size);
                }
                newSize = (newValue - offset) * usage;
                break;
            }
            case 7: {
                float usage1;
                float usage2 = usage1 = 0.33333334f;
                if (oldValue != 0.0f) {
                    usage1 = offset / oldValue;
                    usage2 = size / oldValue;
                }
                newOffset = newValue * usage1;
                newSize = newValue * usage2;
                break;
            }
        }
        return new float[]{newOffset, Math.max(newSize, 0.0f)};
    }
}

