/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.coregraphics;

import com.apple.library.impl.InterpolableImpl;
import java.util.Objects;

public class CGAffineTransform
implements InterpolableImpl<CGAffineTransform> {
    public static final CGAffineTransform IDENTITY = new CGAffineTransform(1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    public float a;
    public float b;
    public float c;
    public float d;
    public float tx;
    public float ty;

    public CGAffineTransform(float a, float b, float c, float d, float tx, float ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public static CGAffineTransform createTranslation(float tx, float ty) {
        return new CGAffineTransform(1.0f, 0.0f, 0.0f, 1.0f, tx, ty);
    }

    public static CGAffineTransform createScale(float sx, float sy) {
        return new CGAffineTransform(sx, 0.0f, 0.0f, sy, 0.0f, 0.0f);
    }

    public static CGAffineTransform createRotation(float angle) {
        if (Math.abs((double)angle - 1.5707963267948966) < 1.0E-4) {
            return new CGAffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f);
        }
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        return new CGAffineTransform(c, s, -s, c, 0.0f, 0.0f);
    }

    public void rotate(float angle) {
        if (angle == 0.0f) {
            return;
        }
        CGAffineTransform.multiply(CGAffineTransform.createRotation(angle), this, this);
    }

    public void translate(float tx, float ty) {
        if (tx == 0.0f && ty == 0.0f) {
            return;
        }
        CGAffineTransform.multiply(CGAffineTransform.createTranslation(tx, ty), this, this);
    }

    public void scale(float sx, float sy) {
        if (sx == 0.0f && sy == 0.0f) {
            return;
        }
        CGAffineTransform.multiply(CGAffineTransform.createScale(sx, sy), this, this);
    }

    public void concat(CGAffineTransform t) {
        if (t == IDENTITY) {
            return;
        }
        CGAffineTransform.multiply(this, t, this);
    }

    public void invert() {
        float determinant = this.a * this.d - this.c * this.b;
        if (determinant == 0.0f) {
            return;
        }
        float na = this.d / determinant;
        float nb = -this.b / determinant;
        float nc = -this.c / determinant;
        float nd = this.a / determinant;
        float ntx = (-this.d * this.tx + this.c * this.ty) / determinant;
        float nty = (this.b * this.tx - this.a * this.ty) / determinant;
        this.a = na;
        this.b = nb;
        this.c = nc;
        this.d = nd;
        this.tx = ntx;
        this.ty = nty;
    }

    public CGAffineTransform inverted() {
        CGAffineTransform t = this.copy();
        t.invert();
        return t;
    }

    public boolean isIdentity() {
        if (this == IDENTITY) {
            return true;
        }
        return this.equals(IDENTITY);
    }

    public CGAffineTransform copy() {
        return new CGAffineTransform(this.a, this.b, this.c, this.d, this.tx, this.ty);
    }

    @Override
    public CGAffineTransform interpolating(CGAffineTransform in, float t) {
        float v = 1.0f - t;
        float a = v * this.a + t * in.c;
        float b = v * this.a + t * in.d;
        float c = v * this.c + t * in.c;
        float d = v * this.c + t * in.d;
        float tx = v * this.tx + t * in.tx;
        float ty = v * this.tx + t * in.ty;
        return new CGAffineTransform(a, b, c, d, tx, ty);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CGAffineTransform transform = (CGAffineTransform)o;
        return Float.compare(transform.a, this.a) == 0 && Float.compare(transform.b, this.b) == 0 && Float.compare(transform.c, this.c) == 0 && Float.compare(transform.d, this.d) == 0 && Float.compare(transform.tx, this.tx) == 0 && Float.compare(transform.ty, this.ty) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.a), Float.valueOf(this.b), Float.valueOf(this.c), Float.valueOf(this.d), Float.valueOf(this.tx), Float.valueOf(this.ty));
    }

    public String toString() {
        return String.format("[%f, %f, %f, %f, %f, %f]", Float.valueOf(this.a), Float.valueOf(this.b), Float.valueOf(this.c), Float.valueOf(this.d), Float.valueOf(this.tx), Float.valueOf(this.ty));
    }

    private static void multiply(CGAffineTransform t1, CGAffineTransform t2, CGAffineTransform ret) {
        float a = t1.a * t2.a + t1.b * t2.c;
        float b = t1.a * t2.b + t1.b * t2.d;
        float c = t1.c * t2.a + t1.d * t2.c;
        float d = t1.c * t2.b + t1.d * t2.d;
        float tx = t1.tx * t2.a + t1.ty * t2.c + t2.tx;
        float ty = t1.tx * t2.b + t1.ty * t2.d + t2.ty;
        ret.a = a;
        ret.b = b;
        ret.c = c;
        ret.d = d;
        ret.tx = tx;
        ret.ty = ty;
    }
}

