/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import java.util.Map;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.logic.enums.LogicFilter;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.nbt.CompoundTag;

public class RSOutput {
    private boolean isAdvanced;
    private LogicFilter logicFilter = LogicFilter.OFF;
    private Color inputChannel1 = Color.OFF;
    private Color inputChannel2 = Color.OFF;
    private int redstoneOut = 0;
    private boolean flipFlapState = false;
    private boolean lastInputTrue = false;
    private int countingHolder = 0;
    private int countingCurrent = 0;
    private int ticksHolder = 5;
    private int ticksCurrent = 5;

    public RSOutput(boolean isAdvanced) {
        this.isAdvanced = isAdvanced;
    }

    public LogicFilter getLogicFilter() {
        return this.logicFilter;
    }

    public Color getInputChannel1() {
        return this.inputChannel1;
    }

    public Color getInputChannel2() {
        return this.inputChannel2;
    }

    public int getRedstoneOut() {
        return this.redstoneOut;
    }

    public int getCountingHolder() {
        return this.countingHolder;
    }

    public int getTicksHolder() {
        return this.ticksHolder;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isFlipFlapState() {
        return this.flipFlapState;
    }

    public boolean isLastInputTrue() {
        return this.lastInputTrue;
    }

    public int getCountingCurrent() {
        return this.countingCurrent;
    }

    public int getTicksCurrent() {
        return this.ticksCurrent;
    }

    protected void setAdvanced(boolean advanced) {
        this.isAdvanced = advanced;
    }

    public void setFlipFlapState(boolean flipFlapState) {
        this.flipFlapState = flipFlapState;
    }

    public void setLastInputTrue(boolean lastInputTrue) {
        this.lastInputTrue = lastInputTrue;
    }

    public void setCountingCurrent(int countingCurrent) {
        this.countingCurrent = countingCurrent;
    }

    public void setTicksCurrent(int ticksCurrent) {
        this.ticksCurrent = ticksCurrent;
    }

    public void setCountingHolder(int countingHolder) {
        this.countingHolder = countingHolder;
        this.countingCurrent = countingHolder;
    }

    public void setTicksHolder(int ticksHolder) {
        this.ticksHolder = ticksHolder;
        this.ticksCurrent = ticksHolder;
    }

    public void setLogicFilter(LogicFilter logicFilter) {
        this.logicFilter = logicFilter;
    }

    public void setInputChannel1(Color inputChannel1) {
        this.inputChannel1 = inputChannel1;
    }

    public void setInputChannel2(Color inputChannel2) {
        this.inputChannel2 = inputChannel2;
    }

    public void setRedstoneOut(int redstoneOut) {
        this.redstoneOut = redstoneOut;
    }

    public void createGui(IEditorGui gui) {
        if (gui.isAdvanced()) {
            gui.translatableChoices("RSFilter", (ITranslatableEnum)this.logicFilter, (ITranslatableEnum[])LogicFilter.values());
            switch (this.logicFilter) {
                case OFF: {
                    break;
                }
                case COUNTER: {
                    gui.colors("RSChannel1", I18nConstants.LOGIC_INPUT_CHANNEL_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.inputChannel1.getColor()), Color.COLORS);
                    gui.integer("RSCounter", I18nConstants.LOGIC_COUNTER_FILTER_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.countingHolder), 50, Integer.MAX_VALUE, 0);
                    break;
                }
                case LATCH: 
                case NOT: {
                    gui.colors("RSChannel1", I18nConstants.LOGIC_INPUT_CHANNEL_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.inputChannel1.getColor()), Color.COLORS);
                    break;
                }
                case TIMER: {
                    gui.integer("RSTimer", I18nConstants.LOGIC_TIMER_FILTER_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.ticksHolder), 50, Integer.MAX_VALUE, 5);
                    break;
                }
                case OR: 
                case NOR: 
                case NAND: 
                case XOR: 
                case XNOR: 
                case AND: {
                    gui.colors("RSChannel1", I18nConstants.LOGIC_INPUT_CHANNEL_TOOLTIP.i18n(new Object[0]) + " 1", Integer.valueOf(this.inputChannel1.getColor()), Color.COLORS);
                    gui.colors("RSChannel2", I18nConstants.LOGIC_INPUT_CHANNEL_TOOLTIP.i18n(new Object[0]) + " 2", Integer.valueOf(this.inputChannel2.getColor()), Color.COLORS);
                }
            }
        } else {
            gui.label(I18nConstants.LOGIC_RS_LABEL.i18n(new Object[0]));
        }
        gui.integer("rsout", I18nConstants.LOGIC_RS_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.redstoneOut), 30, 15, 0).nl();
    }

    public void update(Map<String, Object> data) {
        this.logicFilter = CastTools.safeLogicFilter(data.get("RSFilter"));
        this.inputChannel1 = CastTools.safeColor(data.get("RSChannel1"));
        this.inputChannel2 = CastTools.safeColor(data.get("RSChannel2"));
        this.countingHolder = CastTools.safeIntOrValue(data.get("RSCounter"), this.countingHolder);
        this.ticksHolder = CastTools.safeIntOrValue(data.get("RSTimer"), this.ticksHolder);
        this.redstoneOut = CastTools.safeIntOrValue(data.get("rsout"), this.redstoneOut);
    }

    public boolean isEnabled(String tag) {
        switch (tag) {
            case "RSFilter": 
            case "rsout": 
            case "RSChannel1": 
            case "RSChannel2": 
            case "RSCounter": 
            case "RSTimer": {
                return true;
            }
        }
        return false;
    }

    public void readFromNBT(CompoundTag tag) {
        this.logicFilter = LogicFilter.values()[tag.m_128445_("RSFilter")];
        this.inputChannel1 = Color.values()[tag.m_128445_("RSChannel1")];
        this.inputChannel2 = Color.values()[tag.m_128445_("RSChannel2")];
        this.setCountingHolder(tag.m_128451_("RSCountingHolder"));
        this.setTicksHolder(tag.m_128451_("RSTicksHolder"));
        this.redstoneOut = tag.m_128451_("rsout");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_("RSFilter", (byte)this.logicFilter.ordinal());
        tag.m_128344_("RSChannel1", (byte)this.inputChannel1.ordinal());
        tag.m_128344_("RSChannel2", (byte)this.inputChannel2.ordinal());
        tag.m_128405_("RSCountingHolder", this.countingHolder);
        tag.m_128405_("RSTicksHolder", this.ticksHolder);
        tag.m_128405_("rsout", this.redstoneOut);
    }
}

