/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.rftoolsbase.api.xnet.helper.BaseStringTranslators;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.logic.RSOutput;
import mcjty.xnet.apiimpl.logic.RSSensor;
import mcjty.xnet.apiimpl.logic.enums.LogicFilter;
import mcjty.xnet.apiimpl.logic.enums.LogicMode;
import mcjty.xnet.apiimpl.logic.enums.Operator;
import mcjty.xnet.apiimpl.logic.enums.SensorMode;
import mcjty.xnet.utils.CastTools;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LogicConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final int SENSORS = 4;
    private LogicMode logicMode = LogicMode.SENSOR;
    private List<RSSensor> sensors = new ArrayList<RSSensor>(4);
    private RSOutput output = null;
    private int colorMask;
    private static final Set<String> TAGS = ImmutableSet.of((Object)"rsout", (Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object[])new String[]{"color3"});

    public LogicConnectorSettings(@Nonnull Direction side) {
        super(side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new RSSensor(i));
        }
        this.output = new RSOutput(this.advanced);
    }

    public List<RSSensor> getSensors() {
        return this.sensors;
    }

    public RSOutput getOutput() {
        return this.output;
    }

    public void setColorMask(int colorMask) {
        this.colorMask = colorMask;
    }

    public int getColorMask() {
        return this.colorMask;
    }

    public LogicMode getLogicMode() {
        return this.logicMode;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.logicMode) {
            default -> throw new IncompatibleClassChangeError();
            case LogicMode.SENSOR -> new IndicatorIcon(iconGuiElements, 26, 70, 13, 10);
            case LogicMode.OUTPUT -> new IndicatorIcon(iconGuiElements, 39, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced && this.logicMode != LogicMode.OUTPUT;
        }
        for (RSSensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        if (this.output.isEnabled(tag)) {
            return true;
        }
        return TAGS.contains(tag);
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().translatableChoices("mode", (ITranslatableEnum)this.logicMode, (ITranslatableEnum[])LogicMode.values()).nl();
        if (this.logicMode == LogicMode.SENSOR) {
            for (RSSensor sensor : this.sensors) {
                sensor.createGui(gui);
            }
        } else {
            this.output.createGui(gui);
        }
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.logicMode = CastTools.safeLogicMode(data.get("mode"));
        if (this.logicMode == LogicMode.SENSOR) {
            for (RSSensor sensor : this.sensors) {
                sensor.update(data);
            }
        } else {
            this.output.update(data);
        }
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        LogicConnectorSettings.setEnumSafe((JsonObject)object, (String)"logicMode", (Enum)this.logicMode);
        JsonArray sensorArray = new JsonArray();
        for (RSSensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            LogicConnectorSettings.setEnumSafe((JsonObject)o, (String)"sensorMode", (Enum)sensor.getSensorMode());
            LogicConnectorSettings.setEnumSafe((JsonObject)o, (String)"outputcolor", (Enum)sensor.getOutputColor());
            LogicConnectorSettings.setEnumSafe((JsonObject)o, (String)"operator", (Enum)sensor.getOperator());
            LogicConnectorSettings.setIntegerSafe((JsonObject)o, (String)"amount", (Integer)sensor.getAmount());
            if (!sensor.getFilter().m_41619_()) {
                o.add("filter", (JsonElement)JSonTools.itemStackToJson((ItemStack)sensor.getFilter()));
            }
            sensorArray.add((JsonElement)o);
        }
        object.add("sensors", (JsonElement)sensorArray);
        if (!this.output.getLogicFilter().equals((Object)LogicFilter.OFF)) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        JsonObject outputJSON = new JsonObject();
        LogicConnectorSettings.setEnumSafe((JsonObject)outputJSON, (String)"RSFilter", (Enum)this.output.getLogicFilter());
        LogicConnectorSettings.setEnumSafe((JsonObject)outputJSON, (String)"RSChannel1", (Enum)this.output.getInputChannel1());
        LogicConnectorSettings.setEnumSafe((JsonObject)outputJSON, (String)"RSChannel2", (Enum)this.output.getInputChannel2());
        outputJSON.addProperty("RSCountingHolder", (Number)this.output.getCountingHolder());
        outputJSON.addProperty("RSTicksHolder", (Number)this.output.getTicksHolder());
        outputJSON.addProperty("rsout", (Number)this.output.getRedstoneOut());
        object.add("output", (JsonElement)outputJSON);
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.logicMode = (LogicMode)LogicConnectorSettings.getEnumSafe((JsonObject)object, (String)"logicMode", EnumStringTranslators::getLogicMode);
        JsonArray sensorArray = object.get("sensors").getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            RSSensor sensor = new RSSensor(this.sensors.size());
            sensor.setAmount(LogicConnectorSettings.getIntegerNotNull((JsonObject)o, (String)"amount"));
            sensor.setOperator((Operator)LogicConnectorSettings.getEnumSafe((JsonObject)o, (String)"operator", EnumStringTranslators::getOperator));
            sensor.setOutputColor((Color)LogicConnectorSettings.getEnumSafe((JsonObject)o, (String)"outputcolor", BaseStringTranslators::getColor));
            sensor.setSensorMode((SensorMode)LogicConnectorSettings.getEnumSafe((JsonObject)o, (String)"sensorMode", EnumStringTranslators::getSensorMode));
            if (o.has("filter")) {
                sensor.setFilter(JSonTools.jsonToItemStack((JsonObject)o.get("filter").getAsJsonObject()));
            } else {
                sensor.setFilter(ItemStack.f_41583_);
            }
            this.sensors.add(sensor);
        }
        JsonObject outputJSON = object.getAsJsonObject("output");
        this.output = new RSOutput(this.advanced);
        this.output.setLogicFilter((LogicFilter)LogicConnectorSettings.getEnumSafe((JsonObject)outputJSON, (String)"RSFilter", EnumStringTranslators::getLogicFilter));
        this.output.setInputChannel1((Color)LogicConnectorSettings.getEnumSafe((JsonObject)outputJSON, (String)"RSChannel1", BaseStringTranslators::getColor));
        this.output.setInputChannel2((Color)LogicConnectorSettings.getEnumSafe((JsonObject)outputJSON, (String)"RSChannel2", BaseStringTranslators::getColor));
        this.output.setCountingHolder(LogicConnectorSettings.getIntegerNotNull((JsonObject)outputJSON, (String)"RSCountingHolder"));
        this.output.setTicksHolder(LogicConnectorSettings.getIntegerNotNull((JsonObject)outputJSON, (String)"RSTicksHolder"));
        this.output.setRedstoneOut(LogicConnectorSettings.getIntegerNotNull((JsonObject)outputJSON, (String)"rsout"));
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.logicMode = LogicMode.values()[tag.m_128445_("logicMode")];
        this.colorMask = tag.m_128451_("colors");
        for (RSSensor sensor : this.sensors) {
            sensor.readFromNBT(tag);
        }
        this.output.readFromNBT(tag);
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("logicMode", (byte)this.logicMode.ordinal());
        tag.m_128405_("colors", this.colorMask);
        for (RSSensor sensor : this.sensors) {
            sensor.writeToNBT(tag);
        }
        this.output.writeToNBT(tag);
    }
}

