/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Sniffer
extends Animal {
    private static final int f_271109_ = 1700;
    private static final int f_271252_ = 6000;
    private static final int f_271435_ = 30;
    private static final int f_271151_ = 120;
    private static final int f_271414_ = 48000;
    private static final float f_285640_ = 0.4f;
    private static final EntityDimensions f_285627_ = EntityDimensions.m_20395_((float)EntityType.f_271264_.m_20678_(), (float)(EntityType.f_271264_.m_20679_() - 0.4f));
    private static final EntityDataAccessor<State> f_271416_ = SynchedEntityData.m_135353_(Sniffer.class, EntityDataSerializers.f_271344_);
    private static final EntityDataAccessor<Integer> f_271498_ = SynchedEntityData.m_135353_(Sniffer.class, EntityDataSerializers.f_135028_);
    public final AnimationState f_271434_ = new AnimationState();
    public final AnimationState f_271092_ = new AnimationState();
    public final AnimationState f_271278_ = new AnimationState();
    public final AnimationState f_271472_ = new AnimationState();
    public final AnimationState f_271318_ = new AnimationState();

    public static AttributeSupplier.Builder m_271876_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.1f).m_22268_(Attributes.f_22276_, 14.0);
    }

    public Sniffer(EntityType<? extends Animal> p_273717_, Level p_273562_) {
        super(p_273717_, p_273562_);
        this.f_19804_.m_135372_(f_271416_, State.IDLING);
        this.f_19804_.m_135372_(f_271498_, 0);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, -1.0f);
    }

    protected float m_6431_(Pose p_272721_, EntityDimensions p_273353_) {
        return this.m_6972_((Pose)p_272721_).f_20378_ * 0.6f;
    }

    public void m_284177_() {
        super.m_284177_();
        if (this.m_6060_() || this.m_20069_()) {
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
        }
    }

    public void m_284461_() {
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    public EntityDimensions m_6972_(Pose p_286815_) {
        return this.f_19804_.m_285897_(f_271416_) && this.m_271917_() == State.DIGGING ? f_285627_.m_20388_(this.m_6134_()) : super.m_6972_(p_286815_);
    }

    public boolean m_272223_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_217768_).isPresent();
    }

    public boolean m_280317_() {
        return this.m_271917_() == State.SEARCHING;
    }

    public boolean m_278663_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_148198_).orElse(false);
    }

    public boolean m_278650_() {
        return !this.m_278663_() && !this.m_272223_() && !this.m_20069_() && !this.m_27593_() && this.m_20096_() && !this.m_20159_();
    }

    public boolean m_272076_() {
        return this.m_271917_() == State.DIGGING || this.m_271917_() == State.SEARCHING;
    }

    private BlockPos m_284345_() {
        Vec3 vec3 = this.m_284388_();
        return BlockPos.m_274561_((double)vec3.m_7096_(), (double)(this.m_20186_() + (double)0.2f), (double)vec3.m_7094_());
    }

    private Vec3 m_284388_() {
        return this.m_20182_().m_82549_(this.m_20156_().m_82490_(2.25));
    }

    private State m_271917_() {
        return this.f_19804_.m_135370_(f_271416_);
    }

    private Sniffer m_271705_(State p_273359_) {
        this.f_19804_.m_135381_(f_271416_, p_273359_);
        return this;
    }

    public void m_7350_(EntityDataAccessor<?> p_272936_) {
        if (f_271416_.equals(p_272936_)) {
            State sniffer$state = this.m_271917_();
            this.m_271845_();
            switch (sniffer$state) {
                case SCENTING: {
                    this.f_271092_.m_216982_(this.f_19797_);
                    break;
                }
                case SNIFFING: {
                    this.f_271278_.m_216982_(this.f_19797_);
                    break;
                }
                case DIGGING: {
                    this.f_271472_.m_216982_(this.f_19797_);
                    break;
                }
                case RISING: {
                    this.f_271318_.m_216982_(this.f_19797_);
                    break;
                }
                case FEELING_HAPPY: {
                    this.f_271434_.m_216982_(this.f_19797_);
                }
            }
            this.m_6210_();
        }
        super.m_7350_(p_272936_);
    }

    private void m_271845_() {
        this.f_271472_.m_216973_();
        this.f_271278_.m_216973_();
        this.f_271318_.m_216973_();
        this.f_271434_.m_216973_();
        this.f_271092_.m_216973_();
    }

    public Sniffer m_272034_(State p_273096_) {
        switch (p_273096_) {
            case SCENTING: {
                this.m_271705_(State.SCENTING).m_278765_();
                break;
            }
            case SNIFFING: {
                this.m_5496_(SoundEvents.f_271283_, 1.0f, 1.0f);
                this.m_271705_(State.SNIFFING);
                break;
            }
            case DIGGING: {
                this.m_271705_(State.DIGGING).m_271851_();
                break;
            }
            case RISING: {
                this.m_5496_(SoundEvents.f_271405_, 1.0f, 1.0f);
                this.m_271705_(State.RISING);
                break;
            }
            case FEELING_HAPPY: {
                this.m_5496_(SoundEvents.f_271300_, 1.0f, 1.0f);
                this.m_271705_(State.FEELING_HAPPY);
                break;
            }
            case IDLING: {
                this.m_271705_(State.IDLING);
                break;
            }
            case SEARCHING: {
                this.m_271705_(State.SEARCHING);
            }
        }
        return this;
    }

    private Sniffer m_278765_() {
        this.m_5496_(SoundEvents.f_271121_, 1.0f, this.m_6162_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer m_271851_() {
        this.f_19804_.m_135381_(f_271498_, this.f_19797_ + 120);
        this.m_9236_().m_7605_((Entity)((Object)this), (byte)63);
        return this;
    }

    public Sniffer m_271943_(boolean p_272677_) {
        if (p_272677_) {
            this.m_271874_(this.m_20097_());
        }
        return this;
    }

    Optional<BlockPos> m_271905_() {
        return IntStream.range(0, 5).mapToObj(p_273771_ -> LandRandomPos.m_148488_((PathfinderMob)this, (int)(10 + 2 * p_273771_), (int)3)).filter(Objects::nonNull).map(BlockPos::m_274446_).filter(p_289451_ -> this.m_9236_().m_6857_().m_61937_(p_289451_)).map(BlockPos::m_7495_).filter(this::m_271898_).findFirst();
    }

    boolean m_272270_() {
        return !this.m_272223_() && !this.m_278663_() && !this.m_6162_() && !this.m_20069_() && this.m_20096_() && !this.m_20159_() && this.m_271898_(this.m_284345_().m_7495_());
    }

    private boolean m_271898_(BlockPos p_272757_) {
        return this.m_9236_().m_8055_(p_272757_).m_204336_(BlockTags.f_271391_) && this.m_272217_().noneMatch(p_289453_ -> GlobalPos.m_122643_(this.m_9236_().m_46472_(), (BlockPos)p_272757_).equals(p_289453_)) && Optional.ofNullable(this.m_21573_().m_7864_(p_272757_, 1)).map(Path::m_77403_).orElse(false) != false;
    }

    private void m_271740_() {
        if (!this.m_9236_().m_5776_() && this.f_19804_.m_135370_(f_271498_) == this.f_19797_) {
            ServerLevel serverlevel = (ServerLevel)this.m_9236_();
            LootTable loottable = serverlevel.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_283841_);
            LootParams lootparams = new LootParams.Builder(serverlevel).m_287286_(LootContextParams.f_81460_, this.m_284388_()).m_287286_(LootContextParams.f_81455_, this).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList<ItemStack> list = loottable.m_287195_(lootparams);
            BlockPos blockpos = this.m_284345_();
            for (ItemStack itemstack : list) {
                ItemEntity itementity = new ItemEntity(serverlevel, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), itemstack);
                itementity.m_32060_();
                serverlevel.m_7967_(itementity);
            }
            this.m_5496_(SoundEvents.f_271330_, 1.0f, 1.0f);
        }
    }

    private Sniffer m_272274_(AnimationState p_273528_) {
        boolean flag;
        boolean bl = flag = p_273528_.m_216981_() > 1700L && p_273528_.m_216981_() < 6000L;
        if (flag) {
            BlockPos blockpos = this.m_284345_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos.m_7495_());
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)blockpos).m_82520_(0.0, (double)-0.65f, 0.0);
                    this.m_9236_().m_7106_(new BlockParticleOption((ParticleType<BlockParticleOption>)ParticleTypes.f_123794_, blockstate), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
                }
                if (this.f_19797_ % 10 == 0) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), blockstate.getSoundType((LevelReader)((Object)this.m_9236_()), blockpos.m_7495_(), (Entity)((Object)this)).m_56778_(), this.m_5720_(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.f_19797_ % 10 == 0) {
            this.m_9236_().m_220407_(GameEvent.f_223710_, this.m_284345_(), GameEvent.Context.m_223717_((Entity)((Object)this)));
        }
        return this;
    }

    private Sniffer m_271874_(BlockPos p_273015_) {
        List list = this.m_272217_().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.m_122643_(this.m_9236_().m_46472_(), (BlockPos)p_273015_));
        this.m_6274_().m_21879_(MemoryModuleType.f_271415_, list);
        return this;
    }

    private Stream<GlobalPos> m_272217_() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_271415_).stream().flatMap(Collection::stream);
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void m_27563_(ServerLevel p_277923_, Animal p_277857_) {
        ItemStack itemstack = new ItemStack(Items.f_276468_);
        ItemEntity itementity = new ItemEntity(p_277923_, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(p_277923_, p_277857_, null);
        this.m_5496_(SoundEvents.f_279531_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        p_277923_.m_7967_(itementity);
    }

    public void m_6667_(DamageSource p_277689_) {
        this.m_272034_(State.IDLING);
        super.m_6667_(p_277689_);
    }

    public void m_8119_() {
        switch (this.m_271917_()) {
            case DIGGING: {
                this.m_272274_(this.f_271472_).m_271740_();
                break;
            }
            case SEARCHING: {
                this.m_272136_();
            }
        }
        super.m_8119_();
    }

    @Override
    public InteractionResult m_6071_(Player p_273046_, InteractionHand p_272687_) {
        ItemStack itemstack = p_273046_.m_21120_(p_272687_);
        boolean flag = this.m_6898_(itemstack);
        InteractionResult interactionresult = super.m_6071_(p_273046_, p_272687_);
        if (interactionresult.m_19077_() && flag) {
            this.m_9236_().m_6269_(null, (Entity)((Object)this), this.m_7866_(itemstack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
        }
        return interactionresult;
    }

    public double m_6048_() {
        return 1.8;
    }

    public float m_278726_() {
        return super.m_278726_() + 0.3f;
    }

    private void m_272136_() {
        if (this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_271418_, this.m_5720_(), 1.0f, 1.0f, false);
        }
    }

    protected void m_7355_(BlockPos p_272953_, BlockState p_273729_) {
        this.m_5496_(SoundEvents.f_271325_, 0.15f, 1.0f);
    }

    public SoundEvent m_7866_(ItemStack p_272747_) {
        return SoundEvents.f_271147_;
    }

    protected SoundEvent m_7515_() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.m_271917_()) ? null : SoundEvents.f_271535_;
    }

    protected SoundEvent m_7975_(DamageSource p_273718_) {
        return SoundEvents.f_271520_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_271214_;
    }

    public int m_8085_() {
        return 50;
    }

    public void m_6863_(boolean p_272995_) {
        this.m_146762_(p_272995_ ? -48000 : 0);
    }

    public AgeableMob m_142606_(ServerLevel p_273401_, AgeableMob p_273310_) {
        return EntityType.f_271264_.m_20615_(p_273401_);
    }

    @Override
    public boolean m_7848_(Animal p_272966_) {
        if (!(p_272966_ instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)p_272966_;
        Set<State> set = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
        return set.contains((Object)this.m_271917_()) && set.contains((Object)sniffer.m_271917_()) && super.m_7848_(p_272966_);
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_((double)0.6f);
    }

    @Override
    public boolean m_6898_(ItemStack p_273659_) {
        return p_273659_.m_204117_(ItemTags.f_271449_);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_273174_) {
        return SnifferAi.m_272207_(this.m_5490_().m_22073_(p_273174_));
    }

    public Brain<Sniffer> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<Sniffer> m_5490_() {
        return Brain.m_21923_(SnifferAi.f_271430_, SnifferAi.f_271288_);
    }

    @Override
    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("snifferBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), this);
        this.m_9236_().m_46473_().m_6182_("snifferActivityUpdate");
        SnifferAi.m_271706_((Sniffer)this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)((Object)this));
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLING = new State();
        public static final /* enum */ State FEELING_HAPPY = new State();
        public static final /* enum */ State SCENTING = new State();
        public static final /* enum */ State SNIFFING = new State();
        public static final /* enum */ State SEARCHING = new State();
        public static final /* enum */ State DIGGING = new State();
        public static final /* enum */ State RISING = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String p_272910_) {
            return Enum.valueOf(State.class, p_272910_);
        }

        private static /* synthetic */ State[] m_271975_() {
            return new State[]{IDLING, FEELING_HAPPY, SCENTING, SNIFFING, SEARCHING, DIGGING, RISING};
        }

        static {
            $VALUES = State.m_271975_();
        }
    }
}

