/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level.misc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;
import org.joml.Matrix4f;

public class StellarViewSkybox {
    public static final float DEFAULT_DISTANCE = 150.0f;
    public static final float[] FULL_UV = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    public static final float[] UP_UV = new float[]{0.33333334f, 0.0f, 0.6666667f, 0.5f};
    public static final float[] NORTH_UV = new float[]{0.6666667f, 0.0f, 1.0f, 0.5f};
    public static final float[] EAST_UV = new float[]{0.0f, 0.5f, 0.33333334f, 1.0f};
    public static final float[] SOUTH_UV = new float[]{0.33333334f, 0.5f, 0.6666667f, 1.0f};
    public static final float[] WEST_UV = new float[]{0.6666667f, 0.5f, 1.0f, 1.0f};
    public static final float[] DOWN_UV = new float[]{0.0f, 0.0f, 0.33333334f, 0.5f};
    public static final float[][] UV = new float[][]{UP_UV, NORTH_UV, EAST_UV, SOUTH_UV, WEST_UV, DOWN_UV};
    public static final float[][] THETA_PHI = new float[][]{{0.0f, 0.0f}, {(float)Math.toRadians(180.0), (float)Math.toRadians(90.0)}, {(float)Math.toRadians(90.0), (float)Math.toRadians(90.0)}, {(float)Math.toRadians(0.0), (float)Math.toRadians(90.0)}, {(float)Math.toRadians(-90.0), (float)Math.toRadians(90.0)}, {0.0f, (float)Math.toRadians(180.0)}};
    public static final String[] SUFFIXES = new String[]{"_up", "_north", "_east", "_south", "_west", "_down"};
    protected Minecraft minecraft = Minecraft.m_91087_();
    protected ResourceLocation texturePath;

    public StellarViewSkybox(ResourceLocation texturePath) {
        this.texturePath = texturePath;
    }

    public void render(ClientLevel level, float partialTicks, PoseStack stack, BufferBuilder bufferbuilder, float skyXAngle, float skyYAngle, float skyZAngle) {
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(skyXAngle));
        stack.m_252781_(Axis.f_252403_.m_252977_(skyYAngle));
        stack.m_252781_(Axis.f_252529_.m_252977_(skyZAngle));
        Matrix4f lastMatrix = stack.m_85850_().m_252922_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        for (int i = 0; i < 6; ++i) {
            Object path = this.texturePath.m_135815_() + ".png";
            boolean resourcePresent = this.minecraft.m_91098_().m_213713_(this.texturePath.m_247449_((String)path)).isPresent();
            path = resourcePresent ? this.texturePath.m_135815_() : this.texturePath.m_135815_() + SUFFIXES[i];
            path = (String)path + ".png";
            float[] uv = resourcePresent ? UV[i] : FULL_UV;
            this.renderFacade(bufferbuilder, lastMatrix, this.texturePath.m_247449_((String)path), THETA_PHI[i][0], THETA_PHI[i][1], uv);
        }
        RenderSystem.defaultBlendFunc();
        stack.m_85849_();
    }

    protected void renderFacade(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation texture, float theta, float phi, float[] uv) {
        if (!this.minecraft.m_91098_().m_213713_(texture).isPresent()) {
            return;
        }
        float[] corner00 = StellarCoordinates.placeOnSphere(-150.0f, -150.0f, 150.0f, theta, phi, 0.0);
        float[] corner10 = StellarCoordinates.placeOnSphere(150.0f, -150.0f, 150.0f, theta, phi, 0.0);
        float[] corner11 = StellarCoordinates.placeOnSphere(150.0f, 150.0f, 150.0f, theta, phi, 0.0);
        float[] corner01 = StellarCoordinates.placeOnSphere(-150.0f, 150.0f, 150.0f, theta, phi, 0.0);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(lastMatrix, corner00[0], corner00[1], corner00[2]).m_7421_(uv[0], uv[3]).m_5752_();
        bufferbuilder.m_252986_(lastMatrix, corner10[0], corner10[1], corner10[2]).m_7421_(uv[2], uv[3]).m_5752_();
        bufferbuilder.m_252986_(lastMatrix, corner11[0], corner11[1], corner11[2]).m_7421_(uv[2], uv[1]).m_5752_();
        bufferbuilder.m_252986_(lastMatrix, corner01[0], corner01[1], corner01[2]).m_7421_(uv[0], uv[1]).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

