/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import net.povstalec.stellarview.api.celestials.orbiting.OrbitingCelestialObject;
import net.povstalec.stellarview.client.render.level.misc.StellarViewFogEffects;
import net.povstalec.stellarview.client.render.level.misc.StellarViewSkyEffects;
import net.povstalec.stellarview.client.render.level.misc.StellarViewSkybox;
import org.joml.Matrix4f;

public class StellarViewSky
implements StellarViewSkyEffects,
StellarViewFogEffects {
    protected Minecraft minecraft = Minecraft.m_91087_();
    @Nullable
    protected OrbitingCelestialObject center;
    @Nullable
    protected VertexBuffer skyBuffer;
    @Nullable
    protected VertexBuffer darkBuffer;
    protected StellarViewSkybox skybox = null;

    public StellarViewSky(OrbitingCelestialObject center) {
        this.center = center;
        this.skyBuffer = this.createLightSky();
        this.darkBuffer = this.createDarkSky();
    }

    public final StellarViewSky skybox(ResourceLocation texture) {
        this.skybox = new StellarViewSkybox(texture);
        return this;
    }

    protected void renderEcliptic(ClientLevel level, Camera camera, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        if (this.skybox != null) {
            this.skybox.render(level, partialTicks, stack, bufferbuilder, 0.0f, 0.0f, 0.0f);
        }
        this.center.renderLocalSky(level, camera, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder);
    }

    public void renderSky(ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        setupFog.run();
        if (this.isFoggy(this.minecraft, camera)) {
            return;
        }
        Vec3 skyColor = level.m_171660_(this.minecraft.f_91063_.m_109153_().m_90583_(), partialTicks);
        float skyX = (float)skyColor.f_82479_;
        float skyY = (float)skyColor.f_82480_;
        float skyZ = (float)skyColor.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.renderSunrise(level, partialTicks, stack, projectionMatrix, bufferbuilder);
        this.renderEcliptic(level, camera, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double height = this.minecraft.f_91074_.m_20299_((float)partialTicks).f_82480_ - level.m_6106_().m_171687_((LevelHeightAccessor)level);
        if (height < 0.0) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 12.0f, 0.0f);
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
            VertexBuffer.m_85931_();
            stack.m_85849_();
        }
        if (level.m_104583_().m_108882_()) {
            RenderSystem.setShaderColor((float)(skyX * 0.2f + 0.04f), (float)(skyY * 0.2f + 0.04f), (float)(skyZ * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }
}

