/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.StellarViewSpecialEffects;
import net.povstalec.stellarview.api.celestials.Galaxy;
import net.povstalec.stellarview.api.celestials.Supernova;
import net.povstalec.stellarview.api.celestials.orbiting.Barycenter;
import net.povstalec.stellarview.api.celestials.orbiting.Moon;
import net.povstalec.stellarview.api.celestials.orbiting.Planet;
import net.povstalec.stellarview.api.celestials.orbiting.Sun;
import net.povstalec.stellarview.api.sky_effects.MeteorShower;
import net.povstalec.stellarview.api.sky_effects.ShootingStar;
import net.povstalec.stellarview.client.render.level.StellarViewSky;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import net.povstalec.stellarview.compatibility.enhancedcelestials.EnhancedCelestialsCompatibility;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StellarViewOverworldEffects
extends StellarViewSpecialEffects {
    public static final ResourceLocation OVERWORLD_EFFECTS = new ResourceLocation("overworld");
    public static final ResourceLocation OVERWORLD_SKYBOX = new ResourceLocation("stellarview", "textures/environment/overworld_skybox/overworld");
    public static final int EARTH_YEAR_DAYS = 96;
    private static final Moon LUNA = new Moon.DefaultMoon(){

        @Override
        protected float getAngularVelocity(ClientLevel level, float partialTicks) {
            return 45.0f + 360.0f / (float)OverworldConfig.overworld_year_length.get();
        }

        @Override
        protected boolean shouldRender(ClientLevel level, Camera camera) {
            return !OverworldConfig.disable_moon.get();
        }

        @Override
        protected boolean hasPhases() {
            return !OverworldConfig.disable_moon_phases.get();
        }

        @Override
        protected float getSize(ClientLevel level, float partialTicks) {
            if (StellarView.isEnhancedCelestialsLoaded()) {
                return EnhancedCelestialsCompatibility.getMoonSize(partialTicks);
            }
            return super.getSize(level, partialTicks);
        }

        @Override
        protected float[] getColor(ClientLevel level, float partialTicks) {
            if (!StellarView.isEnhancedCelestialsLoaded()) {
                return super.getColor(level, partialTicks);
            }
            return EnhancedCelestialsCompatibility.getMoonColor(level, partialTicks);
        }
    };
    private static final Moon IO = (Moon)new Moon(Moon.IO_TEXTURE, 0.15f).halo(Moon.IO_HALO_TEXTURE, 0.15f);
    private static final Moon EUROPA = (Moon)new Moon(Moon.EUROPA_TEXTURE, 0.125f).halo(Moon.EUROPA_HALO_TEXTURE, 0.125f);
    private static final Moon GANYMEDE = (Moon)new Moon(Moon.GANYMEDE_TEXTURE, 0.25f).halo(Moon.GANYMEDE_HALO_TEXTURE, 0.25f);
    private static final Moon CALLISTO = (Moon)new Moon(Moon.CALLISTO_TEXTURE, 0.2f).halo(Moon.CALLISTO_HALO_TEXTURE, 0.2f);
    private static final Moon ENCELADUS = (Moon)new Moon(Moon.ENCELADUS_TEXTURE, 0.1f).halo(Moon.ENCELADUS_HALO_TEXTURE, 0.1f);
    private static final Moon TETHYS = (Moon)new Moon(Moon.TETHYS_TEXTURE, 0.15f).halo(Moon.TETHYS_HALO_TEXTURE, 0.15f);
    private static final Moon DIONE = (Moon)new Moon(Moon.DIONE_TEXTURE, 0.15f).halo(Moon.DIONE_HALO_TEXTURE, 0.15f);
    private static final Moon RHEA = (Moon)new Moon(Moon.RHEA_TEXTURE, 0.15f).halo(Moon.RHEA_HALO_TEXTURE, 0.15f);
    private static final Moon TITAN = (Moon)new Moon(Moon.TITAN_TEXTURE, 0.25f).halo(Moon.TITAN_HALO_TEXTURE, 0.25f);
    private static final Moon IAPETUS = (Moon)new Moon(Moon.IAPETUS_TEXTURE, 0.15f).halo(Moon.IAPETUS_HALO_TEXTURE, 0.15f);
    private static final Moon ARIEL = (Moon)new Moon(Moon.ARIEL_TEXTURE, 0.075f).halo(Moon.ARIEL_HALO_TEXTURE, 0.075f);
    private static final Moon UMBRIEL = (Moon)new Moon(Moon.UMBRIEL_TEXTURE, 0.075f).halo(Moon.UMBRIEL_HALO_TEXTURE, 0.075f);
    private static final Moon TITANIA = (Moon)new Moon(Moon.TITANIA_TEXTURE, 0.075f).halo(Moon.TITANIA_HALO_TEXTURE, 0.075f);
    private static final Moon OBERON = (Moon)new Moon(Moon.OBERON_TEXTURE, 0.075f).halo(Moon.OBERON_HALO_TEXTURE, 0.075f);
    private static final Moon TRITON = (Moon)new Moon(Moon.TRITON_TEXTURE, 0.08f).halo(Moon.TRITON_HALO_TEXTURE, 0.08f);
    private static final Moon PLUTO = (Moon)new Moon(Moon.PLUTO_TEXTURE, 0.15f).halo(Moon.PLUTO_HALO_TEXTURE, 0.15f);
    private static final Moon CHARON = (Moon)new Moon(Moon.CHARON_TEXTURE, 0.1f).halo(Moon.CHARON_HALO_TEXTURE, 0.1f);
    private static final Planet MERCURY = (Planet)new Planet(Planet.MERCURY_TEXTURE, 0.7f).halo(Planet.MERCURY_HALO_TEXTURE, 0.7f);
    private static final Planet VENUS = (Planet)new Planet(Planet.VENUS_TEXTURE, 0.9f).halo(Planet.VENUS_HALO_TEXTURE, 0.9f);
    private static final Planet EARTH = (Planet)new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000){

        @Override
        protected float getAngularVelocity(ClientLevel level, float partialTicks) {
            return 360.0f / (float)OverworldConfig.overworld_year_length.get();
        }
    }.addAtmosphere(new Planet.Atmosphere((ShootingStar)new ShootingStar().setRarityValue(OverworldConfig.shooting_star_chance), (MeteorShower)new MeteorShower().setRarityValue(OverworldConfig.meteor_shower_chance))).addOrbitingObject(LUNA, 384400.0f, 45.0f, (float)Math.toRadians(-22.5), (float)Math.toRadians(-5.145), 0.0f);
    private static final Planet MARS = (Planet)new Planet(Planet.MARS_TEXTURE, 0.8f).halo(Planet.MARS_HALO_TEXTURE, 0.8f);
    private static final Planet VESTA = (Planet)new Planet(Planet.VESTA_TEXTURE, 0.35f).halo(Planet.VESTA_HALO_TEXTURE, 0.35f);
    private static final Planet CERES = (Planet)new Planet(Planet.CERES_TEXTURE, 0.4f).halo(Planet.CERES_HALO_TEXTURE, 0.4f);
    private static final Planet JUPITER = (Planet)new Planet(Planet.JUPITER_TEXTURE, 1.5f).addOrbitingObject(IO, 4217000.0f, 180.0f, 1.0f, (float)Math.toRadians(0.05), (float)Math.toRadians(47.0)).addOrbitingObject(EUROPA, 6710340.0f, 90.0f, 22.0f, (float)Math.toRadians(0.47), (float)Math.toRadians(180.0)).addOrbitingObject(GANYMEDE, 1.070412E7f, 51.42857f, 44.0f, (float)Math.toRadians(0.2), (float)Math.toRadians(13.0)).addOrbitingObject(CALLISTO, 1.882709E7f, 22.5f, 88.0f, (float)Math.toRadians(0.192), (float)Math.toRadians(213.0)).halo(Planet.JUPITER_HALO_TEXTURE, 1.5f);
    private static final Planet SATURN = (Planet)new Planet(Planet.SATURN_TEXTURE, 1.0f).addOrbitingObject(ENCELADUS, 5950000.0f, 997.2299f, 16.0f, (float)Math.toRadians(0.009), (float)Math.toRadians(176.0)).addOrbitingObject(TETHYS, 7350000.0f, 724.34607f, 32.0f, (float)Math.toRadians(1.12), (float)Math.toRadians(19.0)).addOrbitingObject(DIONE, 9425000.0f, 499.30652f, 64.0f, (float)Math.toRadians(0.02), (float)Math.toRadians(64.0)).addOrbitingObject(RHEA, 1.3175E7f, 302.77545f, 128.0f, (float)Math.toRadians(0.35), (float)Math.toRadians(110.0)).addOrbitingObject(TITAN, 3.0E7f, 90.0f, 256.0f, (float)Math.toRadians(0.348), (float)Math.toRadians(99.0)).addOrbitingObject(IAPETUS, 8.90205E7f, 17.142857f, 152.0f, (float)Math.toRadians(15.47), (float)Math.toRadians(144.0)).halo(Planet.SATURN_HALO_TEXTURE, 1.0f);
    private static final Planet URANUS = (Planet)new Planet(Planet.URANUS_TEXTURE, 0.5f).addOrbitingObject(ARIEL, 1.9102E7f, 542.98645f, 7.0f, (float)Math.toRadians(98.041), (float)Math.toRadians(8.0)).addOrbitingObject(UMBRIEL, 2.663E7f, 329.9725f, 77.0f, (float)Math.toRadians(98.128), (float)Math.toRadians(16.0)).addOrbitingObject(TITANIA, 4.363E7f, 157.06805f, 177.0f, (float)Math.toRadians(98.079), (float)Math.toRadians(32.0)).addOrbitingObject(OBERON, 5.835E7f, 101.63749f, 277.0f, (float)Math.toRadians(157.34), (float)Math.toRadians(64.0)).halo(Planet.URANUS_HALO_TEXTURE, 0.5f);
    private static final Planet NEPTUNE = (Planet)new Planet(Planet.NEPTUNE_TEXTURE, 0.3f).addOrbitingObject(TRITON, 3.548E7f, 232.70847f, 277.0f, (float)Math.toRadians(98.058), (float)Math.toRadians(64.0)).halo(Planet.NEPTUNE_HALO_TEXTURE, 0.3f);
    private static final Barycenter PLUTO_CHARON_BARYCENTER = (Barycenter)new Barycenter(Moon.PLUTO_TEXTURE, 30.0f).addOrbitingObject(PLUTO, 2920000.0f, 214.15823f, 0.0f, (float)Math.toRadians(0.001), (float)Math.toRadians(69.0)).addOrbitingObject(CHARON, 4.91E7f, 214.15823f, 180.0f, (float)Math.toRadians(0.001), (float)Math.toRadians(96.0));
    private static final Sun SOL = (Sun)new Sun.VanillaSun(){

        @Override
        protected boolean shouldRender(ClientLevel level, Camera camera) {
            return !OverworldConfig.disable_sun.get();
        }

        @Override
        public Vector3f getAxisRotation() {
            return new Vector3f((float)OverworldConfig.milky_way_x_axis_rotation.get(), (float)OverworldConfig.milky_way_y_axis_rotation.get(), (float)OverworldConfig.milky_way_z_axis_rotation.get());
        }
    }.addOrbitingObject(MERCURY, 5.4207E7f, 15.652174f, (float)Math.toRadians(52.0), (float)Math.toRadians(7.0), (float)Math.toRadians(113.0)).addOrbitingObject(VENUS, 1.0754E8f, 6.101695f, (float)Math.toRadians(241.0), (float)Math.toRadians(1.85), (float)Math.toRadians(123.0)).addOrbitingObject(MARS, 2.2638E8f, 2.0f, (float)Math.toRadians(139.0), (float)Math.toRadians(3.39), (float)Math.toRadians(79.0)).addOrbitingObject(VESTA, 3.56E8f, 1.0315186f, (float)Math.toRadians(174.0), (float)Math.toRadians(7.14), (float)Math.toRadians(104.0)).addOrbitingObject(CERES, 4.13E8f, 0.81447965f, (float)Math.toRadians(81.0), (float)Math.toRadians(10.59), (float)Math.toRadians(80.0)).addOrbitingObject(JUPITER, 7.4501E8f, 0.3125f, (float)Math.toRadians(71.0), (float)Math.toRadians(1.31), (float)Math.toRadians(62.0)).addOrbitingObject(SATURN, 1.4552E9f, 0.1275691f, (float)Math.toRadians(190.0), (float)Math.toRadians(2.48), (float)Math.toRadians(93.0)).addOrbitingObject(URANUS, 2.9329E9f, 0.04464286f, (float)Math.toRadians(270.0), (float)Math.toRadians(1.0), (float)Math.toRadians(36.0)).addOrbitingObject(NEPTUNE, 4.4725E9f, 0.022727273f, (float)Math.toRadians(311.0), (float)Math.toRadians(1.77), (float)Math.toRadians(1.0)).addOrbitingObject(PLUTO_CHARON_BARYCENTER, 5.9E9f, 0.015081061f, (float)Math.toRadians(80.0), (float)Math.toRadians(17.14), (float)Math.toRadians(0.0)).addOrbitingObject(EARTH, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
    public static final Galaxy.SpiralGalaxy MILKY_WAY = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(Galaxy.SPIRAL_GALAXY_TEXTURE, 100.0f, 10842L, 4, 1500).addGalacticObject(new Supernova(10.0f, 378000L, 120000L), 10.0f, -3.0f, 2.0f).addGalacticObject(SOL, 0.0f, 0.0f, 16.0f, 18.0f, 0.0f, 90.0f);

    public StellarViewOverworldEffects() {
        super(new StellarViewSky(EARTH).skybox(OVERWORLD_SKYBOX), 192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public void setupGalaxy() {
        MILKY_WAY.setStarBuffer(OverworldConfig.milky_way_x.get(), OverworldConfig.milky_way_y.get(), OverworldConfig.milky_way_z.get(), 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (StellarViewConfig.replace_overworld.get()) {
            super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        return StellarViewConfig.replace_overworld.get();
    }

    @Override
    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (StellarViewConfig.replace_overworld.get()) {
            super.adjustLightmapColors(level, partialTicks, skyDarken, skyLight, blockLight, pixelX, pixelY, colors);
            if (StellarView.isEnhancedCelestialsLoaded()) {
                EnhancedCelestialsCompatibility.adjustLightmapColors(level, partialTicks, skyDarken, skyLight, blockLight, pixelX, pixelY, colors);
            }
        }
    }
}

