/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.povstalec.stellarview.api.StellarViewSpecialEffects;
import net.povstalec.stellarview.api.celestials.Galaxy;
import net.povstalec.stellarview.api.celestials.Supernova;
import net.povstalec.stellarview.api.celestials.orbiting.Planet;
import net.povstalec.stellarview.api.celestials.orbiting.Sun;
import net.povstalec.stellarview.api.sky_effects.MeteorShower;
import net.povstalec.stellarview.api.sky_effects.ShootingStar;
import net.povstalec.stellarview.client.render.level.StellarViewSky;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StellarViewEndEffects
extends StellarViewSpecialEffects {
    public static final ResourceLocation END_EFFECTS = new ResourceLocation("the_end");
    public static final ResourceLocation END_SKYBOX = new ResourceLocation("stellarview", "textures/environment/overworld_skybox/end");
    private static final Planet END = new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000).addAtmosphere(new Planet.Atmosphere((ShootingStar)new ShootingStar().setRarityValue(OverworldConfig.shooting_star_chance), (MeteorShower)new MeteorShower().setRarityValue(OverworldConfig.meteor_shower_chance)));
    private static final Sun END_SUN = (Sun)new Sun.VanillaSun(){

        @Override
        protected boolean shouldRender(ClientLevel level, Camera camera) {
            return !OverworldConfig.disable_sun.get();
        }

        @Override
        public Vector3f getAxisRotation() {
            return new Vector3f(18.0f, 30.0f, 15.0f);
        }
    }.addOrbitingObject(END, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
    public static final Galaxy.SpiralGalaxy MILKY_WAY = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(Galaxy.SPIRAL_GALAXY_TEXTURE, 100.0f, 10842L, 4, 1500).addGalacticObject(new Supernova(10.0f, 378000L, 120000L), 10.0f, -3.0f, 2.0f).addGalacticObject(END_SUN, 36.0f, 8.0f, 16.0f, 18.0f, 30.0f, 15.0f);

    public StellarViewEndEffects() {
        super(new StellarViewSky(END).skybox(END_SKYBOX), Float.NaN, false, DimensionSpecialEffects.SkyType.END, true, false);
    }

    @Override
    public Vec3 m_5927_(Vec3 biomeFogColor, float daylight) {
        return biomeFogColor;
    }

    @Override
    public boolean m_5781_(int x, int y) {
        return true;
    }

    public void setupGalaxy() {
        MILKY_WAY.setStarBuffer(36.0f, 8.0f, 16.0f, 18.0f, 30.0f, 15.0f);
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (StellarViewConfig.replace_end.get()) {
            super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
        }
        return StellarViewConfig.replace_end.get();
    }
}

