/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.sky_effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import net.povstalec.stellarview.common.config.StellarViewConfigValue;
import org.joml.Matrix4f;

public abstract class SkyEffect {
    public static final float[] FULL_UV = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    public static final float DEFAULT_DISTANCE = 100.0f;
    protected Optional<StellarViewConfigValue.IntValue> value = Optional.empty();
    protected int defaultRarity = 0;

    public SkyEffect(int defaultRarity) {
        this.defaultRarity = defaultRarity;
    }

    public SkyEffect setRarityValue(StellarViewConfigValue.IntValue value) {
        this.value = Optional.of(value);
        return this;
    }

    public SkyEffect setDefaultRarity(int defaultRarity) {
        this.defaultRarity = defaultRarity;
        return this;
    }

    public int getRarity() {
        return this.value.isPresent() ? this.value.get().get() : this.defaultRarity;
    }

    protected float getBrightness(ClientLevel level, Camera camera, float partialTicks) {
        float brightness = level.m_104811_(partialTicks);
        float f = brightness = StellarViewConfig.day_stars.get() && brightness < 0.5f ? 0.5f : brightness;
        if (StellarViewConfig.bright_stars.get()) {
            brightness *= 1.0f + (float)(15 - level.m_5518_().m_75831_(camera.m_90592_().m_20097_().m_7494_(), 15)) / 15.0f;
        }
        return brightness * (1.0f - level.m_46722_(partialTicks));
    }

    protected void renderEffect(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation texture, float[] uv, float size, float rotation, float theta, float phi, float brightness) {
        if (uv == null || uv.length < 4) {
            uv = FULL_UV;
        }
        float[] corner00 = StellarCoordinates.placeOnSphere(-size, -size, 100.0f, theta, phi, rotation);
        float[] corner10 = StellarCoordinates.placeOnSphere(size, -size, 100.0f, theta, phi, rotation);
        float[] corner11 = StellarCoordinates.placeOnSphere(size, size, 100.0f, theta, phi, rotation);
        float[] corner01 = StellarCoordinates.placeOnSphere(-size, size, 100.0f, theta, phi, rotation);
        if (brightness > 0.0f) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)brightness);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(lastMatrix, corner00[0], corner00[1], corner00[2]).m_7421_(uv[0], uv[1]).m_5752_();
            bufferbuilder.m_252986_(lastMatrix, corner10[0], corner10[1], corner10[2]).m_7421_(uv[2], uv[1]).m_5752_();
            bufferbuilder.m_252986_(lastMatrix, corner11[0], corner11[1], corner11[2]).m_7421_(uv[2], uv[3]).m_5752_();
            bufferbuilder.m_252986_(lastMatrix, corner01[0], corner01[1], corner01[2]).m_7421_(uv[0], uv[3]).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.defaultBlendFunc();
        }
    }

    public abstract void render(ClientLevel var1, Camera var2, float var3, PoseStack var4, BufferBuilder var5);
}

