/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.sky_effects;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.stellarview.api.sky_effects.SkyEffect;

public class ShootingStar
extends SkyEffect {
    public static final ResourceLocation METEOR_WHITE_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_white.png");
    public static final ResourceLocation METEOR_RED_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_red.png");
    public static final ResourceLocation METEOR_ORANGE_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_orange.png");
    public static final ResourceLocation METEOR_YELLOW_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_yellow.png");
    public static final ResourceLocation METEOR_CYAN_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_cyan.png");
    public static final ResourceLocation METEOR_BLUE_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_blue.png");
    public static final ResourceLocation METEOR_VIOLET_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_violet.png");
    ResourceLocation[] meteorColors = new ResourceLocation[]{METEOR_WHITE_TEXTURE, METEOR_RED_TEXTURE, METEOR_ORANGE_TEXTURE, METEOR_YELLOW_TEXTURE, METEOR_CYAN_TEXTURE, METEOR_BLUE_TEXTURE, METEOR_VIOLET_TEXTURE};
    protected static final int TICKS = 1000;
    protected static final float MAX_SIZE = 1.0f;
    protected static final int DURATION = 20;

    public ShootingStar() {
        super(100);
    }

    @Override
    public final void render(ClientLevel level, Camera camera, float partialTicks, PoseStack stack, BufferBuilder bufferbuilder) {
        long tickSeed = level.m_46468_() / 1000L;
        int specificTime = (int)(level.m_46468_() % 1000L);
        Random randomizer = new Random(tickSeed);
        int shootingStarchance = randomizer.nextInt(1, 101);
        int randomStart = randomizer.nextInt(0, 980);
        if (shootingStarchance <= this.getRarity() && specificTime >= randomStart && specificTime < randomStart + 20) {
            double position = level.m_46468_() % 20L;
            long shootingStarRandomizer = level.m_46468_() / 20L;
            Random random = new Random(shootingStarRandomizer);
            ResourceLocation meteorColor = this.meteorColors[randomizer.nextInt(this.meteorColors.length)];
            float xRotation = (float)((double)random.nextInt(0, 45) + Math.PI * Mth.m_14139_((double)partialTicks, (double)(position - 1.0), (double)position));
            float yRotation = random.nextInt(0, 360);
            float zRotation = random.nextInt(-70, 70);
            float rotation = (float)(Math.PI * position / 4.0);
            float size = (float)Math.sin(Math.PI * position / 20.0);
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252977_(yRotation));
            stack.m_252781_(Axis.f_252403_.m_252977_(zRotation));
            stack.m_252781_(Axis.f_252529_.m_252977_(xRotation));
            this.renderEffect(bufferbuilder, stack.m_85850_().m_252922_(), meteorColor, FULL_UV, size, rotation, 0.0f, 0.0f, this.getBrightness(level, camera, partialTicks));
            stack.m_85849_();
        }
    }
}

