/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.sky_effects;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.stellarview.api.sky_effects.SkyEffect;
import net.povstalec.stellarview.common.config.StellarViewConfig;

public class MeteorShower
extends SkyEffect {
    public static final ResourceLocation METEOR_WHITE_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_white.png");
    public static final ResourceLocation METEOR_RED_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_red.png");
    public static final ResourceLocation METEOR_ORANGE_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_orange.png");
    public static final ResourceLocation METEOR_YELLOW_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_yellow.png");
    public static final ResourceLocation METEOR_CYAN_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_cyan.png");
    public static final ResourceLocation METEOR_BLUE_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_blue.png");
    public static final ResourceLocation METEOR_VIOLET_TEXTURE = new ResourceLocation("stellarview", "textures/environment/sky_effect/meteor/meteor_violet.png");
    protected static final int DAY_LENGTH = 24000;
    protected static final int DURATION = 20;

    public MeteorShower() {
        super(100);
    }

    @Override
    public final void render(ClientLevel level, Camera camera, float partialTicks, PoseStack stack, BufferBuilder bufferbuilder) {
        long dailySeed = level.m_46468_() / 24000L;
        ResourceLocation showerColor = MeteorType.randomMeteorType(dailySeed).getTexture();
        Random randomizer = new Random(dailySeed);
        int meteorShowerChance = randomizer.nextInt(1, 101);
        if (meteorShowerChance <= this.getRarity()) {
            double position = level.m_46468_() % 20L;
            long meteorRandomizer = level.m_46468_() / 20L;
            Random random = new Random(meteorRandomizer);
            float xRotation = (float)((double)random.nextInt(0, 45) + Math.PI * Mth.m_14139_((double)partialTicks, (double)(position - 1.0), (double)position));
            float yRotation = random.nextInt(0, 360);
            float zRotation = random.nextInt(-70, 70);
            float rotation = (float)(Math.PI * position / 4.0);
            float size = (float)Math.sin(Math.PI * position / 20.0);
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252977_(yRotation));
            stack.m_252781_(Axis.f_252403_.m_252977_(zRotation));
            stack.m_252781_(Axis.f_252529_.m_252977_(xRotation));
            this.renderEffect(bufferbuilder, stack.m_85850_().m_252922_(), showerColor, FULL_UV, size, rotation, 0.0f, 0.0f, this.getBrightness(level, camera, partialTicks));
            stack.m_85849_();
        }
    }

    public static enum MeteorType {
        WHITE(METEOR_WHITE_TEXTURE),
        RED(METEOR_RED_TEXTURE),
        ORANGE(METEOR_ORANGE_TEXTURE),
        YELLOW(METEOR_YELLOW_TEXTURE),
        CYAN(METEOR_CYAN_TEXTURE),
        BLUE(METEOR_BLUE_TEXTURE),
        VIOLET(METEOR_VIOLET_TEXTURE);

        private ResourceLocation texture;

        private MeteorType(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static MeteorType randomMeteorType(long seed) {
            Random random = new Random(seed);
            if (StellarViewConfig.equal_spectral_types.get()) {
                MeteorType[] meteorTypes = MeteorType.values();
                return meteorTypes[random.nextInt(0, meteorTypes.length)];
            }
            int value = random.nextInt(0, 100);
            if (value < 40) {
                return WHITE;
            }
            if (value < 50) {
                return RED;
            }
            if (value < 75) {
                return ORANGE;
            }
            if (value < 85) {
                return YELLOW;
            }
            if (value < 90) {
                return CYAN;
            }
            if (value < 95) {
                return BLUE;
            }
            return VIOLET;
        }
    }
}

