/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials.orbiting;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.celestials.StarField;
import net.povstalec.stellarview.api.celestials.StellarObject;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class OrbitingCelestialObject
extends StellarObject {
    protected float angularVelocity = 0.0f;
    protected float distance = 0.0f;
    protected float initialTetha = 0.0f;
    protected float initialPhi = 0.0f;
    protected List<OrbitingCelestialObject> orbitingObjects = new ArrayList<OrbitingCelestialObject>();

    public OrbitingCelestialObject(ResourceLocation texture, float size) {
        super(texture, size);
    }

    protected float getAngularVelocity(ClientLevel level, float partialTicks) {
        return this.angularVelocity;
    }

    @Override
    protected float getTetha(ClientLevel level, float partialTicks) {
        return this.initialTetha * (float)Math.sin(Math.toRadians(this.getAngularVelocity(level, partialTicks) * ((float)level.m_46468_() / 24000.0f)));
    }

    @Override
    protected float getPhi(ClientLevel level, float partialTicks) {
        return this.initialPhi + (float)Math.toRadians(this.getAngularVelocity(level, partialTicks) * ((float)level.m_46468_() / 24000.0f));
    }

    @Override
    protected float getSize(ClientLevel level, float partialTicks) {
        return this.size;
    }

    public final OrbitingCelestialObject addOrbitingObject(OrbitingCelestialObject object, float distance, float angularVelocity, float initialPhi, float initialTetha, float rotation) {
        if (object.primaryBody.isPresent()) {
            StellarView.LOGGER.error("Object is already orbiting a primary body");
            return this;
        }
        object.primaryBody = Optional.of(this);
        object.distance = distance;
        object.angularVelocity = angularVelocity;
        object.initialPhi = initialPhi;
        object.initialTetha = initialTetha;
        this.rotation = rotation;
        this.orbitingObjects.add(object);
        return this;
    }

    public Vector3f getRelativeCartesianCoordinates(ClientLevel level, float partialTicks) {
        return StellarCoordinates.sphericalToCartesian(new Vector3f(this.distance, this.getTetha(level, partialTicks), this.getPhi(level, partialTicks)));
    }

    public float getDistanceSquaredFromViewCenter(Vector3f vievCenterCoords, Vector3f parentCoords, ClientLevel level, float partialTicks) {
        Vector3f relativeCoords = this.getRelativeCartesianCoordinates(level, partialTicks);
        Vector3f absoluteCoords = StellarCoordinates.absoluteVector(parentCoords, relativeCoords);
        return StellarCoordinates.relativeVector(vievCenterCoords, absoluteCoords).lengthSquared();
    }

    @Override
    protected Vector3f findRelative(Vector3f vievCenterCoords, Vector3f coords) {
        return StellarCoordinates.relativeVector(coords, vievCenterCoords);
    }

    @Override
    public void render(OrbitingCelestialObject viewCenter, Vector3f vievCenterCoords, ClientLevel level, Camera camera, float partialTicks, PoseStack stack, BufferBuilder bufferbuilder, Vector3f skyAxisRotation, Vector3f parentCoords) {
        Vector3f relativeCoords = this.getRelativeCartesianCoordinates(level, partialTicks);
        Vector3f absoluteCoords = StellarCoordinates.absoluteVector(parentCoords, relativeCoords);
        float distanceSquared = StellarCoordinates.relativeVector(absoluteCoords, vievCenterCoords).lengthSquared();
        this.orbitingObjects.stream().forEach(orbitingObject -> {
            if (this.getDistanceSquaredFromViewCenter(vievCenterCoords, absoluteCoords, level, partialTicks) > distanceSquared) {
                orbitingObject.render(viewCenter, vievCenterCoords, level, camera, partialTicks, stack, bufferbuilder, skyAxisRotation, absoluteCoords);
            }
        });
        super.render(viewCenter, vievCenterCoords, level, camera, partialTicks, stack, bufferbuilder, skyAxisRotation, absoluteCoords);
        this.orbitingObjects.stream().forEach(orbitingObject -> {
            if (this.getDistanceSquaredFromViewCenter(vievCenterCoords, absoluteCoords, level, partialTicks) <= distanceSquared) {
                orbitingObject.render(viewCenter, vievCenterCoords, level, camera, partialTicks, stack, bufferbuilder, skyAxisRotation, absoluteCoords);
            }
        });
    }

    public void renderFrom(OrbitingCelestialObject viewCenter, Vector3f viewCenterCoords, ClientLevel level, Camera camera, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder, Vector3f skyAxisRotation, Vector3f axisRotation) {
        Vector3f absoluteCoords = StellarCoordinates.absoluteVector(viewCenterCoords, this.getRelativeCartesianCoordinates(level, partialTicks));
        if (this.primaryBody.isPresent()) {
            Object t = this.primaryBody.get();
            if (t instanceof OrbitingCelestialObject) {
                OrbitingCelestialObject parent = (OrbitingCelestialObject)t;
                parent.renderFrom(viewCenter, absoluteCoords, level, camera, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder, skyAxisRotation, StellarCoordinates.addVectors(this.getAxisRotation(), axisRotation));
            } else {
                t = this.primaryBody.get();
                if (t instanceof StarField) {
                    StarField starField = (StarField)t;
                    if (!StellarViewConfig.disable_stars.get()) {
                        float rain = 1.0f - level.m_46722_(partialTicks);
                        starField.render(this, viewCenter, viewCenterCoords, level, camera, partialTicks, rain, stack, projectionMatrix, setupFog, bufferbuilder, skyAxisRotation, StellarCoordinates.addVectors(this.getAxisRotation(), axisRotation), new Vector3f(0.0f, 0.0f, 0.0f));
                    }
                }
            }
        } else {
            this.render(viewCenter, absoluteCoords, level, camera, partialTicks, stack, bufferbuilder, skyAxisRotation, new Vector3f(0.0f, 0.0f, 0.0f));
        }
    }

    public void renderLocalSky(ClientLevel level, Camera camera, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder) {
        this.renderFrom(this, new Vector3f(0.0f, 0.0f, 0.0f), level, camera, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public static double approximateEccentricAnomaly(double eccentricity, double meanAnomaly) {
        double E = meanAnomaly;
        for (int i = 0; i < 12; ++i) {
            E -= (E - eccentricity * Math.sin(E) - meanAnomaly) / (1.0 - eccentricity * Math.cos(E));
        }
        return E;
    }
}

