/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.api.celestials.StellarObject;

public class Supernova
extends StellarObject {
    public static final ResourceLocation SUPERNOVA_TEXTURE = new ResourceLocation("stellarview", "textures/environment/supernova.png");
    protected static final float INITIAL_SIZE = 1.0f;
    protected ResourceLocation nebulaTexture;
    protected float maxSize;
    protected long start;
    protected long duration;

    public Supernova(ResourceLocation texture, float maxSize, long start, long duration) {
        super(texture, 1.0f);
        this.maxSize = maxSize;
        this.start = start;
        this.duration = duration;
    }

    public Supernova(float maxSize, long start, long duration) {
        this(SUPERNOVA_TEXTURE, maxSize, start, duration);
    }

    protected boolean isExploding(ClientLevel level) {
        long gameTime = level.m_46468_();
        return gameTime > this.start;
    }

    @Override
    protected boolean shouldBlend(ClientLevel level, Camera camera) {
        return true;
    }

    @Override
    protected boolean isVisibleDuringDay(ClientLevel level, Camera camera) {
        return this.isExploding(level);
    }

    @Override
    protected boolean shouldRender(ClientLevel level, Camera camera) {
        long gameTime = level.m_46468_();
        return gameTime <= this.start + this.duration;
    }

    @Override
    protected float getSize(ClientLevel level, float partialTicks) {
        long gameTime = level.m_46468_();
        long lifeTime = gameTime - this.start;
        float superNovaSize = (float)((double)this.maxSize * Math.sin(Math.PI * (double)lifeTime / (double)this.duration));
        float visualSize = this.isExploding(level) && (superNovaSize >= this.size || lifeTime > this.duration / 2L) ? superNovaSize : this.size;
        return this.distanceSize(visualSize) * 10.0f;
    }

    @Override
    protected float getRotation(ClientLevel level, float partialTicks) {
        long gameTime = level.m_46468_();
        long lifeTime = gameTime - this.start;
        return gameTime > this.start ? (float)(Math.PI * (double)lifeTime / (double)this.duration) + this.rotation : this.rotation;
    }
}

