/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.api.celestials.CelestialObject;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;
import org.joml.Vector3f;

public abstract class StellarObject
extends CelestialObject {
    protected float size;
    protected Vector3f coordinates = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Vector3f offsetCoords = new Vector3f(0.0f, 0.0f, 0.0f);
    protected Optional<StellarObject> primaryBody = Optional.empty();

    public StellarObject(ResourceLocation texture, float size) {
        super(texture);
        this.size = size;
    }

    @Override
    protected float getTetha(ClientLevel level, float partialTicks) {
        float x = -this.coordinates.x + this.offsetCoords.x;
        float y = -this.coordinates.y + this.offsetCoords.y;
        float z = -this.coordinates.z + this.offsetCoords.z;
        return (float)StellarCoordinates.sphericalTheta(x, y, z);
    }

    @Override
    protected float getPhi(ClientLevel level, float partialTicks) {
        float x = -this.coordinates.x + this.offsetCoords.x;
        float y = -this.coordinates.y + this.offsetCoords.y;
        float z = -this.coordinates.z + this.offsetCoords.z;
        return (float)StellarCoordinates.sphericalPhi(x, y, z);
    }

    protected float distanceSize(float size) {
        float x = -this.coordinates.x + this.offsetCoords.x;
        float y = -this.coordinates.y + this.offsetCoords.y;
        float z = -this.coordinates.z + this.offsetCoords.z;
        float distance = x * x + y * y + z * z;
        return size * (1.0f / (float)Math.sqrt(distance));
    }

    @Override
    protected float getSize(ClientLevel level, float partialTicks) {
        return this.distanceSize(this.size);
    }

    public StellarObject setGalacticPosition(float galacticX, float galacticY, float galacticZ) {
        this.coordinates.x = galacticX;
        this.coordinates.y = galacticY;
        this.coordinates.z = galacticZ;
        return this;
    }

    public StellarObject setOffset(float xOffset, float yOffset, float zOffset) {
        this.offsetCoords.x = xOffset;
        this.offsetCoords.y = yOffset;
        this.offsetCoords.z = zOffset;
        return this;
    }

    public StellarObject setRotation(float xRotation, float yRotation, float zRotation) {
        this.axisRotation.x = xRotation;
        this.axisRotation.y = yRotation;
        this.axisRotation.z = zRotation;
        return this;
    }

    public StellarObject setRotation(Vector3f rotation) {
        this.axisRotation.x = rotation.x;
        this.axisRotation.y = rotation.y;
        this.axisRotation.z = rotation.z;
        return this;
    }

    public float getX() {
        return this.coordinates.x;
    }

    public float getY() {
        return this.coordinates.y;
    }

    public float getZ() {
        return this.coordinates.z;
    }

    public Vector3f getAxisRotation() {
        return this.axisRotation;
    }
}

