/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.povstalec.stellarview.api.celestials.Star;
import net.povstalec.stellarview.api.celestials.StellarObject;
import net.povstalec.stellarview.api.celestials.orbiting.OrbitingCelestialObject;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class StarField
extends StellarObject {
    @Nullable
    protected VertexBuffer starBuffer;
    private List<StellarObject> galacticObjects = new ArrayList<StellarObject>();
    protected long seed;
    protected short numberOfStars;
    protected Vector3f offset = new Vector3f(0.0f, 0.0f, 0.0f);

    public StarField(ResourceLocation texture, float size, long seed, short numberOfStars) {
        super(texture, size);
        this.seed = seed;
        this.numberOfStars = numberOfStars;
    }

    public StarField setStarBuffer(float xOffset, float yOffset, float zOffset, float xAxisRotation, float yAxisRotation, float zAxisRotation) {
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        this.offsetCoords.x = xOffset;
        this.offsetCoords.y = yOffset;
        this.offsetCoords.z = zOffset;
        this.setRotation(xAxisRotation, yAxisRotation, zAxisRotation);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.getStarBuffer(bufferBuilder, xOffset, yOffset, zOffset, xAxisRotation, yAxisRotation, zAxisRotation);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
        return this;
    }

    public final StarField addGalacticObject(StellarObject object, float x, float y, float z) {
        this.addGalacticObject(object, x, y, z, 0.0f, 0.0f, 0.0f);
        return this;
    }

    public final StarField addGalacticObject(StellarObject object, float x, float y, float z, float xRotation, float yRotation, float zRotation) {
        this.galacticObjects.add(object.setGalacticPosition(x, y, z).setRotation(xRotation, yRotation, zRotation));
        object.primaryBody = Optional.of(this);
        return this;
    }

    protected abstract BufferBuilder.RenderedBuffer getStarBuffer(BufferBuilder var1, float var2, float var3, float var4, float var5, float var6, float var7);

    protected void renderStars(ClientLevel level, Camera camera, float partialTicks, float rain, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, Vector3f skyAxisRotation, Vector3f axisRotation) {
        float starBrightness = Star.getStarBrightness(level, camera, partialTicks);
        if (starBrightness > 0.0f) {
            stack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)starBrightness);
            FogRenderer.m_109017_();
            stack.m_252781_(Axis.f_252436_.m_252977_(skyAxisRotation.y));
            stack.m_252781_(Axis.f_252403_.m_252977_(skyAxisRotation.z));
            stack.m_252781_(Axis.f_252529_.m_252977_(skyAxisRotation.x));
            stack.m_252781_(Axis.f_252436_.m_252977_(axisRotation.y));
            stack.m_252781_(Axis.f_252403_.m_252977_(axisRotation.z));
            stack.m_252781_(Axis.f_252529_.m_252977_(axisRotation.x));
            this.starBuffer.m_85921_();
            this.starBuffer.m_253207_(stack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172811_());
            VertexBuffer.m_85931_();
            setupFog.run();
            stack.m_85849_();
        }
    }

    public void render(OrbitingCelestialObject viewCenterParent, OrbitingCelestialObject viewCenter, Vector3f viewCenterCoords, ClientLevel level, Camera camera, float partialTicks, float rain, PoseStack stack, Matrix4f projectionMatrix, Runnable setupFog, BufferBuilder bufferbuilder, Vector3f skyAxisRotation, Vector3f axisRotation, Vector3f coords) {
        if (this.starBuffer != null) {
            this.renderStars(level, camera, partialTicks, rain, stack, projectionMatrix, setupFog, skyAxisRotation, axisRotation);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        this.galacticObjects.stream().forEach(galacticObject -> {
            if (!galacticObject.equals(viewCenterParent)) {
                galacticObject.setRotation(axisRotation);
            } else {
                galacticObject.setRotation(new Vector3f(0.0f, 0.0f, 0.0f));
            }
            galacticObject.render(viewCenter, viewCenterCoords, level, camera, partialTicks, stack, bufferbuilder, skyAxisRotation, StellarCoordinates.subtractVectors(StellarCoordinates.addVectors(this.offsetCoords, coords), galacticObject.coordinates));
        });
    }

    public static class VanillaStarField
    extends GlobularCluster {
        public VanillaStarField(ResourceLocation texture, float size) {
            super(texture, size, 10842L, (short)1500);
        }
    }

    public static class GlobularCluster
    extends StarField {
        public GlobularCluster(ResourceLocation texture, float size, long seed, short numberOfStars) {
            super(texture, size, seed, numberOfStars);
        }

        @Override
        protected BufferBuilder.RenderedBuffer getStarBuffer(BufferBuilder bufferBuilder, float xOffset, float yOffset, float zOffset, float xAxisRotation, float yAxisRotation, float zAxisRotation) {
            RandomSource randomsource = RandomSource.m_216335_((long)this.seed);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (int i = 0; i < this.numberOfStars; ++i) {
                double x = randomsource.m_188501_() * 2.0f - 1.0f;
                double y = randomsource.m_188501_() * 2.0f - 1.0f;
                double z = randomsource.m_188501_() * 2.0f - 1.0f;
                double starSize = 0.15f + randomsource.m_188501_() * 0.1f;
                double distance = x * x + y * y + z * z;
                Star.createVanillaStar(bufferBuilder, randomsource, x, y, z, starSize, distance, randomsource.m_188505_());
            }
            return bufferBuilder.m_231175_();
        }
    }
}

