/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.povstalec.stellarview.common.config.StellarViewConfig;

public class Star {
    private static final float DEFAULT_DISTANCE = 100.0f;
    private static final int CONTRAST = 8;
    private static final float MIN_STAR_SIZE = 0.15f;
    private static final float MAX_STAR_SIZE = 0.25f;
    private static final int MIN_STAR_BRIGHTNESS = 170;
    private static final int MAX_STAR_BRIGHTNESS = 255;

    public static double starWidthFunction(double aLocation, double bLocation, double sinRandom, double cosRandom, double sinTheta, double cosTheta, double sinPhi, double cosPhi) {
        double width = bLocation * cosRandom + aLocation * sinRandom;
        if (cosPhi > 0.0) {
            return cosPhi * 8.0 * width;
        }
        return width;
    }

    public static float getStarBrightness(ClientLevel level, Camera camera, float partialTicks) {
        float rain = 1.0f - level.m_46722_(partialTicks);
        float starBrightness = level.m_104811_(partialTicks);
        float f = starBrightness = StellarViewConfig.day_stars.get() && starBrightness < 0.5f ? 0.5f : starBrightness;
        if (StellarViewConfig.bright_stars.get()) {
            starBrightness *= 1.0f + (float)(15 - level.m_5518_().m_75831_(camera.m_90592_().m_20097_().m_7494_(), 15)) / 15.0f;
        }
        return starBrightness *= rain;
    }

    public static void createStar(BufferBuilder builder, RandomSource randomsource, double x, double y, double z, double distance, double heightDeformation, double widthDeformation, long seed) {
        int[] nArray;
        SpectralType spectralType = SpectralType.randomSpectralType(seed);
        if (StellarViewConfig.uniform_star_color.get()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 255;
            nArray2[1] = 255;
            nArray = nArray2;
            nArray2[2] = 255;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = spectralType.red();
            nArray3[1] = spectralType.green();
            nArray = nArray3;
            nArray3[2] = spectralType.blue();
        }
        int[] starColor = nArray;
        double starSize = spectralType.randomSize(seed);
        double maxStarSize = StellarViewConfig.distance_star_size.get() ? starSize : 0.2 + starSize * 1.0 / 5.0;
        double minStarSize = StellarViewConfig.distance_star_size.get() ? starSize : starSize * 3.0 / 5.0;
        int alpha = spectralType.randomBrightness(seed);
        if (StellarViewConfig.distance_star_brightness.get()) {
            int minAlpha = (alpha - 170) * 2 / 3;
            if (distance > 40.0) {
                alpha -= 2 * (int)Math.round(distance);
            }
            if (alpha < minAlpha) {
                alpha = minAlpha;
            }
        }
        distance = 1.0 / Math.sqrt(distance);
        double starX = (x *= distance) * 100.0;
        double starY = (y *= distance) * 100.0;
        double starZ = (z *= distance) * 100.0;
        double sphericalTheta = Math.atan2(x, z);
        double sinTheta = Math.sin(sphericalTheta);
        double cosTheta = Math.cos(sphericalTheta);
        double xzLength = Math.sqrt(x * x + z * z);
        double sphericalPhi = Math.atan2(xzLength, y);
        double sinPhi = Math.sin(sphericalPhi);
        double cosPhi = Math.cos(sphericalPhi);
        double random = randomsource.m_188500_() * Math.PI * 2.0;
        double sinRandom = Math.sin(random);
        double cosRandom = Math.cos(random);
        if (starColor.length < 3) {
            starColor = new int[]{255, 255, 255};
        }
        for (int j = 0; j < 4; ++j) {
            double aLocation = (double)((j & 2) - 1) * Mth.m_14008_((double)(starSize * 20.0 * distance), (double)minStarSize, (double)maxStarSize);
            double bLocation = (double)((j + 1 & 2) - 1) * Mth.m_14008_((double)(starSize * 20.0 * distance), (double)minStarSize, (double)maxStarSize);
            double height = heightDeformation * (aLocation * cosRandom - bLocation * sinRandom);
            double width = widthDeformation * (bLocation * cosRandom + aLocation * sinRandom);
            double heightProjectionY = height * sinPhi;
            double heightProjectionXZ = -height * cosPhi;
            double projectedX = heightProjectionXZ * sinTheta - width * cosTheta;
            double projectedZ = width * sinTheta + heightProjectionXZ * cosTheta;
            builder.m_5483_(starX + projectedX, starY + heightProjectionY, starZ + projectedZ).m_6122_(starColor[0], starColor[1], starColor[2], alpha).m_5752_();
        }
    }

    public static int[] randomStarColor(long seed, int contrast) {
        RandomSource randomsource = RandomSource.m_216335_((long)seed);
        int[] starClassM = new int[]{255, 255 - contrast * 4, 255 - contrast * 4};
        int[] starClassK = new int[]{255, 255 - contrast * 2, 255 - contrast * 4};
        int[] starClassG = new int[]{255, 255, 255 - contrast * 4};
        int[] starClassF = new int[]{255, 255, 255};
        int[] starClassA = new int[]{255 - contrast * 2, 255 - contrast * 2, 255};
        int[] starClassB = new int[]{255 - contrast * 4, 255 - contrast * 4, 255};
        int[] starClassO = new int[]{255 - contrast * 6, 255 - contrast * 6, 255};
        int[][] starColors = new int[][]{starClassM, starClassK, starClassG, starClassF, starClassA, starClassB, starClassO};
        int[] starColor = starColors[randomsource.m_188503_(starColors.length)];
        return starColor;
    }

    public static void createStar(BufferBuilder builder, RandomSource randomsource, double x, double y, double z, double distance, long seed) {
        Star.createStar(builder, randomsource, x, y, z, distance, 1.0, 1.0, seed);
    }

    public static void createVanillaStar(BufferBuilder builder, RandomSource randomsource, double x, double y, double z, double starSize, double distance, long seed) {
        if (distance < 1.0 && distance > 0.01) {
            Star.createStar(builder, randomsource, x, y, z, distance, seed);
        }
    }

    public static enum SpectralType {
        O(207, 207, 255, 0.25f, 0.25f, 255, 255),
        B(223, 223, 255, 0.24000001f, 0.25f, 235, 255),
        A(239, 239, 255, 0.2f, 0.22f, 215, 235),
        F(255, 255, 255, 0.185f, 0.2f, 200, 215),
        G(255, 255, 223, 0.17f, 0.185f, 190, 200),
        K(255, 239, 223, 0.16000001f, 0.17f, 180, 190),
        M(255, 223, 223, 0.15f, 0.16000001f, 170, 180);

        private final int red;
        private final int green;
        private final int blue;
        private final float minSize;
        private final float maxSize;
        private final int minBrightness;
        private final int maxBrightness;

        private SpectralType(int red, int green, int blue, float minSize, float maxSize, int minBrightness, int maxBrightness) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.minBrightness = minBrightness;
            this.maxBrightness = maxBrightness;
        }

        public int red() {
            return this.red;
        }

        public int green() {
            return this.green;
        }

        public int blue() {
            return this.blue;
        }

        public float randomSize(long seed) {
            if (this.minSize == this.maxSize) {
                return this.maxSize;
            }
            Random random = new Random(seed);
            return random.nextFloat(this.minSize, this.maxSize);
        }

        public int randomBrightness(long seed) {
            if (this.minBrightness == this.maxBrightness) {
                return this.maxBrightness;
            }
            Random random = new Random(seed);
            return random.nextInt(this.minBrightness, this.maxBrightness);
        }

        public static SpectralType randomSpectralType(long seed) {
            Random random = new Random(seed);
            if (StellarViewConfig.equal_spectral_types.get()) {
                SpectralType[] spectralTypes = SpectralType.values();
                return spectralTypes[random.nextInt(0, spectralTypes.length)];
            }
            int value = random.nextInt(0, 100);
            if (value < 74) {
                return M;
            }
            if (value < 86) {
                return K;
            }
            if (value < 93) {
                return G;
            }
            if (value < 96) {
                return F;
            }
            if (value < 97) {
                return A;
            }
            if (value < 98) {
                return B;
            }
            return O;
        }
    }
}

