/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.povstalec.stellarview.api.celestials.Star;
import net.povstalec.stellarview.api.celestials.StarField;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;

public abstract class Galaxy
extends StarField {
    public static final ResourceLocation SPIRAL_GALAXY_TEXTURE = new ResourceLocation("stellarview", "textures/environment/galaxy/spiral_galaxy.png");
    public static final ResourceLocation LENTICULAR_GALAXY_TEXTURE = new ResourceLocation("stellarview", "textures/environment/galaxy/lenticular_galaxy.png");
    public static final ResourceLocation ELLIPTICAL_GALAXY_TEXTURE = new ResourceLocation("stellarview", "textures/environment/galaxy/elliptical_galaxy.png");
    public static final ResourceLocation IRREGULAR_GALAXY_TEXTURE = new ResourceLocation("stellarview", "textures/environment/galaxy/irregular_galaxy.png");

    protected Galaxy(ResourceLocation texture, float size, long seed, short numberOfStars) {
        super(texture, size, seed, numberOfStars);
    }

    public static class EllipticalGalaxy
    extends Galaxy {
        public EllipticalGalaxy(ResourceLocation texture, float size, long seed, short numberOfStars) {
            super(texture, size, seed, numberOfStars);
        }

        public EllipticalGalaxy(float size, long seed, short numberOfStars) {
            super(ELLIPTICAL_GALAXY_TEXTURE, size, seed, numberOfStars);
        }

        @Override
        protected BufferBuilder.RenderedBuffer getStarBuffer(BufferBuilder bufferBuilder, float xOffset, float yOffset, float zOffset, float xAxisRotation, float yAxisRotation, float zAxisRotation) {
            RandomSource randomsource = RandomSource.m_216335_((long)this.seed);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (int i = 0; i < this.numberOfStars; ++i) {
                double r = randomsource.m_188500_() * (double)this.size;
                double tetha = Math.PI * 2 * randomsource.m_188500_();
                double phi = Math.acos(2.0 * randomsource.m_188500_() - 1.0);
                double x = r * Math.sin(phi) * Math.cos(tetha) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f);
                double z = r * Math.sin(phi) * Math.sin(tetha) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f);
                double y = r * Math.cos(phi) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f);
                double alphaX = x;
                double alphaY = z * Math.sin(xAxisRotation) + y * Math.cos(xAxisRotation);
                double alphaZ = z * Math.cos(xAxisRotation) - y * Math.sin(xAxisRotation);
                double betaX = alphaX * Math.cos(zAxisRotation) - alphaY * Math.sin(zAxisRotation);
                double betaY = -alphaX * Math.sin(zAxisRotation) - alphaY * Math.cos(zAxisRotation);
                double betaZ = alphaZ;
                double gammaX = -betaX * Math.sin(yAxisRotation) - betaZ * Math.cos(yAxisRotation);
                double gammaY = betaY;
                double gammaZ = betaX * Math.cos(yAxisRotation) - betaZ * Math.sin(yAxisRotation);
                x = gammaX + (double)xOffset;
                y = gammaY + (double)yOffset;
                z = gammaZ + (double)zOffset;
                double distance = x * x + y * y + z * z;
                Star.createStar(bufferBuilder, randomsource, x, y, z, distance, randomsource.m_188505_());
            }
            return bufferBuilder.m_231175_();
        }
    }

    public static class LenticularGalaxy
    extends Galaxy {
        public LenticularGalaxy(ResourceLocation texture, float size, long seed, short numberOfStars) {
            super(texture, size, seed, numberOfStars);
        }

        public LenticularGalaxy(float size, long seed, short numberOfStars) {
            this(LENTICULAR_GALAXY_TEXTURE, size, seed, numberOfStars);
        }

        @Override
        protected BufferBuilder.RenderedBuffer getStarBuffer(BufferBuilder bufferBuilder, float xOffset, float yOffset, float zOffset, float xAxisRotation, float yAxisRotation, float zAxisRotation) {
            RandomSource randomsource = RandomSource.m_216335_((long)this.seed);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            double length = randomsource.m_188500_() + 1.5;
            for (int i = 0; i < this.numberOfStars; ++i) {
                double progress = (double)i / (double)this.numberOfStars;
                double phi = length * 2.0 * Math.PI * progress;
                double r = StellarCoordinates.elipticalR(10.0, 5.0, phi);
                double x = r * Math.cos(phi) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f);
                double z = r * Math.sin(phi) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f);
                double y = (randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f;
                double alphaX = x;
                double alphaY = z * Math.sin(xAxisRotation) + y * Math.cos(xAxisRotation);
                double alphaZ = z * Math.cos(xAxisRotation) - y * Math.sin(xAxisRotation);
                double betaX = alphaX * Math.cos(zAxisRotation) - alphaY * Math.sin(zAxisRotation);
                double betaY = -alphaX * Math.sin(zAxisRotation) - alphaY * Math.cos(zAxisRotation);
                double betaZ = alphaZ;
                double gammaX = -betaX * Math.sin(yAxisRotation) - betaZ * Math.cos(yAxisRotation);
                double gammaY = betaY;
                double gammaZ = betaX * Math.cos(yAxisRotation) - betaZ * Math.sin(yAxisRotation);
                x = gammaX + (double)xOffset;
                y = gammaY + (double)yOffset;
                z = gammaZ + (double)zOffset;
                double distance = x * x + y * y + z * z;
                Star.createStar(bufferBuilder, randomsource, x, y, z, distance, randomsource.m_188505_());
            }
            return bufferBuilder.m_231175_();
        }
    }

    public static class SpiralGalaxy
    extends Galaxy {
        private byte numberOfArms;

        public SpiralGalaxy(ResourceLocation texture, float size, long seed, byte numberOfArms, short numberOfStars) {
            super(texture, size, seed, numberOfStars);
            this.numberOfArms = numberOfArms;
        }

        public SpiralGalaxy(float size, long seed, byte numberOfArms, short numberOfStars) {
            this(SPIRAL_GALAXY_TEXTURE, size, seed, numberOfArms, numberOfStars);
        }

        @Override
        protected BufferBuilder.RenderedBuffer getStarBuffer(BufferBuilder bufferBuilder, float xOffset, float yOffset, float zOffset, float xAxisRotation, float yAxisRotation, float zAxisRotation) {
            RandomSource randomsource = RandomSource.m_216335_((long)this.seed);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (int j = 0; j < this.numberOfArms; ++j) {
                double rotation = Math.PI * (double)j / ((double)this.numberOfArms / 2.0);
                double length = randomsource.m_188500_() + 1.5;
                for (int i = 0; i < this.numberOfStars; ++i) {
                    double progress = (double)i / (double)this.numberOfStars;
                    double phi = length * Math.PI * progress - rotation;
                    double r = StellarCoordinates.spiralR(5.0, phi, rotation);
                    double x = r * Math.cos(phi) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f) / (progress * 1.5);
                    double z = r * Math.sin(phi) + (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f) / (progress * 1.5);
                    double y = (double)((randomsource.m_188501_() * 4.0f - 2.0f) * 1.0f) / (progress * 1.5);
                    double alphaX = x;
                    double alphaY = z * Math.sin(xAxisRotation) + y * Math.cos(xAxisRotation);
                    double alphaZ = z * Math.cos(xAxisRotation) - y * Math.sin(xAxisRotation);
                    double betaX = alphaX * Math.cos(zAxisRotation) - alphaY * Math.sin(zAxisRotation);
                    double betaY = -alphaX * Math.sin(zAxisRotation) - alphaY * Math.cos(zAxisRotation);
                    double betaZ = alphaZ;
                    double gammaX = -betaX * Math.sin(yAxisRotation) - betaZ * Math.cos(yAxisRotation);
                    double gammaY = betaY;
                    double gammaZ = betaX * Math.cos(yAxisRotation) - betaZ * Math.sin(yAxisRotation);
                    x = gammaX + (double)xOffset;
                    y = gammaY + (double)yOffset;
                    z = gammaZ + (double)zOffset;
                    double distance = x * x + y * y + z * z;
                    Star.createStar(bufferBuilder, randomsource, x, y, z, distance, randomsource.m_188505_());
                }
            }
            return bufferBuilder.m_231175_();
        }
    }
}

