/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.celestials;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.api.celestials.orbiting.OrbitingCelestialObject;
import net.povstalec.stellarview.client.render.level.misc.StellarCoordinates;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class CelestialObject {
    public static final float G = 6.673E-11f;
    public static final int TICKS_PER_DAY = 24000;
    public static final float[] FULL_UV = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    public static final float DEFAULT_DISTANCE = 100.0f;
    protected ResourceLocation texture;
    protected ResourceLocation haloTexture;
    protected float haloSize;
    protected boolean hasHalo = false;
    protected boolean flipUV = false;
    protected boolean blends = false;
    protected boolean blendsDuringDay = false;
    protected boolean visibleDuringDay = false;
    protected float rotation = 0.0f;
    protected Vector3f axisRotation = new Vector3f(0.0f, 0.0f, 0.0f);

    public CelestialObject(ResourceLocation texture) {
        this.texture = texture;
    }

    public CelestialObject halo(ResourceLocation haloTexture, float haloSize) {
        this.haloTexture = haloTexture;
        this.haloSize = haloSize;
        this.hasHalo = true;
        return this;
    }

    public CelestialObject flipUV() {
        this.flipUV = true;
        return this;
    }

    public CelestialObject blends() {
        this.blends = true;
        return this;
    }

    public CelestialObject blendsDuringDay() {
        this.blendsDuringDay = true;
        return this;
    }

    public CelestialObject visibleDuringDay() {
        this.visibleDuringDay = true;
        return this;
    }

    protected ResourceLocation getTexture(ClientLevel level, Camera camera, float partialTicks) {
        return this.texture;
    }

    protected float[] getUV(OrbitingCelestialObject viewCenter, Vector3f vievCenterCoords, ClientLevel level, Camera camera, float partialTicks, PoseStack stack, BufferBuilder bufferbuilder, Vector3f skyAxisRotation, Vector3f coords) {
        return FULL_UV;
    }

    protected boolean shouldRender(ClientLevel level, Camera camera) {
        return true;
    }

    protected boolean shouldBlend(ClientLevel level, Camera camera) {
        return this.blends;
    }

    protected boolean isVisibleDuringDay(ClientLevel level, Camera camera) {
        return this.visibleDuringDay;
    }

    protected boolean shouldBlendDuringDay(ClientLevel level, Camera camera) {
        return this.blendsDuringDay;
    }

    protected float getBrightness(ClientLevel level, Camera camera, float partialTicks) {
        if (this.isVisibleDuringDay(level, camera)) {
            if (this.shouldBlendDuringDay(level, camera)) {
                float brightness = level.m_104811_(partialTicks) * 2.0f;
                brightness = brightness < 0.25f ? 0.25f : brightness;
                return brightness * (1.0f - level.m_46722_(partialTicks));
            }
            return 1.0f - level.m_46722_(partialTicks);
        }
        float brightness = level.m_104811_(partialTicks);
        float f = brightness = StellarViewConfig.day_stars.get() && brightness < 0.5f ? 0.5f : brightness;
        if (StellarViewConfig.bright_stars.get()) {
            brightness *= 1.0f + (float)(15 - level.m_5518_().m_75831_(camera.m_90592_().m_20097_().m_7494_(), 15)) / 15.0f;
        }
        return brightness * (1.0f - level.m_46722_(partialTicks));
    }

    protected abstract float getTetha(ClientLevel var1, float var2);

    protected abstract float getPhi(ClientLevel var1, float var2);

    protected abstract float getSize(ClientLevel var1, float var2);

    protected float getRotation(ClientLevel level, float partialTicks) {
        return this.rotation;
    }

    protected float[] getColor(ClientLevel level, float partialTicks) {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    private void renderObject(BufferBuilder bufferbuilder, Matrix4f lastMatrix, ResourceLocation texture, float[] uv, float size, float rotation, float theta, float phi, float brightness, float[] color) {
        if (uv == null || uv.length < 4) {
            uv = FULL_UV;
        }
        float[] corner00 = StellarCoordinates.placeOnSphere(-size, -size, 100.0f, theta, phi, rotation);
        float[] corner10 = StellarCoordinates.placeOnSphere(size, -size, 100.0f, theta, phi, rotation);
        float[] corner11 = StellarCoordinates.placeOnSphere(size, size, 100.0f, theta, phi, rotation);
        float[] corner01 = StellarCoordinates.placeOnSphere(-size, size, 100.0f, theta, phi, rotation);
        if (brightness > 0.0f) {
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)brightness);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            if (this.flipUV) {
                bufferbuilder.m_252986_(lastMatrix, corner00[0], corner00[1], corner00[2]).m_7421_(uv[0], uv[1]).m_5752_();
                bufferbuilder.m_252986_(lastMatrix, corner10[0], corner10[1], corner10[2]).m_7421_(uv[2], uv[1]).m_5752_();
                bufferbuilder.m_252986_(lastMatrix, corner11[0], corner11[1], corner11[2]).m_7421_(uv[2], uv[3]).m_5752_();
                bufferbuilder.m_252986_(lastMatrix, corner01[0], corner01[1], corner01[2]).m_7421_(uv[0], uv[3]).m_5752_();
            } else {
                bufferbuilder.m_252986_(lastMatrix, corner00[0], corner00[1], corner00[2]).m_7421_(uv[2], uv[1]).m_5752_();
                bufferbuilder.m_252986_(lastMatrix, corner10[0], corner10[1], corner10[2]).m_7421_(uv[0], uv[1]).m_5752_();
                bufferbuilder.m_252986_(lastMatrix, corner11[0], corner11[1], corner11[2]).m_7421_(uv[0], uv[3]).m_5752_();
                bufferbuilder.m_252986_(lastMatrix, corner01[0], corner01[1], corner01[2]).m_7421_(uv[2], uv[3]).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        }
    }

    protected void renderHalo(BufferBuilder bufferbuilder, Matrix4f lastMatrix, float[] uv, float rotation, float theta, float phi, float brightness, float[] color) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.renderObject(bufferbuilder, lastMatrix, this.haloTexture, uv, this.haloSize, rotation, theta, phi, brightness, color);
        RenderSystem.defaultBlendFunc();
    }

    protected Vector3f findRelative(Vector3f vievCenterCoords, Vector3f coords) {
        return coords;
    }

    public void render(OrbitingCelestialObject viewCenter, Vector3f vievCenterCoords, ClientLevel level, Camera camera, float partialTicks, PoseStack stack, BufferBuilder bufferbuilder, Vector3f skyAxisRotation, Vector3f coords) {
        if (!this.shouldRender(level, camera) || this == viewCenter) {
            return;
        }
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(skyAxisRotation.y));
        stack.m_252781_(Axis.f_252403_.m_252977_(skyAxisRotation.z));
        stack.m_252781_(Axis.f_252529_.m_252977_(skyAxisRotation.x));
        stack.m_252781_(Axis.f_252436_.m_252977_(this.axisRotation.y));
        stack.m_252781_(Axis.f_252403_.m_252977_(this.axisRotation.z));
        stack.m_252781_(Axis.f_252529_.m_252977_(this.axisRotation.x));
        float brightness = this.getBrightness(level, camera, partialTicks);
        if (this.shouldBlend(level, camera)) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        Matrix4f lastMatrix = stack.m_85850_().m_252922_();
        float[] uv = this.getUV(viewCenter, vievCenterCoords, level, camera, partialTicks, stack, bufferbuilder, skyAxisRotation, coords);
        float rotation = this.getRotation(level, partialTicks);
        Vector3f relative = this.findRelative(vievCenterCoords, coords);
        Vector3f sphericalCoords = StellarCoordinates.cartesianToSpherical(relative);
        float theta = sphericalCoords.y;
        float phi = sphericalCoords.z;
        float[] shaderColor = this.getColor(level, partialTicks);
        if (shaderColor.length < 3) {
            shaderColor = new float[]{1.0f, 1.0f, 1.0f};
        }
        if (this.hasHalo) {
            this.renderHalo(bufferbuilder, lastMatrix, uv, rotation, theta, phi, brightness, shaderColor);
        }
        this.renderObject(bufferbuilder, lastMatrix, this.getTexture(level, camera, partialTicks), uv, this.getSize(level, partialTicks), rotation, theta, phi, brightness, shaderColor);
        RenderSystem.defaultBlendFunc();
        stack.m_85849_();
    }
}

