/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.povstalec.stellarview.client.render.level.StellarViewSky;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StellarViewSpecialEffects
extends DimensionSpecialEffects {
    public StellarViewSky skyRenderer;

    public StellarViewSpecialEffects(StellarViewSky skyRenderer, float cloudLevel, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(cloudLevel, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
        this.skyRenderer = skyRenderer;
    }

    public Vec3 m_5927_(Vec3 biomeFogColor, float daylight) {
        return biomeFogColor.m_82542_((double)(daylight * 0.94f + 0.06f), (double)(daylight * 0.94f + 0.06f), (double)(daylight * 0.91f + 0.09f));
    }

    public boolean m_5781_(int x, int y) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        this.skyRenderer.renderSky(level, partialTick, poseStack, camera, projectionMatrix, setupFog);
        return true;
    }

    public static float getSkyDarken(ClientLevel level, float partialTicks) {
        float timeOfDay = level.m_46942_(partialTicks);
        float darken = 1.0f - (Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        darken = Mth.m_14036_((float)darken, (float)0.0f, (float)1.0f);
        darken = 1.0f - darken;
        darken *= 1.0f - level.m_46722_(partialTicks) * 5.0f / 16.0f;
        float darkMultiplier = 0.8f;
        return (darken *= 1.0f - level.m_46661_(partialTicks) * 5.0f / 16.0f) * darkMultiplier + 0.2f;
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        float darkMultiplier = StellarViewSpecialEffects.getSkyDarken(level, 1.0f);
        boolean darkerWorld = true;
        if (darkerWorld) {
            float trueSkyDarken = level.m_104819_() > 0 ? 1.0f : darkMultiplier * 0.95f + 0.05f;
            Vector3f skyVector = new Vector3f(trueSkyDarken, trueSkyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f lightColor = new Vector3f();
            float naturalLight = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)pixelY) * trueSkyDarken;
            float artificialLight = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)pixelX) * skyLight;
            float f10 = artificialLight * ((artificialLight * 0.6f + 0.4f) * 0.6f + 0.4f);
            float f11 = artificialLight * (artificialLight * artificialLight * 0.6f + 0.4f);
            lightColor.set(artificialLight, f10, f11);
            if (level.m_104583_().m_108884_()) {
                lightColor.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                StellarViewSpecialEffects.clampColor(lightColor);
            } else {
                Minecraft minecraft = Minecraft.m_91087_();
                Vector3f vector3f2 = new Vector3f((Vector3fc)skyVector).mul(naturalLight);
                lightColor.add((Vector3fc)vector3f2);
                lightColor.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (minecraft.f_91063_.m_109131_(partialTicks) > 0.0f) {
                    float f12 = minecraft.f_91063_.m_109131_(partialTicks);
                    Vector3f vector3f3 = new Vector3f((Vector3fc)lightColor).mul(0.7f, 0.6f, 0.6f);
                    lightColor.lerp((Vector3fc)vector3f3, f12);
                }
            }
            colors.set((Vector3fc)lightColor);
        }
    }

    public static void clampColor(Vector3f color) {
        color.set(Mth.m_14036_((float)color.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.z, (float)0.0f, (float)1.0f));
    }
}

