/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.clusters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import zed.d0c.floormats.Config;
import zed.d0c.floormats.blocks.AbstractFloorMatBlock;
import zed.d0c.floormats.blocks.floormats.Inlayed_Wood_FloorMat_Block;
import zed.d0c.floormats.clusters.Clusters;

public class ClustersNode
implements INBTSerializable<CompoundTag> {
    private final Block cnBlock;
    private final HashSet<UUID> cnUUID_Set = new HashSet();
    private final HashMap<BlockPos, Boolean> cnNodeMap = new HashMap();
    private final Set<Inlayed_Wood_FloorMat_Block.BlockPosSide> cnEnergyMap = new HashSet<Inlayed_Wood_FloorMat_Block.BlockPosSide>();
    private UUID cnID;
    UUID cnLink;
    private UUID cnLinkBack;
    private int cnBitFlags;
    private int cnLighting;
    static final HashMap<UUID, ClustersNode> idRegistry = new HashMap();
    private static final String BLOCK_TYPE_KEY = "cnBlockName";
    private static final String NODE_MAP_KEY = "cnNodeMap";
    private static final String ENERGY_MAP_KEY = "cnEnergyMap";
    private static final String LIST_UUID_KEY = "cnListUUID";
    private static final String ID_KEY = "cnID";
    private static final String LINK_KEY = "cnLink";
    private static final String LINK_BACK_KEY = "cnLinkBack";
    private static final String BIT_FLAGS_KEY = "cnBitFlags";
    private static final String LIGHTING_KEY = "cnLighting";
    protected static final Random random = new Random();
    private static final int BF_MUTED = 1;
    private static final int BF_INVERTED = 2;

    ClustersNode(Block blockType, HashSet<UUID> uuidSet) {
        this.cnBlock = blockType;
        this.cnUUID_Set.addAll(uuidSet);
    }

    ClustersNode(Block block, BlockPos pos) {
        BlockPos iPos = pos.m_7949_();
        this.cnBlock = block;
        this.cnNodeMap.put(iPos, false);
    }

    public ClustersNode(CompoundTag entry) {
        this.cnBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.m_128461_(BLOCK_TYPE_KEY)));
        this.deserializeNBT(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            nbt.m_128359_(BLOCK_TYPE_KEY, Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.cnBlock)).toString());
            if (this.cnID != null) {
                nbt.m_128362_(ID_KEY, this.cnID);
            }
            if (this.cnLink != null) {
                nbt.m_128362_(LINK_KEY, this.cnLink);
                nbt.m_128362_(LINK_BACK_KEY, this.cnLinkBack);
            }
            if (!this.cnUUID_Set.isEmpty()) {
                ListTag uuidLNBT = new ListTag();
                for (UUID u : this.cnUUID_Set) {
                    CompoundTag cNBT = new CompoundTag();
                    cNBT.m_128362_("", u);
                    uuidLNBT.add((Object)cNBT);
                }
                nbt.m_128365_(LIST_UUID_KEY, (Tag)uuidLNBT);
            }
            CompoundTag nodeMapNBT = new CompoundTag();
            for (BlockPos key : this.cnNodeMap.keySet()) {
                nodeMapNBT.m_128379_(Long.toString(key.m_121878_()), this.cnNodeMap.get(key).booleanValue());
            }
            nbt.m_128365_(NODE_MAP_KEY, (Tag)nodeMapNBT);
            ListTag energyMapNBT = new ListTag();
            this.cnEnergyMap.stream().map(Inlayed_Wood_FloorMat_Block.BlockPosSide::serializeNBT).forEach(arg_0 -> energyMapNBT.add(arg_0));
            nbt.m_128365_(ENERGY_MAP_KEY, (Tag)energyMapNBT);
            if (this.cnBitFlags != 0) {
                nbt.m_128405_(BIT_FLAGS_KEY, this.cnBitFlags);
            }
            if (this.cnLighting != 0) {
                nbt.m_128405_(LIGHTING_KEY, this.cnLighting);
            }
        }
        return nbt;
    }

    public void deserializeNBT(@Nonnull CompoundTag entry) {
        if (entry.m_128403_(ID_KEY)) {
            this.cnID = entry.m_128342_(ID_KEY);
            idRegistry.put(this.cnID, this);
        }
        if (entry.m_128403_(LINK_KEY)) {
            this.cnLink = entry.m_128342_(LINK_KEY);
            this.cnLinkBack = entry.m_128342_(LINK_BACK_KEY);
        }
        ListTag uuidLNBT = entry.m_128437_(LIST_UUID_KEY, 10);
        for (int index = 0; index < uuidLNBT.size(); ++index) {
            this.cnUUID_Set.add(uuidLNBT.m_128728_(index).m_128342_(""));
        }
        CompoundTag nodeMapNBT = entry.m_128469_(NODE_MAP_KEY);
        for (String key : nodeMapNBT.m_128431_()) {
            this.cnNodeMap.put(BlockPos.m_122022_((long)Long.parseLong(key)), nodeMapNBT.m_128471_(key));
        }
        entry.m_128437_(ENERGY_MAP_KEY, 10).forEach(tag -> this.cnEnergyMap.add(new Inlayed_Wood_FloorMat_Block.BlockPosSide((CompoundTag)tag)));
        this.cnBitFlags = entry.m_128451_(BIT_FLAGS_KEY);
        this.cnLighting = entry.m_128451_(LIGHTING_KEY);
    }

    public Block getNodeBlockType() {
        return this.cnBlock;
    }

    private UUID getID() {
        if (this.cnID != null) {
            return this.cnID;
        }
        this.cnID = UUID.randomUUID();
        idRegistry.put(this.cnID, this);
        return this.cnID;
    }

    public boolean isEmpty() {
        return this.cnNodeMap.isEmpty();
    }

    boolean contains(Block block, BlockPos pos) {
        return block == this.cnBlock && this.cnNodeMap.containsKey(pos);
    }

    public void adjustLighting(ServerLevel serverLevel) {
        this.setLighting((Level)serverLevel, this.cnLighting - 1 & 0xF);
    }

    public void updatePowerConnections(ServerLevel serverLevel, BlockPos pos, BlockState state) {
        this.cnEnergyMap.removeIf(blockPosSide -> blockPosSide.blockPos().equals((Object)pos));
        Stream.concat(Stream.of(Direction.DOWN), Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> (Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).filter(direction -> !serverLevel.m_8055_(pos.m_121945_(direction)).m_60734_().equals(this.cnBlock))).filter(direction -> {
            BlockEntity blockEntity = serverLevel.m_7702_(pos.m_121945_(direction));
            return blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).isPresent();
        }).forEach(direction -> this.cnEnergyMap.add(new Inlayed_Wood_FloorMat_Block.BlockPosSide(pos.m_121945_(direction), direction.m_122424_())));
    }

    public int moveEnergy(BlockEntity intermediateBlockEntity, EnergyIOInterface energyMover, int maxToMove, boolean simulate) {
        int numberOfEntries;
        Level level = intermediateBlockEntity.m_58904_();
        if (level == null) {
            return 0;
        }
        BlockPos intermediateBlockPos = intermediateBlockEntity.m_58899_();
        ArrayList<BlockPosSideEnergy> canMove = new ArrayList<BlockPosSideEnergy>();
        int totalCanMove = 0;
        LoopParser loop = new LoopParser(this);
        do {
            for (Inlayed_Wood_FloorMat_Block.BlockPosSide energyMapEntry : loop.get().cnEnergyMap) {
                IEnergyStorage iEnergyStorage;
                int energyMovedSimulated;
                LazyOptional iEnergyStorageLazyOptional;
                BlockEntity targetBlockEntity;
                Direction side;
                BlockPos energyTargetPos = energyMapEntry.blockPos();
                if (energyTargetPos.m_121945_(side = energyMapEntry.side()) == intermediateBlockPos || (targetBlockEntity = level.m_7702_(energyTargetPos)) == null || (iEnergyStorageLazyOptional = targetBlockEntity.getCapability(ForgeCapabilities.ENERGY, side)).resolve().isEmpty() || (energyMovedSimulated = energyMover.move(iEnergyStorage = (IEnergyStorage)iEnergyStorageLazyOptional.resolve().get(), maxToMove, true)) <= 0) continue;
                if (simulate && (totalCanMove += energyMovedSimulated) >= maxToMove) {
                    return maxToMove;
                }
                canMove.add(new BlockPosSideEnergy(energyMapEntry, energyMovedSimulated));
            }
        } while (Config.allowWirelessTransfer && loop.next());
        if (simulate) {
            return totalCanMove;
        }
        int finalNumberOfEntries = numberOfEntries = canMove.size();
        TreeSet<Integer> sortedEntryIndexes = new TreeSet<Integer>(Comparator.comparingInt(index -> ((BlockPosSideEnergy)canMove.get((int)index.intValue())).energy * finalNumberOfEntries + index));
        IntStream.range(0, canMove.size()).forEach(sortedEntryIndexes::add);
        int amountMoved = 0;
        for (Integer index2 : sortedEntryIndexes) {
            LazyOptional iEnergyStorageLazyOptional;
            int amountForTarget = (int)Math.ceil((double)(maxToMove - amountMoved) / (double)numberOfEntries);
            --numberOfEntries;
            Inlayed_Wood_FloorMat_Block.BlockPosSide blockPosSide = ((BlockPosSideEnergy)canMove.get(index2)).blockPosSide();
            BlockEntity blockEntity = level.m_7702_(blockPosSide.blockPos());
            if (blockEntity == null || (iEnergyStorageLazyOptional = blockEntity.getCapability(ForgeCapabilities.ENERGY, blockPosSide.side())).resolve().isEmpty()) continue;
            IEnergyStorage iEnergyStorage = (IEnergyStorage)iEnergyStorageLazyOptional.resolve().get();
            int energyActuallySent = energyMover.move(iEnergyStorage, amountForTarget, false);
            amountMoved += energyActuallySent;
        }
        return amountMoved;
    }

    private void broadcastToNeighbors(Level worldIn, HashSet<BlockPos> posToBroadcast) {
        BlockPos anyPos = (BlockPos)posToBroadcast.toArray()[0];
        if (ForgeEventFactory.onNeighborNotify((Level)worldIn, (BlockPos)anyPos, (BlockState)worldIn.m_8055_(anyPos), EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        for (BlockPos pos : posToBroadcast) {
            BlockState state = worldIn.m_8055_(pos);
            Block block = state.m_60734_();
            worldIn.m_46586_(pos.m_122024_(), block, pos);
            worldIn.m_46586_(pos.m_122029_(), block, pos);
            worldIn.m_46586_(pos.m_7495_(), block, pos);
            worldIn.m_46586_(pos.m_7494_(), block, pos);
            worldIn.m_46586_(pos.m_122012_(), block, pos);
            worldIn.m_46586_(pos.m_122019_(), block, pos);
            BlockPos downPos = pos.m_7495_();
            BlockState downState = worldIn.m_8055_(downPos);
            Block downBlock = downState.m_60734_();
            worldIn.m_46586_(downPos.m_122024_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_122029_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_7495_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_122012_(), downBlock, downPos);
            worldIn.m_46586_(downPos.m_122019_(), downBlock, downPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean powerNode(Level worldIn, @Nullable BlockPos blockPos, @Nullable ArrayList<Player> playerList) {
        if (blockPos == null || !this.cnNodeMap.get(blockPos).booleanValue()) {
            if (playerList != null && !this.cnUUID_Set.isEmpty() && playerList.stream().noneMatch(player -> this.isInverted() ^ this.cnUUID_Set.contains(player.m_20148_()))) {
                return false;
            }
            HashSet<BlockPos> posToUpdate = new HashSet<BlockPos>(this.cnNodeMap.keySet());
            boolean alreadyPowered = this.isPowered();
            if (blockPos != null && !alreadyPowered) {
                this.playClickOnSound(worldIn, blockPos);
            }
            ClustersNode clustersNode = this;
            synchronized (clustersNode) {
                if (blockPos != null) {
                    this.cnNodeMap.put(blockPos, true);
                }
                if (!alreadyPowered) {
                    LoopParser loop = new LoopParser(this);
                    do {
                        HashSet<BlockPos> posToPower = new HashSet<BlockPos>(loop.get().cnNodeMap.keySet());
                        posToUpdate.addAll(posToPower);
                        for (BlockPos activatePos : posToPower) {
                            BlockState state = worldIn.m_8055_(activatePos);
                            if (state.m_60734_() instanceof AbstractFloorMatBlock) {
                                worldIn.m_46597_(activatePos, (BlockState)state.m_61124_((Property)AbstractFloorMatBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                                continue;
                            }
                            loop.get().cnNodeMap.remove(activatePos);
                        }
                    } while (loop.next());
                }
            }
            this.broadcastToNeighbors(worldIn, posToUpdate);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void depowerNode(Level worldIn) {
        HashSet<BlockPos> posToUpdate = new HashSet<BlockPos>();
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            LoopParser loop = new LoopParser(this);
            do {
                HashSet<BlockPos> posToDepower = new HashSet<BlockPos>(loop.get().cnNodeMap.keySet());
                posToUpdate.addAll(posToDepower);
                for (BlockPos deactivatePos : posToDepower) {
                    BlockState oldState = worldIn.m_8055_(deactivatePos);
                    if (oldState.m_60734_() instanceof AbstractFloorMatBlock) {
                        worldIn.m_46597_(deactivatePos, (BlockState)oldState.m_61124_((Property)AbstractFloorMatBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    loop.get().cnNodeMap.remove(deactivatePos);
                }
            } while (loop.next());
        }
        this.broadcastToNeighbors(worldIn, posToUpdate);
    }

    boolean isPowered() {
        LoopParser loop = new LoopParser(this);
        do {
            if (!loop.get().cnNodeMap.containsValue(true)) continue;
            return true;
        } while (loop.next());
        return false;
    }

    boolean depowerBlock(Level worldIn, BlockPos pos) {
        this.cnNodeMap.replace(pos, false);
        if (this.isPowered()) {
            return false;
        }
        this.depowerNode(worldIn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void absorbOtherNode(Level level, ClustersNode otherNode) {
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            this.equalizeLighting(level, otherNode);
            this.cnUUID_Set.addAll(otherNode.cnUUID_Set);
            this.cnNodeMap.putAll(otherNode.cnNodeMap);
            if (!(this.isLinked(otherNode) || this.cnLink == null && otherNode.cnLink == null)) {
                this.linkTo(otherNode);
            }
            if (this.cnLink != null) {
                ClustersNode.idRegistry.get((Object)otherNode.cnLinkBack).cnLink = otherNode.cnLink;
                ClustersNode.idRegistry.get((Object)otherNode.cnLink).cnLinkBack = otherNode.cnLinkBack;
                if (this.cnLink == this.cnID) {
                    this.cnID = null;
                    this.cnLink = null;
                    this.cnLinkBack = null;
                }
            }
            this.cnEnergyMap.addAll(otherNode.cnEnergyMap);
        }
    }

    private void equalizeLighting(Level level, ClustersNode otherNode) {
        if (this.cnLighting == otherNode.cnLighting) {
            return;
        }
        if (this.cnLighting > otherNode.cnLighting) {
            otherNode.setLighting(level, this.cnLighting);
        } else {
            this.setLighting(level, otherNode.cnLighting);
        }
    }

    private void setLighting(Level level, int newLevel) {
        this.cnLighting = newLevel;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (BlockPos blockPos : this.cnNodeMap.keySet()) {
            BlockState oldState = serverLevel.m_8055_(blockPos);
            if (!oldState.m_61138_((Property)BlockStateProperties.f_61422_)) continue;
            BlockState newState = (BlockState)oldState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(newLevel));
            serverLevel.m_7731_(blockPos, newState, 2);
            serverLevel.m_6550_(blockPos, oldState, newState);
        }
    }

    boolean isLinked(ClustersNode otherNode) {
        if (this.cnLink == null || otherNode.cnLink == null) {
            return false;
        }
        UUID otherID = otherNode.getID();
        LoopParser loop = new LoopParser(this);
        do {
            if (!loop.get().cnLink.equals(otherID)) continue;
            return true;
        } while (loop.next());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePos(Level worldIn, BlockPos pos) {
        Boolean wasPowered;
        ClustersNode clustersNode = this;
        synchronized (clustersNode) {
            wasPowered = this.cnNodeMap.get(pos);
            this.cnNodeMap.remove(pos);
            this.cnEnergyMap.removeIf(blockPosSide -> blockPosSide.blockPos().m_121945_(blockPosSide.side()).equals((Object)pos));
        }
        if (wasPowered.booleanValue() && !this.isPowered()) {
            this.depowerNode(worldIn);
        }
    }

    public Clusters.ClustersSet reformNode(ServerLevel serverLevel) {
        Clusters.ClustersSet distinctNodes = new Clusters.ClustersSet();
        Block blockType = this.getNodeBlockType();
        while (!this.cnNodeMap.isEmpty()) {
            ClustersNode newNode = new ClustersNode(blockType, this.cnUUID_Set);
            HashSet<BlockPos> posToAdd = new HashSet<BlockPos>();
            BlockPos anyKey = (BlockPos)this.cnNodeMap.keySet().toArray()[0];
            posToAdd.add(anyKey.m_7949_());
            while (!posToAdd.isEmpty()) {
                BlockPos nextPos = (BlockPos)posToAdd.toArray()[0];
                posToAdd.remove(nextPos);
                newNode.cnNodeMap.put(nextPos.m_7949_(), this.cnNodeMap.remove(nextPos));
                BlockState state = serverLevel.m_8055_(nextPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos adjacentPos;
                    if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue() || !this.cnNodeMap.containsKey(adjacentPos = nextPos.m_121945_(direction))) continue;
                    posToAdd.add(adjacentPos.m_7949_());
                }
                newNode.updatePowerConnections(serverLevel, nextPos, state);
            }
            newNode.cnLighting = this.cnLighting;
            distinctNodes.add(newNode);
        }
        if (this.cnLink != null) {
            for (ClustersNode node : distinctNodes) {
                node.cnLinkBack = this.cnLinkBack;
                ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = node.getID();
                this.cnLinkBack = node.cnID;
            }
            ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = this.cnLink;
            ClustersNode.idRegistry.get((Object)this.cnLink).cnLinkBack = this.cnLinkBack;
        }
        return distinctNodes;
    }

    public void powerAsNeeded(Level worldIn) {
        if (this.isPowered()) {
            HashSet<BlockPos> poweredBPSet = new HashSet<BlockPos>();
            for (BlockPos pos : this.cnNodeMap.keySet()) {
                BlockState state = worldIn.m_8055_(pos);
                if (((Boolean)state.m_61143_((Property)AbstractFloorMatBlock.POWERED)).booleanValue()) continue;
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)AbstractFloorMatBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                poweredBPSet.add(pos);
            }
            if (!poweredBPSet.isEmpty()) {
                this.broadcastToNeighbors(worldIn, poweredBPSet);
            }
        }
    }

    public void addUniqueID(UUID uniqueID) {
        this.cnUUID_Set.add(uniqueID);
    }

    public boolean canAccess(UUID uniqueID) {
        return this.cnUUID_Set.isEmpty() || this.cnUUID_Set.contains(uniqueID);
    }

    public int cmdResetNode(ServerLevel serverWorld) {
        HashSet<BlockPos> failedPosSet = new HashSet<BlockPos>();
        for (BlockPos posToCheck : this.cnNodeMap.keySet()) {
            if (serverWorld.m_8055_(posToCheck).m_60734_() == this.cnBlock) continue;
            failedPosSet.add(posToCheck);
        }
        for (BlockPos posToCull : failedPosSet) {
            this.cnNodeMap.remove(posToCull);
            this.cnEnergyMap.removeIf(blockPosSide -> blockPosSide.blockPos().m_121945_(blockPosSide.side()).equals((Object)posToCull));
        }
        return failedPosSet.size();
    }

    public void removeLink(Level worldIn, boolean wasPowered) {
        if (this.cnLink != null) {
            ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = this.cnLink;
            ClustersNode node = idRegistry.get(this.cnLink);
            node.cnLinkBack = this.cnLinkBack;
            node.verifyLink();
            this.wipeLink();
            if (wasPowered && !this.isPowered()) {
                this.depowerNode(worldIn);
            } else if (wasPowered && !node.isPowered()) {
                node.depowerNode(worldIn);
            }
        }
    }

    private void wipeLink() {
        this.cnID = null;
        this.cnLink = null;
        this.cnLinkBack = null;
    }

    private void verifyLink() {
        if (this.cnLink == this.cnID) {
            this.wipeLink();
        }
    }

    public void linkTo(ClustersNode linkNode) {
        if (linkNode.cnLink == null) {
            if (this.cnLink == null) {
                linkNode.cnLink = this.getID();
                this.cnLinkBack = linkNode.getID();
            } else {
                linkNode.cnLink = this.cnLink;
                ClustersNode.idRegistry.get((Object)this.cnLink).cnLinkBack = linkNode.getID();
            }
        } else if (this.cnLink == null) {
            this.cnLinkBack = linkNode.cnLinkBack;
            ClustersNode.idRegistry.get((Object)this.cnLinkBack).cnLink = this.getID();
        } else {
            ClustersNode.idRegistry.get((Object)linkNode.cnLinkBack).cnLink = this.cnLink;
            ClustersNode.idRegistry.get((Object)this.cnLink).cnLinkBack = linkNode.cnLinkBack;
        }
        this.cnLink = linkNode.cnID;
        linkNode.cnLinkBack = this.cnID;
    }

    public void createLinkEffect(Level worldIn) {
        for (BlockPos pos : this.cnNodeMap.keySet()) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            for (int i = 0; i < 8; ++i) {
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)x + random.nextDouble(), (double)y + random.nextDouble(), (double)z + random.nextDouble(), 1, 0.0, 0.4, 0.0, (double)0.15f);
            }
        }
    }

    public boolean hasDirectPowerMarked(BlockPos pos) {
        return this.cnNodeMap.get(pos);
    }

    boolean isInverted() {
        return (this.cnBitFlags & 2) != 0;
    }

    public void toggleInverted() {
        this.cnBitFlags ^= 2;
    }

    boolean isMuffled() {
        return (this.cnBitFlags & 1) != 0;
    }

    public void toggleMuffler() {
        this.cnBitFlags ^= 1;
    }

    public void clearPlayerList() {
        this.cnUUID_Set.clear();
    }

    public void playClickOnSound(Level worldIn, BlockPos pos) {
        if (this.isMuffled()) {
            return;
        }
        Block block = this.cnBlock;
        if (block instanceof AbstractFloorMatBlock) {
            AbstractFloorMatBlock abstractFloorMatBlock = (AbstractFloorMatBlock)block;
            worldIn.m_5594_(null, pos, abstractFloorMatBlock.getClickOnSound(), SoundSource.BLOCKS, 0.3f, abstractFloorMatBlock.getClickedFloat());
        }
    }

    public void playClickOffSound(Level worldIn, BlockPos pos) {
        if (this.isMuffled()) {
            return;
        }
        Block block = this.cnBlock;
        if (block instanceof AbstractFloorMatBlock) {
            AbstractFloorMatBlock abstractFloorMatBlock = (AbstractFloorMatBlock)block;
            worldIn.m_5594_(null, pos, abstractFloorMatBlock.getClickOffSound(), SoundSource.BLOCKS, 0.3f, abstractFloorMatBlock.getClickedFloat());
        }
    }

    private static class LoopParser {
        private final HashSet<ClustersNode> usedNodes = new HashSet();
        private ClustersNode cursor;

        LoopParser(ClustersNode start) {
            this.cursor = start;
        }

        ClustersNode get() {
            return this.cursor;
        }

        boolean next() {
            this.usedNodes.add(this.cursor);
            if (this.cursor.cnLink != null) {
                this.cursor = idRegistry.get(this.cursor.cnLink);
            }
            return !this.usedNodes.contains(this.cursor);
        }
    }

    @FunctionalInterface
    public static interface EnergyIOInterface {
        public int move(IEnergyStorage var1, int var2, boolean var3);
    }

    public record BlockPosSideEnergy(Inlayed_Wood_FloorMat_Block.BlockPosSide blockPosSide, int energy) {
    }
}

