/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.clusters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.energy.IEnergyStorage;
import zed.d0c.floormats.clusters.ClustersNode;
import zed.d0c.floormats.punchcards.PunchCards;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Clusters {
    private static final ClustersRegistry CLUSTERS_REGISTRY = new ClustersRegistry();

    public static ClustersRegistry getClustersRegistry() {
        return CLUSTERS_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(Level worldIn, ClustersNode newNode) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            CLUSTERS_REGISTRY.getClusterSet(worldIn).add(newNode);
        }
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(Level worldIn, ClustersNode exNode) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            CLUSTERS_REGISTRY.getClusterSet(worldIn).remove(exNode);
        }
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeSet(Level worldIn, ClustersSet newNodeSet) {
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            CLUSTERS_REGISTRY.getClusterSet(worldIn).addAll(newNodeSet);
        }
        PunchCards.setStaticDirty();
    }

    private ClustersNode getOrCreateNode(Level worldIn, BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        for (ClustersNode node : CLUSTERS_REGISTRY.getClusterSet(worldIn)) {
            if (!node.contains(block, pos)) continue;
            return node;
        }
        ClustersNode newNode = new ClustersNode(state.m_60734_(), pos);
        this.addNode(worldIn, newNode);
        return newNode;
    }

    public boolean hasNode(Level worldIn, BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        for (ClustersNode node : CLUSTERS_REGISTRY.getClusterSet(worldIn)) {
            if (!node.contains(block, pos)) continue;
            return true;
        }
        return false;
    }

    public Optional<ClustersNode> getNodeIfPresent(Level level, BlockState state, BlockPos pos) {
        Block block = state.m_60734_();
        for (ClustersNode node : CLUSTERS_REGISTRY.getClusterSet(level)) {
            if (!node.contains(block, pos)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public boolean applyDirectPower(Level worldIn, BlockPos iPos, @Nullable ArrayList<Player> playerList) {
        ClustersNode node = this.getOrCreateNode(worldIn, worldIn.m_8055_(iPos), iPos);
        boolean directPowerApplied = node.powerNode(worldIn, iPos, playerList);
        PunchCards.setStaticDirty();
        return directPowerApplied;
    }

    public boolean removeDirectPower(BlockState state, Level worldIn, BlockPos pos) {
        boolean blockDepowered = this.getOrCreateNode(worldIn, state, pos).depowerBlock(worldIn, pos);
        PunchCards.setStaticDirty();
        return blockDepowered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToClusters(Level level, BlockPos pos, BlockState state) {
        BlockPos iPos = pos.m_7949_();
        Block block = state.m_60734_();
        ClustersNode node = this.getOrCreateNode(level, state, iPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            ClustersNode adjacentNode;
            BlockPos neighborPos;
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue() || level.m_8055_(neighborPos = iPos.m_121945_(direction)).m_60734_() != block || node.equals(adjacentNode = this.getOrCreateNode(level, state, neighborPos))) continue;
            ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
            synchronized (clustersRegistry) {
                node.absorbOtherNode(level, adjacentNode);
                this.removeNode(level, adjacentNode);
            }
        }
        node.powerAsNeeded(level);
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromClusters(ServerLevel serverLevel, BlockPos iPos, BlockState state) {
        boolean wasPowered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        ClustersNode thisNode = this.getOrCreateNode((Level)serverLevel, state, iPos);
        int neighborCount = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue()) continue;
            ++neighborCount;
        }
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            switch (neighborCount) {
                case 0: {
                    thisNode.removeLink((Level)serverLevel, wasPowered);
                    this.removeNode((Level)serverLevel, thisNode);
                    break;
                }
                case 1: {
                    thisNode.removePos((Level)serverLevel, iPos);
                    if (!wasPowered || thisNode.isPowered()) break;
                    thisNode.depowerNode((Level)serverLevel);
                    break;
                }
                default: {
                    thisNode.removePos((Level)serverLevel, iPos);
                    ClustersSet setOfNodes = thisNode.reformNode(serverLevel);
                    this.removeNode((Level)serverLevel, thisNode);
                    this.addNodeSet((Level)serverLevel, setOfNodes);
                    if (!wasPowered) break;
                    for (ClustersNode nodeForPowerCheck : setOfNodes) {
                        if (nodeForPowerCheck.isPowered()) continue;
                        nodeForPowerCheck.depowerNode((Level)serverLevel);
                    }
                }
            }
        }
        PunchCards.setStaticDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterClusters(ServerLevel serverLevel, BlockPos iPos, BlockState stateIn) {
        ClustersNode node = this.getOrCreateNode((Level)serverLevel, stateIn, iPos);
        boolean wasPowered = node.isPowered();
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            ClustersSet setOfNodes = node.reformNode(serverLevel);
            this.removeNode((Level)serverLevel, node);
            this.addNodeSet((Level)serverLevel, setOfNodes);
            if (wasPowered) {
                for (ClustersNode nodeForPowerCheck : setOfNodes) {
                    if (nodeForPowerCheck.isPowered()) continue;
                    nodeForPowerCheck.depowerNode((Level)serverLevel);
                }
            }
        }
        PunchCards.setStaticDirty();
    }

    public void registerUniqueID(Level worldIn, BlockPos pos, BlockState state, UUID uniqueID) {
        this.getOrCreateNode(worldIn, state, pos).addUniqueID(uniqueID);
    }

    public boolean canAlter(Level worldIn, BlockPos pos, BlockState state, UUID uniqueID) {
        return this.getOrCreateNode(worldIn, state, pos).canAccess(uniqueID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cmdReset(ServerLevel serverWorld) {
        int correctionCount = 0;
        ClustersRegistry clustersRegistry = Clusters.getClustersRegistry();
        synchronized (clustersRegistry) {
            for (ResourceKey dim : CLUSTERS_REGISTRY.keySet()) {
                ClustersSet emptyNodes = new ClustersSet();
                for (ClustersNode node : (ClustersSet)CLUSTERS_REGISTRY.get(dim)) {
                    correctionCount += node.cmdResetNode(serverWorld);
                    if (!node.isEmpty()) continue;
                    emptyNodes.add(node);
                }
                ((ClustersSet)CLUSTERS_REGISTRY.get(dim)).removeAll(emptyNodes);
            }
        }
        PunchCards.setStaticDirty();
        return correctionCount;
    }

    public boolean linkClusters(Level worldIn, BlockPos iPos, BlockState state, BlockPos linkPos, BlockState linkState) {
        ClustersNode linkNode;
        ClustersNode node = this.getOrCreateNode(worldIn, state, iPos);
        if (node.equals(linkNode = this.getOrCreateNode(worldIn, linkState, linkPos))) {
            node.removeLink(worldIn, node.isPowered());
            PunchCards.setStaticDirty();
            return false;
        }
        boolean powered = node.isPowered();
        boolean linkPowered = linkNode.isPowered();
        if (powered && !linkPowered) {
            linkNode.powerNode(worldIn, null, null);
        } else if (linkPowered && !powered) {
            node.powerNode(worldIn, null, null);
        }
        node.linkTo(linkNode);
        PunchCards.setStaticDirty();
        return true;
    }

    public void linkEffects(Level worldIn, BlockPos iPos, BlockState stateIn) {
        this.getOrCreateNode(worldIn, stateIn, iPos).createLinkEffect(worldIn);
    }

    public boolean hasDirectPower(BlockState state, Level worldIn, BlockPos pos) {
        return this.getOrCreateNode(worldIn, state, pos).hasDirectPowerMarked(pos);
    }

    public void playOnSound(BlockGetter iWorldIn, BlockPos pos) {
        if (!(iWorldIn instanceof Level)) {
            return;
        }
        Level worldIn = (Level)iWorldIn;
        this.getOrCreateNode(worldIn, worldIn.m_8055_(pos), pos).playClickOnSound(worldIn, pos);
    }

    public void playOffSound(BlockGetter iWorldIn, BlockPos pos) {
        if (!(iWorldIn instanceof Level)) {
            return;
        }
        Level worldIn = (Level)iWorldIn;
        this.getOrCreateNode(worldIn, worldIn.m_8055_(pos), pos).playClickOffSound(worldIn, pos);
    }

    public void toggleMuffler(ServerLevel serverLevel, BlockPos pos) {
        this.getOrCreateNode((Level)serverLevel, serverLevel.m_8055_(pos), pos).toggleMuffler();
    }

    public void toggleInverted(Level worldIn, BlockPos pos) {
        this.getOrCreateNode(worldIn, worldIn.m_8055_(pos), pos).toggleInverted();
    }

    public void clearPlayerList(Level worldIn, BlockPos pos) {
        this.getOrCreateNode(worldIn, worldIn.m_8055_(pos), pos).clearPlayerList();
    }

    public void adjustLighting(ServerLevel serverLevel, BlockPos iPos) {
        this.getOrCreateNode((Level)serverLevel, serverLevel.m_8055_(iPos), iPos).adjustLighting(serverLevel);
    }

    public void updatePowerConnections(ServerLevel serverLevel, BlockPos pos, BlockState state) {
        this.getOrCreateNode((Level)serverLevel, state, pos).updatePowerConnections(serverLevel, pos, state);
    }

    public void addEnergy(ServerLevel serverLevel, BlockPos blockPos, int maxToAdd) {
        this.getNodeIfPresent((Level)serverLevel, serverLevel.m_8055_(blockPos), blockPos).ifPresent(clustersNode -> {
            BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
            if (blockEntity == null) {
                return;
            }
            clustersNode.moveEnergy(blockEntity, IEnergyStorage::receiveEnergy, maxToAdd, false);
        });
    }

    public int moveEnergy(BlockEntity blockEntity, ClustersNode.EnergyIOInterface energyMover, int maxToMove, boolean simulate) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return 0;
        }
        Optional<ClustersNode> optionalClustersNode = this.getNodeIfPresent(level, blockEntity.m_58900_(), blockEntity.m_58899_());
        return optionalClustersNode.map(clustersNode -> clustersNode.moveEnergy(blockEntity, energyMover, maxToMove, simulate)).orElse(0);
    }

    public static class ClustersRegistry
    extends HashMap<ResourceKey<Level>, ClustersSet> {
        private ClustersSet getClusterSet(ResourceKey<Level> key) {
            if (!this.containsKey(key)) {
                this.put(key, new ClustersSet());
            }
            return (ClustersSet)this.get(key);
        }

        private ClustersSet getClusterSet(Level worldIn) {
            ResourceKey key = worldIn.m_46472_();
            return this.getClusterSet((ResourceKey<Level>)key);
        }
    }

    public static class ClustersSet
    extends HashSet<ClustersNode> {
    }
}

