/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.blocks.floormats;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import zed.d0c.floormats.Config;
import zed.d0c.floormats.blocks.AbstractFloorMatBlock;
import zed.d0c.floormats.blocks.floormats.inlayed.InlayedBlockEntity;

public class Inlayed_Wood_FloorMat_Block
extends AbstractFloorMatBlock
implements EntityBlock {
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = blockState -> (Integer)blockState.m_61143_((Property)LEVEL);

    public Inlayed_Wood_FloorMat_Block(MapColor mapColor, BlockSetType blockSetType) {
        super(AbstractFloorMatBlock.Sensitivity.PLAYERS, BlockBehaviour.Properties.m_284310_().m_60953_(LIGHT_EMISSION).m_284180_(mapColor).m_60918_(SoundType.f_56736_).m_60978_(1.0f), blockSetType);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_, POWERED, LEVEL, WATERLOGGED});
    }

    @ParametersAreNonnullByDefault
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new InlayedBlockEntity(blockPos, blockState);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (state.m_60734_() != oldState.m_60734_()) {
                FloorMatClusters.updatePowerConnections(serverLevel, pos, state);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_ && placer != null) {
            FloorMatClusters.registerUniqueID(worldIn, pos, state, placer.m_20148_());
        }
    }

    @Override
    @ParametersAreNonnullByDefault
    protected boolean offHandAction(ItemStack offHandStack, ServerLevel serverLevel, BlockPos blockPos) {
        if (Config.illumination && Inlayed_Wood_FloorMat_Block.hasTag(offHandStack.m_41720_(), new ResourceLocation("floormats", "lighting"))) {
            FloorMatClusters.adjustLighting(serverLevel, blockPos);
            return true;
        }
        return super.offHandAction(offHandStack, serverLevel, blockPos);
    }

    @Override
    public MutableComponent getToolTipText() {
        return Component.m_237115_((String)(Config.illumination ? "tooltip.ctrl_shift.floor_mat.inlayed" : "tooltip.ctrl_shift.floor_mat.inlayed.disabled"));
    }

    @Override
    @ParametersAreNonnullByDefault
    @NotNull
    public AbstractFloorMatBlock.Connections getConnections(BlockGetter blockGetter, BlockPos blockpos) {
        AbstractFloorMatBlock.Connections connections = super.getConnections(blockGetter, blockpos);
        return new AbstractFloorMatBlock.Connections(connections.connectNorth() != false || Inlayed_Wood_FloorMat_Block.hasEnergy(blockGetter, blockpos.m_122012_(), Direction.SOUTH), connections.connectSouth() != false || Inlayed_Wood_FloorMat_Block.hasEnergy(blockGetter, blockpos.m_122019_(), Direction.NORTH), connections.connectWest() != false || Inlayed_Wood_FloorMat_Block.hasEnergy(blockGetter, blockpos.m_122024_(), Direction.EAST), connections.connectEast() != false || Inlayed_Wood_FloorMat_Block.hasEnergy(blockGetter, blockpos.m_122029_(), Direction.WEST), connections.powered());
    }

    private static boolean hasEnergy(BlockGetter blockGetter, BlockPos blockPos, Direction direction) {
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity == null) {
            return false;
        }
        return blockEntity.getCapability(ForgeCapabilities.ENERGY, direction).isPresent();
    }

    @Override
    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (!facing.m_122434_().m_122479_()) {
            if (facing == Direction.DOWN && levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                FloorMatClusters.updatePowerConnections(serverLevel, currentPos, stateIn);
            }
            return super.m_7417_(stateIn, facing, facingState, levelAccessor, currentPos, facingPos);
        }
        BlockState returnState = (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(Inlayed_Wood_FloorMat_Block.isConnected(levelAccessor, stateIn, facing, facingState, facingPos)));
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            FloorMatClusters.updatePowerConnections(serverLevel, currentPos, stateIn);
        }
        return returnState;
    }

    public static boolean isConnected(LevelAccessor levelAccessor, BlockState stateIn, Direction facing, BlockState facingState, BlockPos facingPos) {
        if (facingState.m_60734_() instanceof AbstractFloorMatBlock) {
            return (Boolean)stateIn.m_61143_((Property)PipeBlock.f_55154_.get(facing)) != false || (Boolean)facingState.m_61143_((Property)PipeBlock.f_55154_.get(facing.m_122424_())) != false;
        }
        return Inlayed_Wood_FloorMat_Block.hasEnergy((BlockGetter)levelAccessor, facingPos, facing.m_122424_());
    }

    @Override
    @ParametersAreNonnullByDefault
    public BlockState toggleConnection(ServerLevel serverLevel, BlockState blockState, BlockPos blockPos, Direction direction) {
        return blockState.m_60734_() instanceof AbstractFloorMatBlock ? super.toggleConnection(serverLevel, blockState, blockPos, direction) : blockState;
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean canToggleConnection(BlockState stateIn, ServerLevel serverLevel, Player player, BlockPos blockPos, Direction direction) {
        return super.canToggleConnection(stateIn, serverLevel, player, blockPos, direction) || Inlayed_Wood_FloorMat_Block.hasEnergy((BlockGetter)serverLevel, blockPos.m_121945_(direction), direction.m_122424_());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        creeper.m_32283_(-1);
        FloorMatClusters.addEnergy(serverLevel, pos, ((Creeper)entity).m_7090_() ? Config.chargedCreeperEnergy : Config.creeperEnergy);
    }

    public record BlockPosSide(BlockPos blockPos, Direction side) {
        private static final String POS_KEY = "bpsPos";
        private static final String SIDE_KEY = "bpsSide";

        public BlockPosSide(CompoundTag compoundTag) {
            this(BlockPos.m_122022_((long)compoundTag.m_128454_(POS_KEY)), Direction.m_122376_((int)compoundTag.m_128451_(SIDE_KEY)));
        }

        public CompoundTag serializeNBT() {
            CompoundTag recordNBT = new CompoundTag();
            recordNBT.m_128356_(POS_KEY, this.blockPos.m_121878_());
            recordNBT.m_128405_(SIDE_KEY, this.side.m_122411_());
            return recordNBT;
        }
    }
}

