/*
 * Decompiled with CFR 0.152.
 */
package zed.d0c.floormats.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import zed.d0c.floormats.clusters.Clusters;
import zed.d0c.floormats.setup.Registration;

@ParametersAreNonnullByDefault
public abstract class AbstractFloorMatBlock
extends BasePressurePlateBlock
implements SimpleWaterloggedBlock {
    public static final Clusters FloorMatClusters = new Clusters();
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public final Sensitivity sensitivity;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final HashMap<Player, BlockPos> linkUsedPosition = new HashMap();
    protected static final Random random = new Random();
    public static final TagKey<Item> CONNECTOR_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("floormats", "connectors"));
    public static final TagKey<Item> LINKER_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("floormats", "linkers"));

    protected AbstractFloorMatBlock(Sensitivity sensitivityIn, BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties, blockSetType);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivityIn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61368_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_, BlockStateProperties.f_61369_, POWERED, WATERLOGGED});
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public SoundEvent getClickOnSound() {
        return SoundEvents.f_12637_;
    }

    public SoundEvent getClickOffSound() {
        return SoundEvents.f_12636_;
    }

    public float getClickedFloat() {
        return 0.8f;
    }

    protected void playOnSound(@NotNull LevelAccessor worldIn, @NotNull BlockPos pos) {
        FloorMatClusters.playOnSound((BlockGetter)worldIn, pos);
    }

    protected void playOffSound(@NotNull LevelAccessor worldIn, @NotNull BlockPos pos) {
        FloorMatClusters.playOffSound((BlockGetter)worldIn, pos);
    }

    protected int m_6693_(Level worldIn, BlockPos pos) {
        BlockPos iPos = pos.m_7949_();
        AABB axisalignedbb = f_49287_.m_82338_(iPos);
        int redstoneStrength = 0;
        ArrayList<Player> playerList = new ArrayList<Player>();
        block0 : switch (this.sensitivity) {
            case EVERYTHING: {
                for (Entity entity : worldIn.m_45933_(null, axisalignedbb)) {
                    if (entity.m_6090_()) continue;
                    redstoneStrength = 15;
                    break block0;
                }
                break;
            }
            case MOBS: {
                for (Entity entity : worldIn.m_45976_(LivingEntity.class, axisalignedbb)) {
                    if (entity.m_6090_()) continue;
                    redstoneStrength = 15;
                    break block0;
                }
                break;
            }
            case ENTITIES: {
                if (worldIn.m_45976_(Entity.class, axisalignedbb).isEmpty()) break;
                redstoneStrength = 15;
                break;
            }
            case PLAYERS: {
                playerList.addAll(worldIn.m_45976_(Player.class, axisalignedbb));
                if (playerList.isEmpty()) break;
                redstoneStrength = 15;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.sensitivity);
            }
        }
        if (redstoneStrength != 0 && FloorMatClusters.applyDirectPower(worldIn, iPos, playerList)) {
            worldIn.m_186460_(iPos, (Block)this, this.m_7342_());
        }
        return redstoneStrength;
    }

    protected int m_6016_(@NotNull BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    @NotNull
    protected BlockState m_7422_(@NotNull BlockState state, int strength) {
        return (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_ && FloorMatClusters.hasNode(worldIn, state, pos) && !FloorMatClusters.hasDirectPower(state, worldIn, pos)) {
            this.m_6693_(worldIn, pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            if (this.m_6693_((Level)worldIn, pos) > 0) {
                worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, this.m_7342_());
            } else if (FloorMatClusters.removeDirectPower(state, (Level)worldIn, pos)) {
                this.playOffSound((LevelAccessor)worldIn, pos);
            }
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.f_46443_ && state.m_60734_() != oldState.m_60734_()) {
            FloorMatClusters.addToClusters(worldIn, pos, state);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos iPos = pos.m_7949_();
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            if (state.m_60734_() != newState.m_60734_()) {
                FloorMatClusters.removeFromClusters(serverLevel, iPos, state);
            }
        }
        super.m_6810_(state, worldIn, iPos, newState, isMoving);
    }

    public boolean canConnect(BlockState state) {
        return this.m_7374_().equals(state.m_60734_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Connections connections = this.getConnections((BlockGetter)blockgetter, blockpos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)connections.connectNorth())).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)connections.connectSouth())).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)connections.connectWest())).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)connections.connectEast())).m_61124_((Property)POWERED, (Comparable)connections.powered)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public Connections getConnections(BlockGetter blockgetter, BlockPos blockpos) {
        BlockState stateNorth = blockgetter.m_8055_(blockpos.m_122012_());
        BlockState stateSouth = blockgetter.m_8055_(blockpos.m_122019_());
        BlockState stateWest = blockgetter.m_8055_(blockpos.m_122024_());
        BlockState stateEast = blockgetter.m_8055_(blockpos.m_122029_());
        Boolean connectNorth = this.canConnect(stateNorth);
        Boolean connectSouth = this.canConnect(stateSouth);
        Boolean connectWest = this.canConnect(stateWest);
        Boolean connectEast = this.canConnect(stateEast);
        return new Connections(connectNorth, connectSouth, connectWest, connectEast, connectNorth != false && (Boolean)stateNorth.m_61143_((Property)POWERED) != false || connectSouth != false && (Boolean)stateSouth.m_61143_((Property)POWERED) != false || connectWest != false && (Boolean)stateWest.m_61143_((Property)POWERED) != false || connectEast != false && (Boolean)stateEast.m_61143_((Property)POWERED) != false);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (!facing.m_122434_().m_122479_()) {
            return super.m_7417_(stateIn, facing, facingState, levelAccessor, currentPos, facingPos);
        }
        return (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(AbstractFloorMatBlock.isConnected(stateIn, facing, facingState)));
    }

    public static boolean isConnected(BlockState stateIn, Direction facing, BlockState facingState) {
        return facingState.m_60734_() instanceof AbstractFloorMatBlock && ((Boolean)stateIn.m_61143_((Property)PipeBlock.f_55154_.get(facing)) != false || (Boolean)facingState.m_61143_((Property)PipeBlock.f_55154_.get(facing.m_122424_())) != false);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.m_6044_(worldIn, pos, state, fluidIn);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.WATER -> worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            case PathComputationType.LAND, PathComputationType.AIR -> false;
        };
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockPos iPos;
        if (fromPos.equals((Object)pos.m_7495_()) && !worldIn.m_5776_() && worldIn.m_276867_(fromPos) && FloorMatClusters.applyDirectPower(worldIn, iPos = pos.m_7949_(), null)) {
            worldIn.m_186460_(iPos, (Block)this, 30);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult trace) {
        ItemStack itemInHand;
        ItemStack itemStack = itemInHand = hand == InteractionHand.MAIN_HAND ? player.m_150109_().m_36056_() : (ItemStack)player.m_150109_().f_35976_.get(0);
        if (!AbstractFloorMatBlock.isConnector(itemInHand.m_41720_()) && !AbstractFloorMatBlock.isLinker(itemInHand.m_41720_())) {
            return InteractionResult.PASS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!FloorMatClusters.canAlter((Level)serverLevel, blockPos, blockState, player.m_20148_())) {
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Registration.FLOORMATS_DENIED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        ItemStack itemInOppositeHand = hand != InteractionHand.MAIN_HAND ? player.m_21205_() : player.m_21206_();
        BlockPos iPos = blockPos.m_7949_();
        if (AbstractFloorMatBlock.isConnector(itemInHand.m_41720_())) {
            this.useConnector(blockState, serverLevel, player, itemInOppositeHand, iPos, trace);
            return InteractionResult.SUCCESS;
        }
        if (AbstractFloorMatBlock.isLinker(itemInHand.m_41720_())) {
            this.useLinker(blockState, serverLevel, player, hand, itemInHand, iPos);
        }
        return InteractionResult.SUCCESS;
    }

    private Direction getHorizontalDirectionFromQuadrant(BlockPos pos, BlockHitResult trace) {
        double hitX = trace.m_82450_().f_82479_ - (double)pos.m_123341_() - 0.5;
        double hitZ = trace.m_82450_().f_82481_ - (double)pos.m_123343_() - 0.5;
        return switch (trace.m_82434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP, Direction.DOWN -> {
                if (Math.abs(hitX) > Math.abs(hitZ)) {
                    if (hitX > 0.0) {
                        yield Direction.EAST;
                    }
                    yield Direction.WEST;
                }
                if (hitZ > 0.0) {
                    yield Direction.SOUTH;
                }
                yield Direction.NORTH;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if (hitX > 0.0) {
                    yield Direction.EAST;
                }
                yield Direction.WEST;
            }
            case Direction.EAST, Direction.WEST -> hitZ > 0.0 ? Direction.SOUTH : Direction.NORTH;
        };
    }

    public static boolean isConnector(Item item) {
        return item.m_7968_().m_204117_(CONNECTOR_TAG);
    }

    private static boolean isLinker(Item item) {
        return item.m_7968_().m_204117_(LINKER_TAG);
    }

    protected static boolean hasTag(Item item, ResourceLocation tagRL) {
        return item.m_7968_().m_204117_(ItemTags.create((ResourceLocation)tagRL));
    }

    private void useConnector(BlockState stateIn, ServerLevel serverLevel, Player player, ItemStack offHandStack, BlockPos iPos, BlockHitResult trace) {
        serverLevel.m_5594_(null, player.m_20183_(), (SoundEvent)Registration.FLOORMATS_WRENCHED.get(), SoundSource.NEUTRAL, 0.5f, 0.8f / (random.nextFloat() * 0.4f + 0.8f));
        if (this.offHandAction(offHandStack, serverLevel, iPos)) {
            return;
        }
        Direction direction = this.getHorizontalDirectionFromQuadrant(iPos, trace);
        if (this.canToggleConnection(stateIn, serverLevel, player, iPos, direction)) {
            BlockState newState = this.toggleConnection(serverLevel, stateIn, iPos, direction);
            BlockPos adjacentPos = iPos.m_121945_(direction);
            if (((Boolean)newState.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue()) {
                FloorMatClusters.addToClusters((Level)serverLevel, iPos, newState);
            } else {
                this.toggleConnection(serverLevel, serverLevel.m_8055_(adjacentPos), adjacentPos, direction.m_122424_());
                FloorMatClusters.alterClusters(serverLevel, iPos, newState);
            }
        }
    }

    public BlockState toggleConnection(ServerLevel serverLevel, BlockState blockState, BlockPos blockPos, Direction direction) {
        BooleanProperty directionProp;
        BlockState newState = (BlockState)blockState.m_61124_((Property)directionProp, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)(directionProp = (BooleanProperty)PipeBlock.f_55154_.get(direction))) == false));
        serverLevel.m_46597_(blockPos, newState);
        serverLevel.m_6550_(blockPos, blockState, newState);
        return newState;
    }

    public boolean canToggleConnection(BlockState stateIn, ServerLevel serverLevel, Player player, BlockPos iPos, Direction direction) {
        BlockPos adjacentPos = iPos.m_121945_(direction);
        return serverLevel.m_8055_(adjacentPos).m_60734_() == stateIn.m_60734_() && FloorMatClusters.canAlter((Level)serverLevel, adjacentPos, stateIn, player.m_20148_());
    }

    @ParametersAreNonnullByDefault
    protected boolean offHandAction(ItemStack offHandStack, ServerLevel serverLevel, BlockPos iPos) {
        if (AbstractFloorMatBlock.hasTag(offHandStack.m_41720_(), new ResourceLocation("floormats", "mufflers"))) {
            FloorMatClusters.toggleMuffler(serverLevel, iPos);
            return true;
        }
        return false;
    }

    private void useLinker(BlockState stateIn, ServerLevel serverLevel, Player player, InteractionHand hand, ItemStack itemInHand, BlockPos iPos) {
        FloorMatClusters.linkEffects((Level)serverLevel, iPos, stateIn);
        float pitch = 0.8f / (random.nextFloat() * 0.4f + 0.8f);
        if (linkUsedPosition.containsKey(player)) {
            BlockPos firstPos = linkUsedPosition.get(player);
            BlockState firstBS = serverLevel.m_8055_(firstPos);
            if (firstBS.m_60734_() instanceof AbstractFloorMatBlock && FloorMatClusters.canAlter((Level)serverLevel, firstPos, firstBS, player.m_20148_())) {
                FloorMatClusters.linkEffects((Level)serverLevel, firstPos, firstBS);
                if (FloorMatClusters.linkClusters((Level)serverLevel, iPos, stateIn, firstPos, firstBS)) {
                    AbstractFloorMatBlock.consumeItemIfPossible((Level)serverLevel, player, hand, itemInHand);
                    serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Registration.FLOORMATS_LINKED.get(), SoundSource.NEUTRAL, 0.5f, pitch + 0.4f);
                } else {
                    serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Registration.FLOORMATS_UNLINKED.get(), SoundSource.NEUTRAL, 0.5f, pitch + 0.4f);
                }
                linkUsedPosition.remove(player);
            } else {
                linkUsedPosition.put(player, iPos);
                serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Registration.FLOORMATS_MARKED.get(), SoundSource.NEUTRAL, 0.5f, pitch);
            }
        } else {
            linkUsedPosition.put(player, iPos);
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Registration.FLOORMATS_MARKED.get(), SoundSource.NEUTRAL, 0.5f, pitch);
        }
        player.m_36335_().m_41524_(itemInHand.m_41720_(), 20);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemInHand.m_41720_()));
    }

    private static void consumeItemIfPossible(Level worldIn, Player player, InteractionHand hand, ItemStack itemInHand) {
        if (!player.m_7500_()) {
            if (itemInHand.m_41741_() > 1) {
                itemInHand.m_41774_(1);
            } else if (itemInHand.m_220157_(1, worldIn.f_46441_, (ServerPlayer)player)) {
                itemInHand.m_41764_(0);
            }
            player.m_21008_(hand, itemInHand);
        }
    }

    public MutableComponent getToolTipText() {
        return Component.m_237115_((String)"tooltip.ctrl_shift.floor_mat");
    }

    public static enum Sensitivity {
        EVERYTHING,
        MOBS,
        ENTITIES,
        PLAYERS;

    }

    public record Connections(Boolean connectNorth, Boolean connectSouth, Boolean connectWest, Boolean connectEast, Boolean powered) {
        public Boolean getConnection(Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> this.connectNorth;
                case Direction.EAST -> this.connectEast;
                case Direction.SOUTH -> this.connectSouth;
                case Direction.WEST -> this.connectWest;
                default -> Boolean.FALSE;
            };
        }
    }
}

