/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fzzyhmstrs.emi_loot.EMILoot;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootTable;

public class ServerResourceData {
    public static final Multimap<ResourceLocation, LootTable> DIRECT_DROPS = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
    public static final List<ResourceLocation> SHEEP_TABLES;
    public static final List<ResourceLocation> TABLE_EXCLUSIONS;
    private static final Gson GSON;
    private static final int DIRECT_DROPS_PATH_LENGTH;
    private static final int FILE_SUFFIX_LENGTH;

    public static void loadDirectTables(ResourceManager resourceManager) {
        DIRECT_DROPS.clear();
        resourceManager.m_214159_("direct_drops", path -> path.m_135815_().endsWith(".json")).forEach(ServerResourceData::loadDirectTable);
        resourceManager.m_214159_("emi_loot_data", path -> path.m_135815_().endsWith(".json")).forEach(ServerResourceData::loadTableExclusion);
    }

    private static void loadDirectTable(ResourceLocation id, Resource resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading direct drop table from file: " + id.toString());
        }
        String path = id.m_135815_();
        ResourceLocation id2 = new ResourceLocation(id.m_135827_(), path.substring(DIRECT_DROPS_PATH_LENGTH, path.length() - FILE_SUFFIX_LENGTH));
        String path2 = id2.m_135815_();
        if (!path2.startsWith("blocks/") && !path2.startsWith("entities/")) {
            EMILoot.LOGGER.error("File path for [" + id + "] not correct; needs a 'blocks' or 'entities' subfolder. Skipping.");
            EMILoot.LOGGER.error("Example: [./data/mod_id/direct_drops/blocks/cobblestone.json] is a valid block direct drop table path for a block added by [mod_id].");
            return;
        }
        try {
            BufferedReader reader = resource.m_215508_();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            LootTable lootTable = (LootTable)GSON.fromJson((JsonElement)json, LootTable.class);
            if (lootTable != null) {
                DIRECT_DROPS.put((Object)id2, (Object)lootTable);
            } else {
                EMILoot.LOGGER.error("Loot table in file [" + id + "] is empty!");
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read direct drops loot table file: " + id);
        }
    }

    private static void loadTableExclusion(ResourceLocation id, Resource resource) {
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info("Reading exclusion table from file: " + id.toString());
        }
        try {
            BufferedReader reader = resource.m_215508_();
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonElement list = json.get("exclusions");
            if (list != null && list.isJsonArray()) {
                list.getAsJsonArray().forEach(element -> {
                    if (element.isJsonPrimitive()) {
                        ResourceLocation identifier = new ResourceLocation(element.getAsString());
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Adding exclusion: " + identifier);
                        }
                        TABLE_EXCLUSIONS.add(identifier);
                    } else {
                        EMILoot.LOGGER.error("Exclusion element not properly formatted: " + element);
                    }
                });
            } else {
                EMILoot.LOGGER.error("Exclusions in file: " + id + " not readable.");
            }
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to open or read table exclusions file: " + id);
        }
    }

    public static boolean skipTable(ResourceLocation id) {
        return TABLE_EXCLUSIONS.contains(id);
    }

    public static Multimap<ResourceLocation, LootTable> getMissedDirectDrops(List<ResourceLocation> parsedList) {
        Multimap missedDrops = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        for (Map.Entry entry : DIRECT_DROPS.entries()) {
            if (parsedList.contains(entry.getKey())) continue;
            missedDrops.put((Object)((ResourceLocation)entry.getKey()), (Object)((LootTable)entry.getValue()));
        }
        return missedDrops;
    }

    static {
        TABLE_EXCLUSIONS = new LinkedList<ResourceLocation>();
        GSON = Deserializers.m_78800_().create();
        DIRECT_DROPS_PATH_LENGTH = "direct_drops/".length();
        FILE_SUFFIX_LENGTH = ".json".length();
        ResourceLocation[] ids = new ResourceLocation[]{BuiltInLootTables.f_78702_, BuiltInLootTables.f_78703_, BuiltInLootTables.f_78704_, BuiltInLootTables.f_78705_, BuiltInLootTables.f_78706_, BuiltInLootTables.f_78707_, BuiltInLootTables.f_78708_, BuiltInLootTables.f_78709_, BuiltInLootTables.f_78710_, BuiltInLootTables.f_78711_, BuiltInLootTables.f_78714_, BuiltInLootTables.f_78715_, BuiltInLootTables.f_78716_, BuiltInLootTables.f_78717_, BuiltInLootTables.f_78718_, BuiltInLootTables.f_78719_};
        SHEEP_TABLES = Arrays.stream(ids).toList();
    }
}

