/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.server.BlockLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.util.TextKey;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lol.bai.badpackets.api.PacketSender;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class BlockLootTableSender
implements LootSender<BlockLootPoolBuilder> {
    private final String idToSend;
    final List<BlockLootPoolBuilder> builderList = new LinkedList<BlockLootPoolBuilder>();
    public static ResourceLocation BLOCK_SENDER = new ResourceLocation("e_l", "b_s");
    boolean isEmpty = true;

    public BlockLootTableSender(ResourceLocation id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(ServerPlayer player) {
        if (this.isEmpty) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("avoiding empty block: " + this.idToSend);
            }
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(this.idToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("sending simple block: " + this.idToSend);
            }
            buf.writeShort(-1);
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)this.builderList.get((int)0).simpleStack.m_41720_());
            PacketSender.s2c((ServerPlayer)player).send(BLOCK_SENDER, buf);
            return;
        }
        if (this.builderList.isEmpty()) {
            return;
        }
        buf.writeShort(this.builderList.size());
        this.builderList.forEach(builder -> {
            buf.writeShort(builder.conditions.size());
            builder.conditions.forEach(lootConditionResult -> lootConditionResult.text().toBuf(buf));
            buf.writeShort(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, ChestLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.writeShort(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.writeShort(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<ItemStack> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new ChestLootPoolBuilder((float)1.0f)).builtMap;
                buf.writeShort(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    buf.m_130055_(stack);
                    buf.writeFloat(weight.floatValue());
                });
            });
        });
        PacketSender.s2c((ServerPlayer)player).send(BLOCK_SENDER, buf);
    }

    @Override
    public void addBuilder(BlockLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<BlockLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

