/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.registry;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.condition.BlockStatePropertyConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.DamageSourceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.EntityPropertiesConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.InvertedConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.LocationCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.MatchToolConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.RandomChanceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.RandomChanceWithLootingConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ReferenceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.SimpleConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.SurvivesExplosionConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.TableBonusConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.TimeCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ValueCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.WeatherCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.function.ApplyBonusFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.CopyNameFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.EnchantRandomlyFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.EnchantWithLevelsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ExplorationMapFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ExplosionDecayFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.FunctionParser;
import fzzyhmstrs.emi_loot.parser.function.LimitCountFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.OminousBannerFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetAnyDamageFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetAttributesFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetCountFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetDamageFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetEnchantmentsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetInstrumentFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetLootTableFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetNameFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetPotionFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetStewFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SimpleFunctionParser;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootParserRegistry {
    private static final Map<LootItemConditionType, ConditionParser> CONDITION_PARSERS = new HashMap<LootItemConditionType, ConditionParser>();
    private static final Map<LootItemFunctionType, FunctionParser> FUNCTION_PARSERS = new HashMap<LootItemFunctionType, FunctionParser>();

    public static void registerCondition(LootItemConditionType type, ConditionParser parser, String registrationContext) {
        if (!CONDITION_PARSERS.containsKey(type)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("Registering condition for type: " + type + " from: " + registrationContext);
            }
            CONDITION_PARSERS.put(type, parser);
        } else {
            EMILoot.LOGGER.warn("Duplicate condition registration attempted with type: " + type + " during " + registrationContext);
        }
    }

    public static void registerFunction(LootItemFunctionType type, FunctionParser parser, String registrationContext) {
        if (!FUNCTION_PARSERS.containsKey(type)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("Registering function for type: " + type + " from: " + registrationContext);
            }
            FUNCTION_PARSERS.put(type, parser);
        } else {
            EMILoot.LOGGER.warn("Duplicate function registration attempted with type: " + type + " during " + registrationContext);
        }
    }

    public static List<LootTableParser.LootConditionResult> parseCondition(LootItemCondition condition, LootItemConditionType type, ItemStack stack, boolean parentIsAlternative) {
        ConditionParser parser = CONDITION_PARSERS.getOrDefault(type, ConditionParser.EMPTY);
        return parser.parseCondition(condition, stack, parentIsAlternative);
    }

    public static LootTableParser.LootFunctionResult parseFunction(LootItemFunction function, ItemStack stack, LootItemFunctionType type, boolean parentIsAlternative, List<TextKey> conditionTexts) {
        FunctionParser parser = FUNCTION_PARSERS.getOrDefault(type, FunctionParser.EMPTY);
        return parser.parseFunction(function, stack, parentIsAlternative, conditionTexts);
    }

    static {
        LootParserRegistry.registerFunction(LootItemFunctions.f_80750_, new ApplyBonusFunctionParser(), "Registering vanilla apply bonus function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_193030_, new SetPotionFunctionParser(), "Registering vanilla set potion function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80736_, new SetCountFunctionParser(), "Registering vanilla set count function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80737_, new EnchantWithLevelsFunctionParser(), "Registering vanilla enchant with levels function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80738_, new EnchantRandomlyFunctionParser(), "Registering vanilla enchant randomly function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_165221_, new SetEnchantmentsFunctionParser(), "Registering vanilla set enchantments function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80740_, new SimpleFunctionParser("emi_loot.function.smelt"), "Registering vanilla furnace smelt function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80741_, new SimpleFunctionParser("emi_loot.function.looting"), "Registering vanilla looting function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80745_, new ExplorationMapFunctionParser(), "Registering vanilla exploration map function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80744_, new SetNameFunctionParser(), "Registering vanilla set name function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80748_, new SimpleFunctionParser("emi_loot.function.set_contents"), "Registering vanilla set contents function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80742_, new SetDamageFunctionParser(), "Registering vanilla set damage function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_230994_, new SetInstrumentFunctionParser(), "Registering vanilla set instrument function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80756_, new SimpleFunctionParser("emi_loot.function.copy_state"), "Registering vanilla copy state function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80747_, new CopyNameFunctionParser(), "Registering vanilla copy name function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80755_, new SimpleFunctionParser("emi_loot.function.copy_nbt"), "Registering vanilla copy nbt function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80752_, new ExplosionDecayFunctionParser(), "Registering vanilla explosion decay function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80754_, new SimpleFunctionParser("emi_loot.function.fill_player_head"), "Registering vanilla fill-player-head function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80749_, new LimitCountFunctionParser(), "Registering vanilla limit-count function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80743_, new SetAttributesFunctionParser(), "Registering vanilla set attributes function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_165222_, new SimpleFunctionParser("emi_loot.function.banner"), "Registering vanilla set banner function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80753_, new SimpleFunctionParser("emi_loot.function.lore"), "Registering vanilla set lore function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80746_, new SetStewFunctionParser(), "Registering vanilla set stew effect function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80739_, new SimpleFunctionParser("emi_loot.function.set_nbt"), "Registering vanilla set nbt function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.f_80751_, new SetLootTableFunctionParser(), "Registering vanilla set loot table function parser");
        LootParserRegistry.registerFunction(EMILoot.OMINOUS_BANNER, new OminousBannerFunctionParser(), "Registering Lootify ominous banner function parser");
        LootParserRegistry.registerFunction(EMILoot.SET_ANY_DAMAGE, new SetAnyDamageFunctionParser(), "Registering Lootify set-any-damage function parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81821_, new SurvivesExplosionConditionParser(), "Registering vanilla survives-explosion condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81818_, new BlockStatePropertyConditionParser(), "Registering vanilla block state property condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81820_, new TableBonusConditionParser(), "Registering vanilla table bonus condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81811_, new InvertedConditionParser(), "Registering vanilla inverted condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81816_, new SimpleConditionParser("emi_loot.condition.killed_player"), "Registering vanilla killed-by-player condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81813_, new RandomChanceConditionParser(), "Registering vanilla random chance condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81814_, new RandomChanceWithLootingConditionParser(), "Registering vanilla random chance with looting condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81822_, new DamageSourceConditionParser(), "Registering vanilla damage source properties condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81823_, new LocationCheckConditionParser(), "Registering vanilla location check condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81815_, new EntityPropertiesConditionParser(), "Registering vanilla entity properties condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81819_, new MatchToolConditionParser(), "Registering vanilla match-tool condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81817_, new SimpleConditionParser("emi_loot.condition.entity_scores"), "Registering vanilla entity scores condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81825_, new ReferenceConditionParser(), "Registering vanilla reference condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81826_, new TimeCheckConditionParser(), "Registering vanilla time check condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_165504_, new ValueCheckConditionParser(), "Registering vanilla value check condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.f_81824_, new WeatherCheckConditionParser(), "Registering vanilla weather check condition parser");
        LootParserRegistry.registerCondition(EMILoot.SPAWNS_WITH, new SimpleConditionParser("emi_loot.condition.spawns_with"), "Registering lootify spawns with condition parser");
        LootParserRegistry.registerCondition(EMILoot.CREEPER, new SimpleConditionParser("emi_loot.condition.creeper"), "Registering lootify creeper condition parser");
        LootParserRegistry.registerCondition(EMILoot.WITHER_KILL, new SimpleConditionParser("emi_loot.condition.wither_kill"), "Registering lootify wither-killed condition parser");
    }
}

