/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.condition;

import fzzyhmstrs.emi_loot.mixins.AlternativeLootConditionAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.condition.ConditionParser;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AlternativesConditionParser
implements ConditionParser {
    @Override
    public List<LootTableParser.LootConditionResult> parseCondition(LootItemCondition condition, ItemStack stack, boolean parentIsAlternative) {
        LootItemCondition[] terms = ((AlternativeLootConditionAccessor)condition).getConditions();
        int size = terms.length;
        if (size == 1) {
            List<LootTableParser.LootConditionResult> termResults = LootTableParser.parseLootCondition(terms[0], stack);
            Component termText = LootTableParser.compileConditionTexts(stack, termResults);
            return Collections.singletonList(new LootTableParser.LootConditionResult(TextKey.of("emi_loot.condition.alternates", termText.getString())));
        }
        if (size == 2) {
            TextKey key;
            List<LootTableParser.LootConditionResult> termResults1 = LootTableParser.parseLootCondition(terms[0], stack);
            List<LootTableParser.LootConditionResult> termResults2 = LootTableParser.parseLootCondition(terms[1], stack);
            Component termText1 = LootTableParser.compileConditionTexts(stack, termResults1);
            Component termText2 = termResults2.size() == 1 ? ((key = termResults2.get(0).getText()).args().size() == 1 ? Component.m_130674_((String)key.args().get(0)) : LootTableParser.compileConditionTexts(stack, termResults2)) : LootTableParser.compileConditionTexts(stack, termResults2);
            LinkedList<String> args = new LinkedList<String>(Arrays.stream(new String[]{termText1.getString(), termText2.getString()}).toList());
            return Collections.singletonList(new LootTableParser.LootConditionResult(TextKey.of("emi_loot.condition.alternates_2", args)));
        }
        LinkedList<String> args = new LinkedList<String>();
        Arrays.stream(terms).toList().forEach(term -> {
            List<LootTableParser.LootConditionResult> termResults = LootTableParser.parseLootCondition(term, stack);
            Component termText = LootTableParser.compileConditionTexts(stack, termResults);
            args.add(termText.getString());
        });
        return Collections.singletonList(new LootTableParser.LootConditionResult(TextKey.of("emi_loot.condition.alternates_3", args)));
    }
}

