/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.EffectDataAccessor;
import fzzyhmstrs.emi_loot.mixins.EntityEffectPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;

public class EntityEffectPredicateParser {
    public static Component parseEntityEffectPredicate(MobEffectsPredicate predicate) {
        Map<MobEffect, MobEffectsPredicate.MobEffectInstancePredicate> effects = ((EntityEffectPredicateAccessor)predicate).getEffects();
        LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
        for (Map.Entry<MobEffect, MobEffectsPredicate.MobEffectInstancePredicate> entry : effects.entrySet()) {
            Boolean visible;
            Boolean ambient;
            MinMaxBounds.Ints duration;
            Component name = entry.getKey().m_19482_();
            MobEffectsPredicate.MobEffectInstancePredicate data = entry.getValue();
            MinMaxBounds.Ints amplifier = ((EffectDataAccessor)data).getAmplifier();
            if (!amplifier.equals(MinMaxBounds.Ints.f_55364_)) {
                Integer max;
                Integer min = (Integer)amplifier.m_55305_();
                if (Objects.equals(min, max = (Integer)amplifier.m_55326_()) && min != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier", name.getString(), min + 1));
                } else if (min != null && max != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier_2", name.getString(), min + 1, max + 1));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.amplifier_3", name.getString()));
                }
            }
            if (!(duration = ((EffectDataAccessor)data).getDuration()).equals(MinMaxBounds.Ints.f_55364_)) {
                Integer max;
                Integer min = (Integer)duration.m_55305_();
                if (Objects.equals(min, max = (Integer)duration.m_55326_()) && min != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration", name.getString(), min + 1));
                } else if (min != null && max != null) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration_2", name.getString(), min + 1, max + 1));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.duration_3", name.getString()));
                }
            }
            if ((ambient = ((EffectDataAccessor)data).getAmbient()) != null) {
                if (ambient.booleanValue()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.ambient_true", name.getString()));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.ambient_false", name.getString()));
                }
            }
            if ((visible = ((EffectDataAccessor)data).getVisible()) != null) {
                if (visible.booleanValue()) {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.visible_true", name.getString()));
                } else {
                    list.add(LText.translatable("emi_loot.entity_predicate.effect.visible_false", name.getString()));
                }
            }
            list.add(LText.translatable("emi_loot.entity_predicate.effect.fallback", name.getString()));
        }
        if (!list.isEmpty()) {
            return LText.translatable("emi_loot.entity_predicate.effect_1", ListProcessors.buildAndList(list));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Unparsable entity effect predicate in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

