/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockLootRecipe
implements EmiRecipe {
    private final ClientBlockLootTable loot;
    private final EmiStack inputStack;
    private final List<EmiStack> outputStacks;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public BlockLootRecipe(ClientBlockLootTable loot) {
        this.loot = loot;
        ResourceLocation blockId = loot.blockId;
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId);
        loot.build((Level)Minecraft.m_91087_().f_91073_, block);
        this.inputStack = EmiStack.of((ItemLike)block);
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stackMap().forEach((weight, stacks) -> list.addAll(stacks.getEmiStacks()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        WidgetRowBuilder builder;
        boolean newBuilder = false;
        if (recursive || this.rowBuilderList.isEmpty()) {
            builder = new WidgetRowBuilder(115);
            newBuilder = true;
        } else {
            builder = this.rowBuilderList.get(this.rowBuilderList.size() - 1);
        }
        Optional<ClientBuiltPool> opt = builder.addAndTrim(newPool);
        if (newBuilder) {
            this.rowBuilderList.add(builder);
        }
        opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.BLOCK_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return new ResourceLocation("emi", EMILootClient.MOD_ID + "/" + this.getCategory().id.m_135815_() + "/" + this.loot.id.m_135827_() + "/" + this.loot.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 23 + 29 * (this.rowBuilderList.size() - 1);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputStack, 0, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 0);
        int x = 46;
        int y = 0;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            for (ClientBuiltPool pool : builder.getPoolList()) {
                IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                widgets.add((Widget)widget);
                x += widget.getWidth() + 6;
            }
            y += 29;
            x = 46;
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

