/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import fzzyhmstrs.emi_loot.server.ArchaeologyLootTableSender;
import fzzyhmstrs.emi_loot.server.BlockLootTableSender;
import fzzyhmstrs.emi_loot.server.ChestLootTableSender;
import fzzyhmstrs.emi_loot.server.GameplayLootTableSender;
import fzzyhmstrs.emi_loot.server.MobLootTableSender;
import java.util.LinkedList;
import java.util.List;
import lol.bai.badpackets.api.S2CPacketReceiver;
import net.minecraft.resources.ResourceLocation;

public class ClientLootTables {
    private final List<LootReceiver> loots = new LinkedList<LootReceiver>();

    public List<LootReceiver> getLoots() {
        return this.loots;
    }

    public void registerClient() {
        S2CPacketReceiver.register((ResourceLocation)ChestLootTableSender.CHEST_SENDER, (client, handler, buf, responseSender) -> {
            LootReceiver table = ClientChestLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received chest " + table.getId());
            }
        });
        S2CPacketReceiver.register((ResourceLocation)BlockLootTableSender.BLOCK_SENDER, (client, handler, buf, responseSender) -> {
            LootReceiver table = ClientBlockLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received block " + table.getId());
            }
        });
        S2CPacketReceiver.register((ResourceLocation)MobLootTableSender.MOB_SENDER, (client, handler, buf, responseSender) -> {
            LootReceiver table = ClientMobLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received mob " + table.getId());
            }
        });
        S2CPacketReceiver.register((ResourceLocation)GameplayLootTableSender.GAMEPLAY_SENDER, (client, handler, buf, responseSender) -> {
            LootReceiver table = ClientGameplayLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received gameplay loot: " + table.getId());
            }
        });
        S2CPacketReceiver.register((ResourceLocation)ArchaeologyLootTableSender.ARCHAEOLOGY_SENDER, (client, handler, buf, responseSender) -> {
            LootReceiver table = ClientArchaeologyLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received archaeology loot: " + table.getId());
            }
        });
    }
}

