/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fzzyhmstrs.emi_loot.EMILootExpectPlatform;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.server.condition.BlownUpByCreeperLootCondition;
import fzzyhmstrs.emi_loot.server.condition.KilledByWitherLootCondition;
import fzzyhmstrs.emi_loot.server.condition.MobSpawnedWithLootCondition;
import fzzyhmstrs.emi_loot.server.function.OminousBannerLootFunction;
import fzzyhmstrs.emi_loot.server.function.SetAnyDamageLootFunction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMILoot {
    public static final String MOD_ID = "emi_loot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"emi_loot");
    public static RandomSource emiLootRandom = new SingleThreadedRandomSource(System.currentTimeMillis());
    public static LootTableParser parser = new LootTableParser();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static EmiLootConfig config = EMILoot.readOrCreate();
    public static boolean DEBUG = EMILoot.config.debugMode;
    public static LootItemConditionType WITHER_KILL;
    public static LootItemConditionType SPAWNS_WITH;
    public static LootItemConditionType CREEPER;
    public static LootItemFunctionType SET_ANY_DAMAGE;
    public static LootItemFunctionType OMINOUS_BANNER;
    public static Enchantment RANDOM;

    public static void init() {
    }

    public static void register() {
        WITHER_KILL = LootItemConditions.m_81831_((String)"lootify:wither_kill", (Serializer)new KilledByWitherLootCondition.Serializer());
        SPAWNS_WITH = LootItemConditions.m_81831_((String)"lootify:spawns_with", (Serializer)new MobSpawnedWithLootCondition.Serializer());
        CREEPER = LootItemConditions.m_81831_((String)"lootify:creeper", (Serializer)new BlownUpByCreeperLootCondition.Serializer());
        SET_ANY_DAMAGE = LootItemFunctions.m_80762_((String)"lootify:set_any_damage", (Serializer)new SetAnyDamageLootFunction.Serializer());
        OMINOUS_BANNER = LootItemFunctions.m_80762_((String)"lootify:ominous_banner", (Serializer)new OminousBannerLootFunction.Serializer());
    }

    private static EmiLootConfig readOrCreate() {
        File dir = EMILootExpectPlatform.getConfigDir().toFile();
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("EMI Loot could not find or create config directory, using default configs");
            return new EmiLootConfig();
        }
        String f_old_name = "EmiLootConfig.json";
        String f_name = "EmiLootConfig_v1.json";
        File f_old = new File(dir, f_old_name);
        try {
            if (f_old.exists()) {
                EmiLootConfigOld oldConfig = (EmiLootConfigOld)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f_old)), EmiLootConfigOld.class);
                EmiLootConfig newConfig = oldConfig.generateNewConfig();
                File f = new File(dir, f_name);
                if (f.exists()) {
                    f_old.delete();
                    return (EmiLootConfig)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f)), EmiLootConfig.class);
                }
                if (!f.createNewFile()) {
                    LOGGER.error("Failed to create new config file, using old config with new defaults.");
                } else {
                    f_old.delete();
                    FileWriter fw = new FileWriter(f);
                    String json = gson.toJson((Object)newConfig);
                    if (DEBUG) {
                        LOGGER.info(json);
                    }
                    fw.write(json);
                    fw.close();
                }
                return newConfig;
            }
            File f = new File(dir, f_name);
            if (f.exists()) {
                return (EmiLootConfig)gson.fromJson((Reader)new InputStreamReader(new FileInputStream(f)), EmiLootConfig.class);
            }
            if (!f.createNewFile()) {
                throw new UnsupportedOperationException("couldn't generate config file");
            }
            FileWriter fw = new FileWriter(f);
            EmiLootConfig emc = new EmiLootConfig();
            String json = gson.toJson((Object)emc);
            if (DEBUG) {
                LOGGER.info(json);
            }
            fw.write(json);
            fw.close();
            return emc;
        }
        catch (Exception e) {
            LOGGER.error("Emi Loot failed to create or read it's config file!");
            LOGGER.error(Arrays.toString(e.getStackTrace()));
            return new EmiLootConfig();
        }
    }

    static {
        RANDOM = new Enchantment(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.TRIDENT, EquipmentSlot.values()){

            public boolean m_6594_() {
                return false;
            }

            public boolean m_6592_() {
                return false;
            }
        };
    }

    public static class EmiLootConfig {
        public boolean debugMode = false;
        public boolean parseChestLoot = true;
        public boolean parseBlockLoot = true;
        public boolean parseMobLoot = true;
        public boolean parseGameplayLoot = true;
        public boolean chestLootCompact = true;
        public boolean chestLootAlwaysStackSame = false;
        public boolean mobLootIncludeDirectDrops = true;
        public boolean parseArchaeologyLoot = true;
    }

    public static class EmiLootConfigOld {
        public boolean parseChestLoot = true;
        public boolean parseBlockLoot = true;
        public boolean parseMobLoot = true;
        public boolean parseGameplayLoot = true;

        public EmiLootConfig generateNewConfig() {
            EmiLootConfig newConfig = new EmiLootConfig();
            newConfig.parseChestLoot = this.parseChestLoot;
            newConfig.parseBlockLoot = this.parseBlockLoot;
            newConfig.parseMobLoot = this.parseMobLoot;
            newConfig.parseGameplayLoot = this.parseGameplayLoot;
            return newConfig;
        }
    }
}

