/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.ClimbingAnimal;
import com.starfish_studios.naturalist.common.entity.core.EggLayingAnimal;
import com.starfish_studios.naturalist.common.entity.core.HidingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.EggLayingBreedGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.LayEggGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistBlocks;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistItems;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Snail
extends ClimbingAnimal
implements GeoEntity,
Bucketable,
HidingAnimal,
EggLayingAnimal {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42732_});
    private static EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLOR;
    private static final EntityDataAccessor<Boolean> HAS_EGG;
    private static final EntityDataAccessor<Boolean> LAYING_EGG;
    int layEggCounter;

    public Snail(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new EggLayingBreedGoal<Snail>(this, 1.0));
        this.f_21345_.m_25352_(1, new LayEggGoal<Snail>(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SnailStrollGoal((PathfinderMob)this, 0.9, 0.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(this.canHide() ? strength / 4.0 : strength, x, z);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, this.canHide() ? amount * 0.8f : amount);
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    @Override
    public Block getEggBlock() {
        return NaturalistBlocks.SNAIL_EGGS.get();
    }

    @Override
    public TagKey<Block> getEggLayableBlockTag() {
        return NaturalistTags.BlockTags.ALLIGATOR_EGG_LAYABLE_ON;
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean isLayingEgg) {
        this.layEggCounter = isLayingEgg ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)isLayingEgg);
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.hasEgg();
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.3f;
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)NaturalistEntityTypes.SNAIL.get().m_20615_((Level)level);
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public void m_7023_(Vec3 vec3) {
        if (this.canHide()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    public void m_8107_() {
        if (this.canHide() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)Color.BROWN.getId());
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128344_("Color", (byte)this.getSnailColor().getId());
        pCompound.m_128379_("HasEgg", this.hasEgg());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setSnailColor(Color.BY_ID[pCompound.m_128451_("Color")]);
        this.setHasEgg(pCompound.m_128471_("HasEgg"));
    }

    public Color getSnailColor() {
        return Color.BY_ID[(Integer)this.f_19804_.m_135370_(DATA_COLOR)];
    }

    public void setSnailColor(Color color) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)color.getId());
    }

    public DyeColor getColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLOR)));
    }

    public void setColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)color.m_41060_());
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        DyeItem dyeItem;
        DyeColor dyeColor;
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        Item item = itemStack.m_41720_();
        if (item instanceof DyeItem && (dyeColor = (dyeItem = (DyeItem)item).m_41089_()) != this.getColor()) {
            this.setColor(dyeColor);
            if (!pPlayer.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return Snail.bucketMobPickup(pPlayer, pHand, this).orElse(super.m_6071_(pPlayer, pHand));
    }

    static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42446_ && entity.m_6084_()) {
            entity.m_5496_(((Bucketable)entity).m_142623_(), 1.0f, 1.0f);
            ItemStack bucketStack = ((Bucketable)entity).m_28282_();
            ((Bucketable)entity).m_6872_(bucketStack);
            ItemStack resultStack = ItemUtils.m_41817_((ItemStack)stack, (Player)player, (ItemStack)bucketStack, (boolean)false);
            player.m_21008_(hand, resultStack);
            Level level = entity.m_9236_();
            if (!level.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketStack);
            }
            entity.m_146870_();
            return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return Optional.empty();
    }

    public void m_6872_(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        compoundTag.m_128405_("Color", this.getSnailColor().getId());
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        int i = tag.m_128451_("Color");
        if (i >= 0 && i < Color.BY_ID.length) {
            this.setSnailColor(Color.BY_ID[i]);
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)NaturalistItems.SNAIL_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return NaturalistSoundEvents.BUCKET_FILL_SNAIL.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.SNAIL_CRUSH.get();
    }

    @Override
    public boolean canHide() {
        List players = this.m_9236_().m_45955_(TargetingConditions.m_148353_().m_26883_(5.0).m_26888_(EntitySelector.f_20406_::test), (LivingEntity)this, this.m_20191_().m_82377_(5.0, 3.0, 5.0));
        return !players.isEmpty();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Snail> PlayState predicate(AnimationState<E> event) {
        if (this.canHide()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("retreat"));
        } else if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("crawl"));
            event.getController().setAnimationSpeed((double)0.6f);
        } else if (this.isClimbing()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("climb"));
            event.getController().setAnimationSpeed((double)0.6f);
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            event.getController().setAnimationSpeed((double)0.4f);
        }
        return PlayState.CONTINUE;
    }

    private void soundListener(SoundKeyframeEvent<Snail> event) {
        Snail snail = (Snail)event.getAnimatable();
        if (snail.m_9236_().f_46443_) {
            if (event.getKeyframeData().getSound().equals("forward")) {
                snail.m_9236_().m_7785_(snail.m_20185_(), snail.m_20186_(), snail.m_20189_(), NaturalistSoundEvents.SNAIL_FORWARD.get(), snail.m_5720_(), 0.5f, 1.0f, false);
            }
            if (event.getKeyframeData().getSound().equals("back")) {
                snail.m_9236_().m_7785_(snail.m_20185_(), snail.m_20186_(), snail.m_20189_(), NaturalistSoundEvents.SNAIL_BACK.get(), snail.m_5720_(), 0.5f, 1.0f, false);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
    }

    static {
        HAS_EGG = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        LAYING_EGG = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_COLOR = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FROM_BUCKET = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    static class SnailStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public SnailStrollGoal(PathfinderMob pMob, double pSpeedModifier, float pProbability) {
            super(pMob, pSpeedModifier, pProbability);
            this.f_25731_ = true;
            this.f_25730_ = 1;
        }
    }

    public static enum Color {
        WHITE(0, "white", true),
        ORANGE(1, "orange", true),
        MAGENTA(2, "magenta", true),
        LIGHT_BLUE(3, "light_blue", true),
        YELLOW(4, "yellow", true),
        LIME(5, "lime", true),
        PINK(6, "pink", true),
        GRAY(7, "gray", true),
        LIGHT_GRAY(8, "light_gray", true),
        CYAN(9, "cyan", true),
        PURPLE(10, "purple", true),
        BLUE(11, "blue", true),
        BROWN(12, "brown", true),
        GREEN(13, "green", true),
        RED(14, "red", true),
        BLACK(15, "black", true);

        public static final Color[] BY_ID;
        private final int id;
        private final String name;

        private Color(int j, String string2, boolean bl) {
            this.id = j;
            this.name = string2;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Color getTypeById(int id) {
            for (Color type : Color.values()) {
                if (type.id != id) continue;
                return type;
            }
            return BROWN;
        }

        static {
            BY_ID = (Color[])Arrays.stream(Color.values()).sorted(Comparator.comparingInt(Color::getId)).toArray(Color[]::new);
        }
    }
}

