/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.SleepingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SleepGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.BetterGroundPathNavigation;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Lion
extends Animal
implements GeoEntity,
SleepingAnimal {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(Lion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_MANE = SynchedEntityData.m_135353_(Lion.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Lion(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        AgeableMob.AgeableMobGroupData ageableMobGroupData;
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(true);
            this.setHasMane(this.m_217043_().m_188499_());
        }
        if ((ageableMobGroupData = (AgeableMob.AgeableMobGroupData)spawnData).m_146777_() > 2) {
            this.m_146762_(-24000);
        }
        ageableMobGroupData.m_146778_();
        RandomSource random = level.m_213780_();
        this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random spawn bonus", random.m_216328_(0.0, 0.11485000000000001), AttributeModifier.Operation.MULTIPLY_BASE));
        return spawnData;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NaturalistEntityTypes.LION.get().m_20615_((Level)serverLevel);
    }

    protected PathNavigation m_6037_(Level level) {
        return new BetterGroundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LionPreyGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(3, new SleepGoal<Lion>(this));
        this.f_21345_.m_25352_(4, (Goal)new LionFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LionFollowLeaderGoal(this, 1.1, 8.0f, 24.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new BabyHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 10, true, true, entity -> entity.m_6095_().m_204039_(NaturalistTags.EntityTypes.LION_HOSTILES) && !entity.m_6162_() && !this.m_5803_() && !this.m_6162_() && this.m_9236_().m_46462_()));
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(HAS_MANE, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Mane", this.hasMane());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setHasMane(pCompound.m_128471_("Mane"));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
    }

    protected void m_30232_() {
        super.m_30232_();
        this.setHasMane(this.m_217043_().m_188499_());
    }

    @Override
    public boolean canSleep() {
        long dayTime = this.m_9236_().m_46468_();
        if (this.m_5448_() != null || this.m_9236_().m_46801_(this.m_20183_())) {
            return false;
        }
        return dayTime > 6000L && dayTime < 13000L;
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double speedModifier = this.m_21566_().m_24999_();
            if (speedModifier < 1.0 && this.m_20096_()) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (speedModifier >= 1.5 && this.m_20096_()) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    public boolean m_20161_() {
        return this.m_6047_() || super.m_20161_();
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setHasMane(boolean hasMane) {
        this.f_19804_.m_135381_(HAS_MANE, (Object)hasMane);
    }

    public boolean hasMane() {
        return (Boolean)this.f_19804_.m_135370_(HAS_MANE);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return NaturalistSoundEvents.LION_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.LION_AMBIENT.get();
    }

    public int m_8100_() {
        return 900;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Lion> PlayState predicate(AnimationState<E> event) {
        if (this.m_5803_() && this.hasMane()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sleep2"));
        } else if (this.m_5803_() && !this.hasMane()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sleep"));
        } else if (this.m_20184_().m_165925_() > 1.0E-6) {
            if (this.m_20142_()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("run"));
                event.getController().setAnimationSpeed(2.5);
            } else if (this.m_6047_()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("prey"));
                event.getController().setAnimationSpeed((double)0.8f);
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
                event.getController().setAnimationSpeed(1.0);
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private <E extends Lion> PlayState attackPredicate(AnimationState<E> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().thenPlay("attack"));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate)});
    }

    static class LionPreyGoal
    extends Goal {
        protected final PathfinderMob mob;
        private double speedModifier = 0.5;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;

        public LionPreyGoal(PathfinderMob pathfinderMob) {
            this.mob = pathfinderMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.m_6162_()) {
                return false;
            }
            long gameTime = this.mob.m_9236_().m_46467_();
            if (gameTime - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = gameTime;
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.speedModifier = this.mob.m_20270_((Entity)target) > 12.0f ? 0.5 : 1.5;
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.mob.m_216990_(NaturalistSoundEvents.LION_ROAR.get());
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingEntity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.speedModifier = this.mob.m_20270_((Entity)target) > 12.0f ? 0.5 : 1.5;
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double d = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.mob.m_21574_().m_148306_((Entity)target) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = target.m_20185_();
                this.pathedTargetY = target.m_20186_();
                this.pathedTargetZ = target.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (d > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(target, d);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)enemy);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.mob.m_20205_() * 1.3f * (this.mob.m_20205_() * 1.3f) + attackTarget.m_20205_();
        }
    }

    static class LionFollowParentGoal
    extends FollowParentGoal {
        private final Lion lion;

        public LionFollowParentGoal(Lion animal, double speedModifier) {
            super((Animal)animal, speedModifier);
            this.lion = animal;
        }

        public boolean m_8036_() {
            return !this.lion.m_5803_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.lion.m_5803_() && super.m_8045_();
        }
    }

    static class LionFollowLeaderGoal
    extends Goal {
        private final Lion mob;
        private final Predicate<Mob> followPredicate;
        @Nullable
        private Lion followingMob;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private float oldWaterCost;
        private final float areaSize;

        public LionFollowLeaderGoal(Lion mob, double speedModifier, float stopDistance, float areaSize) {
            this.mob = mob;
            this.followPredicate = followingMob -> followingMob != null && !followingMob.m_6162_();
            this.speedModifier = speedModifier;
            this.navigation = mob.m_21573_();
            this.stopDistance = stopDistance;
            this.areaSize = areaSize;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.m_6162_() || this.mob.hasMane()) {
                return false;
            }
            List nearbyLions = this.mob.m_9236_().m_6443_(Lion.class, this.mob.m_20191_().m_82400_((double)this.areaSize), this.followPredicate);
            if (!nearbyLions.isEmpty()) {
                for (Lion lion : nearbyLions) {
                    if (!lion.hasMane() || lion.m_20145_()) continue;
                    this.followingMob = lion;
                    return true;
                }
                if (this.followingMob == null) {
                    for (Lion lion : nearbyLions) {
                        if (lion.m_6162_() || lion.m_20145_()) continue;
                        this.followingMob = lion;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return this.followingMob != null && !this.navigation.m_26571_() && this.mob.m_20280_((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
            this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.followingMob = null;
            this.navigation.m_26573_();
            this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            double f;
            double e;
            if (this.followingMob == null || this.mob.m_21523_()) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)this.followingMob, 10.0f, (float)this.mob.m_8132_());
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            this.timeToRecalcPath = this.m_183277_(10);
            double d = this.mob.m_20185_() - this.followingMob.m_20185_();
            double g = d * d + (e = this.mob.m_20186_() - this.followingMob.m_20186_()) * e + (f = this.mob.m_20189_() - this.followingMob.m_20189_()) * f;
            if (g <= (double)(this.stopDistance * this.stopDistance)) {
                this.navigation.m_26573_();
                LookControl lookControl = this.followingMob.m_21563_();
                if (g <= (double)this.stopDistance || lookControl.m_24969_() == this.mob.m_20185_() && lookControl.m_24970_() == this.mob.m_20186_() && lookControl.m_24971_() == this.mob.m_20189_()) {
                    double h = this.followingMob.m_20185_() - this.mob.m_20185_();
                    double i = this.followingMob.m_20189_() - this.mob.m_20189_();
                    this.navigation.m_26519_(this.mob.m_20185_() - h, this.mob.m_20186_(), this.mob.m_20189_() - i, this.speedModifier);
                }
                return;
            }
            this.navigation.m_5624_((Entity)this.followingMob, this.speedModifier);
        }
    }
}

