/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Firefly
extends Animal
implements FlyingAnimal,
GeoEntity {
    private static final EntityDataAccessor<Integer> GLOW_TICKS_REMAINING = SynchedEntityData.m_135353_(Firefly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUN_TICKS = SynchedEntityData.m_135353_(Firefly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Firefly(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos pPos) {
                return !Firefly.this.m_9236_().m_8055_(pPos.m_7495_()).m_60795_();
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FireflyHideInGrassGoal(this, 1.2f, 10, 4));
        this.f_21345_.m_25352_(2, (Goal)new FlyingWanderGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public static boolean checkFireflySpawnRules(EntityType<? extends Firefly> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && pLevel.m_8055_(pPos.m_7495_()).m_204336_(NaturalistTags.BlockTags.FIREFLIES_SPAWNABLE_ON);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GLOW_TICKS_REMAINING, (Object)0);
        this.f_19804_.m_135372_(SUN_TICKS, (Object)0);
    }

    public boolean isGlowing() {
        return (Integer)this.f_19804_.m_135370_(GLOW_TICKS_REMAINING) > 0;
    }

    public int getGlowTicksRemaining() {
        return (Integer)this.f_19804_.m_135370_(GLOW_TICKS_REMAINING);
    }

    private void setGlowTicks(int ticks) {
        this.f_19804_.m_135381_(GLOW_TICKS_REMAINING, (Object)ticks);
    }

    public int getSunTicks() {
        return (Integer)this.f_19804_.m_135370_(SUN_TICKS);
    }

    private void setSunTicks(int ticks) {
        this.f_19804_.m_135381_(SUN_TICKS, (Object)ticks);
    }

    public void m_8107_() {
        super.m_8107_();
        int ticks = this.getGlowTicksRemaining();
        if (ticks > 0) {
            this.setGlowTicks(ticks - 1);
        }
        if (this.canGlow() && (double)this.f_19796_.m_188501_() <= 0.01 && !this.isGlowing()) {
            this.setGlowTicks(40 + this.f_19796_.m_188503_(20));
        }
        if (this.m_21527_()) {
            this.setSunTicks(this.getSunTicks() + 1);
            if (this.getSunTicks() > 600) {
                BlockPos pos = this.m_20183_();
                if (!this.m_9236_().f_46443_) {
                    for (int i = 0; i < 20; ++i) {
                        double x = this.f_19796_.m_188583_() * 0.02;
                        double y = this.f_19796_.m_188583_() * 0.02;
                        double z = this.f_19796_.m_188583_() * 0.02;
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1, x, y, z, (double)0.15f);
                    }
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), NaturalistSoundEvents.FIREFLY_HIDE.get(), SoundSource.NEUTRAL, 0.7f, 0.9f + this.m_9236_().f_46441_.m_188501_() * 0.2f);
                this.m_146870_();
            }
        }
    }

    private boolean canGlow() {
        if (!this.m_9236_().f_46443_) {
            return this.m_9236_().m_46462_() || this.m_9236_().m_46803_(this.m_20183_()) < 8;
        }
        return false;
    }

    protected boolean m_21527_() {
        if (this.m_9236_().m_46461_() && !this.m_8077_() && !this.m_9236_().f_46443_) {
            return this.m_213856_() > 0.5f;
        }
        return false;
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % Mth.m_14167_((float)1.4959966f) == 0;
    }

    public boolean m_29443_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_8077_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return NaturalistSoundEvents.FIREFLY_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.FIREFLY_DEATH.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Firefly> PlayState predicate(AnimationState<E> event) {
        if (this.m_29443_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("firefly.fly"));
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    static class FireflyHideInGrassGoal
    extends MoveToBlockGoal {
        private final Firefly firefly;

        public FireflyHideInGrassGoal(Firefly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.firefly = pMob;
        }

        public boolean m_8036_() {
            return this.firefly.m_21527_() && super.m_8036_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_60713_(Blocks.f_50034_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50035_) || pLevel.m_8055_(pPos).m_60713_(Blocks.f_50359_);
        }

        public void m_8037_() {
            super.m_8037_();
            Level level = this.firefly.m_9236_();
            if (this.m_25625_()) {
                if (!level.f_46443_) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50034_.m_49966_()), this.firefly.m_20185_(), this.firefly.m_20186_(), this.firefly.m_20189_(), 50, (double)(this.firefly.m_20205_() / 4.0f), (double)(this.firefly.m_20206_() / 4.0f), (double)(this.firefly.m_20205_() / 4.0f), 0.05);
                }
                level.m_5594_(null, this.firefly.m_20183_(), NaturalistSoundEvents.FIREFLY_HIDE.get(), SoundSource.NEUTRAL, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                this.firefly.m_146870_();
            }
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }
    }
}

