/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Bear;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class BearModel
extends GeoModel<Bear> {
    public ResourceLocation getModelResource(Bear bear) {
        return new ResourceLocation("naturalist", "geo/bear.geo.json");
    }

    public ResourceLocation getTextureResource(Bear bear) {
        if (bear.m_21660_()) {
            return new ResourceLocation("naturalist", "textures/entity/bear/bear_angry.png");
        }
        if (bear.m_5803_()) {
            return new ResourceLocation("naturalist", "textures/entity/bear/bear_sleep.png");
        }
        if (bear.isEating()) {
            if (bear.m_21205_().m_150930_(Items.f_42780_)) {
                return new ResourceLocation("naturalist", "textures/entity/bear/bear_berries.png");
            }
            if (bear.m_21205_().m_150930_(Items.f_42784_)) {
                return new ResourceLocation("naturalist", "textures/entity/bear/bear_honey.png");
            }
            return new ResourceLocation("naturalist", "textures/entity/bear/bear.png");
        }
        return new ResourceLocation("naturalist", "textures/entity/bear/bear.png");
    }

    public ResourceLocation getAnimationResource(Bear bear) {
        return new ResourceLocation("naturalist", "animations/bear.animation.json");
    }

    public void setCustomAnimations(Bear animatable, long instanceId, AnimationState<Bear> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (animatable.m_6162_()) {
            head.setScaleX(1.8f);
            head.setScaleY(1.8f);
            head.setScaleZ(1.8f);
        } else {
            head.setScaleX(1.0f);
            head.setScaleY(1.0f);
            head.setScaleZ(1.0f);
        }
        if (!(animatable.m_5803_() || animatable.isEating() || animatable.isSitting())) {
            head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
            head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

